#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>

#include <X11/Xlib.h>

#undef Bool

#include "dixstruct.h"
#include "glxcommon.h"
#include "glxlib.h"



#define GC XXGC
#include "gcstruct.h"
#include "pixmapstr.h"
#include "servermd.h" /* PixmapBytePad */
#include "scrnintstr.h"
#include "regionstr.h"
#include "windowstr.h"
#include "extnsionst.h"
#undef GC

#include "vga.h"
#include "vgaPCI.h"
#include "xaa/xf86xaa.h"

#include "direct_protocol.h"
#include "direct_resources.h"

/* Fake the parts of the XServer needed to support glx.so
 */

static ExtensionEntry directExtension;


int LocalClient(ClientPtr client)
{
   return 1;			/* always */
}

ExtensionEntry *AddExtension(
    char* name,
    int NumEvents,
    int NumErrors,
    int (*MainProc)(ClientPtr client),
    int (*SwappedMainProc)(ClientPtr client),
    void (*CloseDownProc)(ExtensionEntry * extension),
    unsigned short (*MinorOpcodeProc)(ClientPtr client))
{
   /* directExtension could filled with information from the server
    * in client-initialization of glx.so, but I'm going to wing it.
    */
   directExtension.MinorOpcode = MinorOpcodeProc;
   directExtension.CloseDown = CloseDownProc;
   directExtension.eventBase = 0;
   directExtension.eventLast = NumEvents;
   directExtension.errorBase = 0;
   directExtension.errorLast = NumErrors;
   directExtension.name = name;

   return &directExtension;
}

extern unsigned short StandardMinorOpcode(ClientPtr client)
{
   return 1;			
}

void ErrorF(char* f, ...)
{
   va_list ap;
   va_start(ap, f);
   (void) vfprintf(stderr, f, ap);
   va_end(ap);
}

void FatalError(char* f, ...)
{
   va_list ap;
   va_start(ap, f);
   (void) vfprintf(stderr, f, ap);
   va_end(ap);
   exit(1);
}


unsigned long *Xalloc(unsigned long amount)
{
   return (unsigned long *)malloc(amount);
}

#undef Xfree
void Xfree(void * ptr)
{
   free(ptr);
}

XID FakeClientID(int client)
{
   static int i;
   return ++i;
}


#if defined(MGA)
#include "mga.h"
unsigned char *MGAMMIOBase = (pointer) -1;
MGARamdacRec MGAdac;		/* only partially filled */
pciTagRec MGAPciTag;
int MGAchipset;
int MGAydstorg;
Bool MGAUsePCIRetry;
int MGAIsSDRAM;
#endif

#if defined(I810)
#include "i810.h"

I810MemRange I810DcacheMem;
int I810Chipset;

/* These values are never referenced by the client, but must be
 * present to avoid undefined symbol errors.
 */
I810RingBuffer I810LpRing;
unsigned char *I810MMIOBase = (pointer) -1;
int I810FrameBufferLocked = 0;
void I810PrintErrorState( void ) 
{ 
   /* Never called */
}
int vgaBytesPerPixel;
#endif


PaddingInfo PixmapWidthPaddingInfo[33];
ScreenInfo screenInfo;
xf86AccelInfoRecType xf86AccelInfoRec;
PciProbeType xf86PCIFlags;
ScrnInfoRec vga256InfoRec;
int vgaBitsPerPixel;
int vgaLinearSize;
pointer vgaLinearBase = (pointer) -1;
int xf86VTSema = 1;		/* need to figure out how this works */


int mylog2( unsigned int foo )
{
   int val = 0;
   while (foo>>=1) val++;
   return val;
}


void 
__glx_init_server_environment( Display *dpy, int scr )
{
   int nvi = 0;
   XVisualInfo viproto;
   XVisualInfo *vip;
   Screen *screen = &dpy->screens[scr];
   XPixmapFormatValues *pmf;
   int i, n;
       
   
   /* Basic info
    */
   directScreen.myNum = 0;	/* index into Screens, but Screens not ref'd */
   directScreen.id = scr;	/* i suppose  */
   directScreen.width = screen->width;
   directScreen.height = screen->height;
   directScreen.mmWidth = screen->mwidth;
   directScreen.mmHeight = screen->mheight;
   

   /* Build the list of depths.
    */
   directScreen.numDepths = screen->ndepths;
   directScreen.allowedDepths = malloc( sizeof(DepthRec) * screen->ndepths );
   directScreen.rootDepth = screen->root_depth;


   for (i = 0 ; i < screen->ndepths ; i++) {
      int j;
      DepthPtr d = &directScreen.allowedDepths[i];

      d->depth = screen->depths[i].depth;
      d->numVids = screen->depths[i].nvisuals;
      d->vids = (VisualID *) malloc( sizeof(VisualID) *
				     screen->depths[i].nvisuals );

      for (j = 0 ; j < screen->depths[i].nvisuals ; j++) 
	 d->vids[j] = screen->depths[i].visuals[j].visualid;
   }   

   directScreen.rootVisual = screen->root_visual->visualid;
   directScreen.defColormap = screen->cmap;  /* same namespace? doubt it */
   directScreen.minInstalledCmaps = screen->min_maps;
   directScreen.maxInstalledCmaps = screen->max_maps;
   directScreen.backingStoreSupport = screen->backing_store;
   directScreen.saveUnderSupport = screen->save_unders;
   directScreen.whitePixel = screen->white_pixel;
   directScreen.blackPixel = screen->black_pixel;
   directScreen.rgf = 0;	/* hungarian??? wtf??? */
/*     directScreen.GCperDepth = 0;	 */
   directScreen.PixmapPerDepth[0] = 0; /* not used */
   directScreen.devPrivate = 0;	/* not used */

   /* build the list of visuals.
    */
   nvi = 0;
   viproto.screen = scr;
   vip = XGetVisualInfo (dpy, VisualScreenMask, &viproto, &nvi);

   if (!vip) 
      fprintf(stderr, "no visuals!\n");
   else {
      directScreen.numVisuals = nvi;
      directScreen.visuals = (VisualPtr) malloc( sizeof(VisualRec) * nvi );

      for (i = 0; i < nvi; i++) {
	 int j,k;
	 VisualPtr v = &directScreen.visuals[i];
	 v->vid = vip[i].visualid;
	 v->class = vip[i].class;
	 v->bitsPerRGBValue = vip[i].bits_per_rgb;
	 v->ColormapEntries = vip[i].colormap_size;
	 v->redMask = vip[i].red_mask;
	 v->greenMask = vip[i].green_mask;
	 v->blueMask = vip[i].blue_mask;
	 
	 for (j = 0 ; j < screen->ndepths ; j++)
	    for (k = 0 ; k < screen->depths[j].nvisuals ; k++)
	       if (screen->depths[j].visuals[k].visualid == v->vid) {
		  v->nplanes = screen->depths[j].depth;
		  break;
	       }
      }

      XFree((char *) vip);
   }

   /* none of these are used: */
   directScreen.WindowPrivateLen = 0;
   directScreen.WindowPrivateSizes = 0;
   directScreen.totalWindowSize = 0;
   directScreen.GCPrivateLen = 0;
   directScreen.GCPrivateSizes = 0;
   directScreen.totalGCSize = 0;
   
   /* none of the ProcPtr's are used, providing the buffers are all
    * ximages.  Need to fallback to indirect rendering if we are using
    * pixmaps for *anything*..
    */


   /* Build screenInfo... Fix this code for >1 screen
    */ 
   screenInfo.numScreens = 1;
   screenInfo.screens[0] = &directScreen;


   /* Build pixmap padding info.
    */
   pmf = XListPixmapFormats (dpy, &n);
   if (pmf) {
      for (i = 0; i < n; i++) {
	 PaddingInfo *pi = &PixmapWidthPaddingInfo[i];
	 int pixels_per_pad = pmf[i].scanline_pad / pmf[i].bits_per_pixel;

	 pi->padRoundUp = pixels_per_pad - 1;
	 pi->padPixelsLog2 = mylog2(pixels_per_pad);
	 pi->padBytesLog2 = mylog2(pmf[i].scanline_pad / 8);
	 pi->notPower2 = ((1<<mylog2(pmf[i].bits_per_pixel)) != 
			  pmf[i].bits_per_pixel);
	 pi->bytesPerPixel = (pmf[i].bits_per_pixel + 7)>>4; /* maybe */
      }
      XFree ((char *) pmf);
   }
}




