#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>

#undef Bool


#include "dixstruct.h"
#include "glxcommon.h"
#include "glxlib.h"

#define GC XXGC
#include "gcstruct.h"
#include "pixmapstr.h"
#include "servermd.h" /* PixmapBytePad */
#include "scrnintstr.h"
#include "regionstr.h"
#include "windowstr.h"
#undef GC


#include "direct_protocol.h"
#include "extensions.h"

/* All interactions with this protocol will be atomic.  Threading is
 * not considered.
 */
static ClientRec *directClient;


/* It is also a lot easier if there is just a single direct display.
 */
Display *directDisplay;
ScreenRec directScreen;
int directScreenNum = 0;

/* The server->client communication chanel.
 */
char *glx_buf;
int glx_buf_tail, glx_buf_head;
static int glx_buf_size;

static int fake_XFlush( Display *dpy );
static int fake_XSync( Display *dpy, Bool discard );
static void fake_GLXRenderFlush( void );
static int fake_XRead( Display *dpy, char *data, long num_bytes);
static int fake_XReply( Display *display, xReply *reply, int, Bool );
static void flush_request( xReq *pending );

Proto directProto = {
   fake_XReply,
   fake_XRead,
   0,				/* XSend */
   fake_GLXRenderFlush,
   fake_GLXRenderFlush,
   fake_XFlush,		
   fake_XSync,		
   flush_request,
   0,				/* pending request */
   0,				/* api table - will be filled via dlsym() */
   0,                           /* glx table - points to __glx_dispatch_tab */
   True,			/* isDirect */
};

extern void GLXLargeRenderFlush();
extern void GLXRenderFlush();

Proto xProto = {
   _XReply,
   _XRead,
   _XSend,
   GLXRenderFlush,
   GLXLargeRenderFlush,
   XFlush,
   XSync,
   0,
   0,				/* pending */
   0,				/* api table -- fill me? */
   0,				/* glx table - not used */
   False			/* is_direct */
};



/* Call the appropriate function in glx.so.  Need to find out the
 * current x error handler & call it on failure.
 */
static void flush_request( xReq *pending ) 
{
   int opcode = pending->data;	/* glx_opcode */
   int len = pending->length; 
   int retval;
   int (*func)( ClientPtr );


   if (glx_buf_tail - glx_buf_head > 0) 
      fprintf(stderr, 
	      "fake_protocol - discarding %d uncollected bytes in buffer\n", 
	      glx_buf_tail - glx_buf_head);

   glx_buf_tail = glx_buf_head = 0;
   directClient->requestBuffer = directProto.pending;
   directClient->req_len = len;
   directProto.pending = 0;

   func = ((int (**)( ClientPtr ))directProto.dispatch_table)[opcode];
   retval = func( directClient );
   
   if (retval != Success) {
      fprintf(stderr, 
	      "Proper X error handling not implemented.\n"
	      "X Error %d for GLX request opcode %d\n",
	      retval, opcode );
      
      /* Clean up hardware and exit.
       */
      exit(1);
   }
}


static int fake_XReply( Display *display, xReply *reply, int who, Bool knows )
{
   if (directProto.pending) flush_request( directProto.pending );

   if (glx_buf_tail - glx_buf_head < sizeof(xReply)) {
      fprintf(stderr, "not enough bytes for an xReply in buffer!\n");
      return 0;
   }

   *reply = *(xReply *)(glx_buf + glx_buf_head);
   glx_buf_head += sizeof(xReply);
   return 1;
}


static int fake_XRead( Display *dpy, char *data, long num_bytes )
{
   if (directProto.pending) flush_request( directProto.pending );

   num_bytes = (num_bytes + 3) & ~3;
   memcpy(data, glx_buf + glx_buf_head, num_bytes);
   glx_buf_head += num_bytes;
   return 1;
}


/* Is this right?  
 */
static void fake_GLXRenderFlush( void )
{
}

   
static int fake_XSync( Display *dpy, Bool discard )
{
   return 1;			/* hmm */
}

static int fake_XFlush( Display *dpy )
{
   return 1;		
}


/* The server side of the fake protocol.  No need to use indirection
 * as glx.so will only ever be direct or indirect - it doesn't have to
 * switch at runtime.  
 */
int WriteToClient(ClientPtr who, int count, char* server_buf)
{
   count = (count + 3) & ~3;

   if (glx_buf_tail + count > glx_buf_size) 
   {
      while ((glx_buf_size *= 2) < count);
      glx_buf = (char *) realloc( glx_buf, glx_buf_size );
   }
   
   memcpy( glx_buf + glx_buf_tail, server_buf, count );
   glx_buf_tail += count;
   return count;
}

/* Flush the communications to the client.
 */
void FlushAllOutput(void)
{
   /* Nothing to do on direct proto... */
}

void glx_init_fake_protocol()
{
}

static void *handle;
static struct gl_api_table direct_api_tab;

/* The glx.so module writes to these, which are normally exported by
 * the server.
 */
void (*GlxExtensionInitPtr)(void);
Bool (*GlxInitVisualsPtr)(VisualPtr *         visualp,
			  DepthPtr *          depthp,
			  int *               nvisualp,
			  int *               ndepthp,
			  int *               rootDepthp,
			  VisualID *          defaultVisp,
			  unsigned long       sizes,
			  int                 bitsPerRGB);



extern int __glx_init_direct_execution_pointers( void *handle, 
						 struct gl_api_table *table );

extern void __glx_init_server_environment( Display *dpy, int scr );


int xf86Verbose = 3;
int xf86PCIFlags;

void (*__glx_release_hook)( void ) = 0;




Bool __glx_init_direct( Display *dpy, char *reply )
{
   extern int xf86_external_pci_init( int scrnIndex );
   ClientPtr (*init_func)( char *, int (*)(), void (**)(void) );
   void *(*GlxAddClientPtr)(ClientPtr client);

   fprintf(stderr, "got reply %s\n", reply);

   if (handle) 
      return 0;			/* should never happen */

   fprintf(stderr, "try to open /usr/X11R6/lib/modules/glx.so:\n");
 
   /* FIXME: this path shouldn't be hardwired! */
   if ((handle = dlopen("/usr/X11R6/lib/modules/glx.so", RTLD_LAZY)) == 0) {
      fputs (dlerror(), stderr);
      goto error_open;
   }

   fprintf(stderr, "opened /usr/X11R6/lib/modules/glx.so\n");

   /* Call initialization functions in glx.so.
    */
   if ((init_func = dlsym(handle, reply)) == 0)
      goto error_sym;

   fprintf(stderr, "found init func\n");
	 

   if (!__glx_init_direct_execution_pointers( handle, &direct_api_tab ))
      goto error_sym;

   fprintf(stderr, "got api pointers\n");

   if (!(directProto.dispatch_table = dlsym(handle, "__glx_dispatch_table")))
      goto error_sym;

   fprintf(stderr, "got dispatch table\n");

   if (!(GlxExtensionInitPtr = dlsym(handle, "GlxExtensionInit")))
      goto error_sym;

   if (!(GlxInitVisualsPtr = dlsym(handle, "GlxInitVisuals")))
      goto error_sym;

   if (!(GlxAddClientPtr = dlsym(handle, "__glXAddClient")))
      goto error_sym;

   fprintf(stderr, "got glx init pointers\n");

   directProto.api_table = &direct_api_tab;


   fprintf(stderr, "calling init func:\n");

   directClient = init_func(reply, 
			    (int (*)()) __glx_send_vendor_private_with_reply,
			    (void (**)()) &__glx_release_hook);
   
   if (!directClient || !__glx_release_hook)
      goto error_init;

   fprintf(stderr, "calling pci init:\n");

   if (!xf86_external_pci_init(0))
      goto error_pci;
      
   
   /* bzzt - hardwire screen 0.
    */
   fprintf(stderr, "build server environment:\n");

   directDisplay = dpy;
 
   __glx_init_server_environment( directDisplay, 0 );


   fprintf(stderr, "glx init visuals: %p\n", GlxInitVisualsPtr);

   /* This is ugly - the initvisuals code is incomprehensible.
    */
   {
      int numvis = 1;
      int numdep = directScreen.numDepths;
      int rootdep = directScreen.rootDepth;
      VisualID rootvis = directScreen.rootVisual;

      VisualPtr visp = (VisualPtr) malloc( sizeof(VisualRec) * numvis );
      DepthPtr depp = (DepthPtr) malloc( sizeof(DepthRec) * numdep );

      int i;

		 

      for (i = 0 ; i < numdep ; i++) {
	 memcpy(&depp[i], &directScreen.allowedDepths[i], sizeof(DepthRec));

	 if (!depp[i].vids) continue;
	 
	 depp[i].vids = (VisualID *)malloc(depp[i].numVids * sizeof(VisualID));
	 memcpy(depp[i].vids, 
		directScreen.allowedDepths[i].vids,
		depp[i].numVids * sizeof(VisualID));
      }

      for (i = 0 ; i < numvis ; i++) 
	 memcpy( &visp[i], &directScreen.visuals[i], sizeof(VisualRec) );

      GlxInitVisualsPtr( &visp,
			 &depp,
			 &numvis,
			 &numdep,
			 &rootdep,
			 &rootvis,
			 0,	/* sizes -- what is it? not used... */
			 0 );	/* bitsperRGB -- in what visual? not used... */
   }

   fprintf(stderr, "glx extension init: %p\n", GlxExtensionInitPtr);

   GlxExtensionInitPtr();

   fprintf(stderr, "adding direct client: \n");

   GlxAddClientPtr( directClient );
   
   glx_buf_size = 512;
   glx_buf = (char *) malloc( glx_buf_size );
   glx_buf_head = glx_buf_tail = 0;

   fprintf(stderr, "finished __glx_init_direct:\n");
     
   return 1;

   /* Error cases:
    */
 error_pci: 
 error_init:
 error_sym: 
 error_open:
   __glx_unload_direct();
   fprintf(stderr, "failed to load glx.so\n");
   return 0;
}

void __glx_unload_direct( void )
{
   if (handle) {
      if (__glx_release_hook)
	 __glx_release_hook();
      dlclose(handle);
      handle = 0;
      __glx_release_hook = 0;
      directDisplay = 0;
   }
}


static void __attribute__ ((destructor))
unload_direct( void )
{
   __glx_unload_direct();
}







