#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>

#undef Bool

#define GC XXGC
#include "gcstruct.h"
#include "pixmapstr.h"
#include "servermd.h" /* PixmapBytePad */
#include "scrnintstr.h"
#include "regionstr.h"
#include "windowstr.h"
#undef GC

#include "direct_resources.h"
#include "direct_protocol.h"


/* Translate the server-side gc (and color) calls used by glx.so into
 * things which make sense on the client.  Most stuff isn't
 * implemented - this is just enough to make glx.so happy.  
 *
 * If we ever get proper locking between server & client it will be
 * interesting to see if we can avoid deadlocks as a result of this
 * code.
 *
 */
void fake_FillSpans(DrawablePtr pDrawable,
		    GCPtr pGC,
		    int nInit,
		    DDXPointPtr pptInit,
		    int * pwidthInit,
		    int fSorted)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op FillSpans called\n");
}

void fake_SetSpans(DrawablePtr pDrawable,
		   GCPtr pGC,
		   char * psrc,
		   DDXPointPtr ppt,
		   int * pwidth,
		   int nspans,
		   int fSorted)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op SetSpans called\n");
}

void fake_PutImage(DrawablePtr pDrawable,
		   GCPtr pGC,
		   int depth,
		   int x,
		   int y,
		   int w,
		   int h,
		   int leftPad,
		   int format,
		   char * pBits)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op PutImage called\n");
}

RegionPtr fake_CopyArea(DrawablePtr pSrc,
			DrawablePtr pDst,
			GCPtr pGC,
			int srcx,
			int srcy,
			int w,
			int h,
			int dstx,
			int dsty)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op CopyArea called\n");
   return 0;
}

RegionPtr fake_CopyPlane(DrawablePtr pSrcDrawable,
			 DrawablePtr pDstDrawable,
			 GCPtr pGC,
			 int srcx,
			 int srcy,
			 int width,
			 int height,
			 int dstx,
			 int dsty,
			 unsigned long bitPlane)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op CopyPlane called\n");
   return 0;
}


void fake_PolyPoint(DrawablePtr pDrawable,
		    GCPtr pGC,
		    int mode,
		    int npt,
		    DDXPointPtr pptInit)
{
   GC gc = find_client_gc_from_ptr( pGC );
   Drawable d = find_client_drawable_from_ptr( pDrawable );

   fprintf(stderr, "fake gc op PolyPoint called\n");

   if (gc && d) {
      XPoint *points = (XPoint *)pptInit;


      XDrawPoints( directDisplay,
		   d,
		   gc,
		   points,
		   npt,
		   mode );
   }
}

void fake_Polylines(DrawablePtr pDrawable,
		    GCPtr pGC,
		    int mode,
		    int npt,
		    DDXPointPtr pptInit)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op Polylines called\n");
}

void fake_PolySegment(DrawablePtr pDrawable,
		      GCPtr pGC,
		      int nseg,
		      xSegment * pSegs)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op PolySegment called\n");
}

void fake_PolyRectangle(DrawablePtr pDrawable,
			GCPtr pGC,
			int nrects,
			xRectangle * pRects)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op PolyRectangle called\n");
}

void fake_PolyArc(DrawablePtr pDrawable,
		  GCPtr pGC,
		  int narcs,
		  xArc * parcs)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op PolyArc called\n");
}

void fake_FillPolygon(DrawablePtr pDrawable,
		      GCPtr pGC,
		      int shape,
		      int mode,
		      int count,
		      DDXPointPtr pPts)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op FillPolygon called\n");
}

void fake_PolyFillRect(DrawablePtr pDrawable,
		       GCPtr pGC,
		       int nrectFill,
		       xRectangle * prectInit)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op PolyFillRect called\n");
}

void fake_PolyFillArc(DrawablePtr pDrawable,
		      GCPtr pGC,
		      int narcs,
		      xArc * parcs)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op PolyFillArc called\n");
}

int fake_PolyText8(DrawablePtr pDrawable,
		   GCPtr pGC,
		   int x,
		   int y,
		   int count,
		   char * chars)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op PolyText8 called\n");
   return 0;
}

int fake_PolyText16(DrawablePtr pDrawable,
		    GCPtr pGC,
		    int x,
		    int y,
		    int count,
		    unsigned short * chars)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op PolyText16 called\n");
   return 0;
}

void fake_ImageText8(DrawablePtr pDrawable,
		     GCPtr pGC,
		     int x,
		     int y,
		     int count,
		     char * chars)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op ImageText8 called\n");
}

void fake_ImageText16(DrawablePtr pDrawable,
		      GCPtr pGC,
		      int x,
		      int y,
		      int count,
		      unsigned short * chars)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op ImageText16 called\n");
}

void fake_ImageGlyphBlt(DrawablePtr pDrawable,
			GCPtr pGC,
			int x,
			int y,
			unsigned int nglyph,
			CharInfoPtr * ppci,
			pointer pglyphBase)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op ImageGlyphBlt called\n");
}

void fake_PolyGlyphBlt(DrawablePtr pDrawable,
		       GCPtr pGC,
		       int x,
		       int y,
		       unsigned int nglyph,
		       CharInfoPtr * ppci,
		       pointer pglyphBase)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op PolyGlyphBlt called\n");
}

void fake_PushPixels(GCPtr pGC,
		     PixmapPtr pBitMap,
		     DrawablePtr pDst,
		     int w,
		     int h,
		     int x,
		     int y)
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op PushPixels called\n");
}

void fake_LineHelper()
{
   fprintf(stderr, "NONIMPLEMENTED fake gc op LineHelper called\n");
}


struct _GCOps fake_gcops = {
   fake_FillSpans,
   fake_SetSpans,
   fake_PutImage,
   fake_CopyArea,
   fake_CopyPlane,
   fake_PolyPoint,
   fake_Polylines,
   fake_PolySegment,
   fake_PolyRectangle,
   fake_PolyArc,
   fake_FillPolygon,
   fake_PolyFillRect,
   fake_PolyFillArc,
   fake_PolyText8,
   fake_PolyText16,
   fake_ImageText8,
   fake_ImageText16,
   fake_ImageGlyphBlt,
   fake_PolyGlyphBlt,
   fake_PushPixels,

#ifdef NEED_LINEHELPER
   fake_LineHelper,
#endif

   { 0 }
};


/* Lots of the state-change code seems to leak into this call.  Make
 * it quick, I doubt any of these changes will ever be realized in a
 * double-buffered context.
 */
int DoChangeGC(GCPtr pGC,
	       BITS32 mask,
	       XID* pval,
	       int fPointer)
{
   gc_map *gc = find_gc_map_from_ptr( pGC );

   if (!gc) return 0;

   switch (mask) {
   case GCFunction:
      gc->xgcv.function = * pval;
      break;
   case GCForeground:
      gc->xgcv.foreground = * pval;
      break;
   case GCPlaneMask:
      gc->xgcv.plane_mask = * pval;
      break;
   default:
      /* Since I'm not even pretending that this is complete, I'll
       * leave it at that.
       */
      fprintf(stderr, "non-implemented fake gc mask %x\n", (int) mask);
      return 1;
   }

   gc->mask |= mask;

   return 1;
}



void ValidateGC(DrawablePtr pDraw, GCPtr pGC)
{
   /* What does it do???
    */
}


/* It's all a bit silly really, but I like it.
 */
int AllocColor(ColormapPtr pmap,
	       unsigned short* pred,
	       unsigned short* pgreen,
	       unsigned short* pblue,
	       Pixel* pPix,
	       int client)
{
   Status rv = -1;
   Colormap cmap = 0;
   XColor col = { *pPix, *pred, *pgreen, *pblue, ~0, 0 };
   Display *dpy = directDisplay;
   int scr = directScreenNum;


/* No create colormap calls, so I guess it must always be the default???
  
   for (i = 0 ; i < nr_active_cmaps ; i++)
      if (cmap_list[i].ptr == pmap) {	
	 cmap = cmap_list[i].cmap;
	 break;
      }
*/

   if (!cmap) cmap = DefaultColormap(dpy, scr);

   rv =  XAllocColor(dpy, cmap, &col);

   *pPix = col.pixel;
   *pred = col.red;
   *pgreen = col.green;
   *pblue = col.blue;

	 
   fprintf(stderr, "fakeXServer: AllocColor %d %d %d --> %d\n", 
	   *pred, *pgreen, *pblue, rv);


   return rv;
}

int QueryColors(ColormapPtr pmap,
		int count,
		Pixel* ppixIn,
		xrgb* prgbList)
{
   Colormap cmap = 0;
   XColor *colors = (XColor *) malloc(count * sizeof(XColor));
   int rv, i;

   if (!cmap) cmap = DefaultColormap(directDisplay, directScreenNum);

   for (i = 0 ; i < count ; i++) 
      colors[i].pixel = ppixIn[i];

   rv = XQueryColors( directDisplay, cmap, colors, count );
		 
   for (i = 0 ; i < count ; i++) {
      prgbList[i].red = colors[i].red;
      prgbList[i].green = colors[i].green;
      prgbList[i].blue = colors[i].blue;
   }

   free(colors);
   return rv;
}
