#!/bin/sh

if [ "$1" == "" ] || [ "$1" == "--help" ]; then

    echo ""
    echo "Verifies that EDID file matches EDID from dev kit add-in card. Error level zero indicates a match."
    echo ""
    echo "Usage:"
    echo "verifyedid-devkit.sh <one-based connector index> SLOT<one-based board index> <path to EDID file>"
    echo ""
    echo "Example:"
    echo "verifyedid-devkit.sh 1 SLOT1 /tmp/firmwareupdate/Edid-SV2DEVKIT-1.bin"
    echo ""
    
else
    
    index=$1
    index=$((index-1))
    slotindex=$(echo $2 | cut -f2 -d'T')
    
    if [ "$4" == "" ]; then

        REDIRECTERRORS=/dev/null

    else

        REDIRECTERRORS=$4

    fi    
    
    SV2DRIVER=$(/usr/local/bin/MtxBoardInfo >& /dev/null ; echo $?)

    if [ ${SV2DRIVER} -eq "0" ]; then

        /usr/local/bin/MtxEdidFlasher -l > EDID_$2_$1.txt 2> ${REDIRECTERRORS}

    else

        ./InitMemContext >& /dev/null
        ./MtxEdidFlasher-NoDrv -l > EDID_$2_$1.txt 2> ${REDIRECTERRORS}

    fi
    
    index=$(cat EDID_$2_$1.txt | grep "Add-in slot$slotindex HDMI$1" | cut -f2 -d'#' | cut -f1 -d' ')
    
    if [ ${SV2DRIVER} -eq "0" ]; then

        /usr/local/bin/MtxEdidFlasher -c $index -v -f $3 > /tmp/edid.txt 2> ${REDIRECTERRORS}

    else

        ./MtxEdidFlasher-NoDrv -c $index -v -f $3 > /tmp/edid.txt 2> ${REDIRECTERRORS}

    fi
    
    cat /tmp/edid.txt | grep "EDIDs match" > /dev/null
    echo $?
    
fi
