#!/bin/sh

if [ "$1" == "" ] || [ "$1" == "--help" ]; then

    echo ""
    echo "Reads EDID from SV2-based device."
    echo ""
    echo "Usage:"
    echo "readedid.sh <one-based connector index>"
    echo ""
    echo "Example:"
    echo "readedid.sh 1"
    echo ""

else

    index=$1
    index=$((index-1))
    
    if [ "$2" == "" ]; then

        REDIRECTERRORS=/dev/null

    else

        REDIRECTERRORS=$2

    fi
    
    SV2DRIVER=$(/usr/local/bin/MtxBoardInfo >& /dev/null ; echo $?)
    
    if [ ${SV2DRIVER} -eq "0" ]; then

        /usr/local/bin/MtxEdidFlasher -c $index -d > /tmp/edid.dat 2> ${REDIRECTERRORS}

    else

        ./InitMemContext >& /dev/null
        ./MtxEdidFlasher-NoDrv -c $index -d > /tmp/edid.dat 2> ${REDIRECTERRORS}

    fi
    
    cat /tmp/edid.dat
    rm /tmp/edid.dat >& /dev/null
    
fi
