/*
** Copyright 2002 Matrox Graphics, Inc.
** All Rights Reserved.
*/

#ifndef __glx_h_
#define __glx_h_

#ifdef __cplusplus
extern "C" {
#endif

#ifndef XFree86Server
 #include <X11/Xlib.h>
 #include <X11/Xutil.h>
 #include <X11/Xmd.h>
 #include <GL/gl.h>
#endif

#define GLX_VERSION_1_1 1
#define GLX_VERSION_1_2 1
#define GLX_VERSION_1_3 1

/* glXGetConfig attributes */
#define GLX_USE_GL              1   /* support GLX rendering */
#define GLX_BUFFER_SIZE         2   /* depth of the color buffer */
#define GLX_LEVEL               3   /* level in plane stacking */
#define GLX_RGBA                4   /* true if RGBA mode */
#define GLX_DOUBLEBUFFER        5   /* double buffering supported */
#define GLX_STEREO              6   /* stereo buffering supported */
#define GLX_AUX_BUFFERS         7   /* number of aux buffers */
#define GLX_RED_SIZE            8   /* number of red component bits */
#define GLX_GREEN_SIZE          9   /* number of green component bits */
#define GLX_BLUE_SIZE           10  /* number of blue component bits */
#define GLX_ALPHA_SIZE          11  /* number of alpha component bits */
#define GLX_DEPTH_SIZE          12  /* number of depth bits */
#define GLX_STENCIL_SIZE        13  /* number of stencil bits */
#define GLX_ACCUM_RED_SIZE      14  /* number of red accum bits */
#define GLX_ACCUM_GREEN_SIZE    15  /* number of green accum bits */
#define GLX_ACCUM_BLUE_SIZE     16  /* number of blue accum bits */
#define GLX_ACCUM_ALPHA_SIZE    17  /* number of alpha accum bits */

#define GLX_SAMPLE_BUFFERS_ARB  100000  /* number of multisample buffers */
#define GLX_SAMPLES_ARB         100001  /* number of multisample samples */

/* GLXFBConfig-specific attributes */
#define GLX_X_VISUAL_TYPE               0x22
#define GLX_CONFIG_CAVEAT               0x20    /* Like visual_info VISUAL_CAVEAT */
#define GLX_TRANSPARENT_TYPE            0x23
#define GLX_TRANSPARENT_INDEX_VALUE     0x24
#define GLX_TRANSPARENT_RED_VALUE       0x25
#define GLX_TRANSPARENT_GREEN_VALUE     0x26
#define GLX_TRANSPARENT_BLUE_VALUE      0x27
#define GLX_TRANSPARENT_ALPHA_VALUE     0x28
#define GLX_DRAWABLE_TYPE               0x8010
#define GLX_RENDER_TYPE                 0x8011
#define GLX_X_RENDERABLE                0x8012
#define GLX_FBCONFIG_ID                 0x8013
#define GLX_MAX_PBUFFER_WIDTH           0x8016
#define GLX_MAX_PBUFFER_HEIGHT          0x8017
#define GLX_MAX_PBUFFER_PIXELS          0x8018
#define GLX_VISUAL_ID                   0x800B                                  

/* glXGetConfig error values */
#define GLX_BAD_SCREEN          1   /* screen # is bad */
#define GLX_BAD_ATTRIBUTE       2   /* attribute to get is bad */
#define GLX_NO_EXTENSION        3   /* no glx extension on server */
#define GLX_BAD_VISUAL          4   /* visual # not known by GLX */
#define GLX_BAD_CONTEXT         5   /* invalid context */
#define GLX_BAD_VALUE           6   /* invalid parameter */
#define GLX_BAD_ENUM            7   /* invalid enum value */

/* GLXFBConfig attributes value */
#define GLX_DONT_CARE                   0xFFFFFFFF
#define GLX_RGBA_BIT                    0x00000001
#define GLX_COLOR_INDEX_BIT             0x00000002
#define GLX_WINDOW_BIT                  0x00000001
#define GLX_PIXMAP_BIT                  0x00000002
#define GLX_PBUFFER_BIT                 0x00000004
#define GLX_NONE                        0x8000
#define GLX_SLOW_CONFIG                 0x8001
#define GLX_NON_CONFORMANT_CONFIG       0x800D
#define GLX_TRUE_COLOR                  0x8002
#define GLX_DIRECT_COLOR                0x8003
#define GLX_PSEUDO_COLOR                0x8004
#define GLX_STATIC_COLOR                0x8005
#define GLX_GRAY_SCALE                  0x8006
#define GLX_STATIC_GRAY                 0x8007
#define GLX_TRANSPARENT_RGB             0x8008
#define GLX_TRANSPARENT_INDEX           0x8009
     
/* glXCreateGLXPbuffer attributes */
#define GLX_PRESERVED_CONTENTS          0x801B
#define GLX_LARGEST_PBUFFER             0x801C
#define GLX_PBUFFER_HEIGHT              0x8040
#define GLX_PBUFFER_WIDTH               0x8041
#define GLX_PRESERVED_CONTENTS_SGIX     GLX_PRESERVED_CONTENTS
#define GLX_LARGEST_PBUFFER_SGIX        GLX_LARGEST_PBUFFER
     
/* glXQueryGLXPbuffer attributes */
#define GLX_WIDTH                       0x801D
#define GLX_HEIGHT                      0x801E
#define GLX_EVENT_MASK                  0x801F
#define GLX_WIDTH_SGIX                  GLX_WIDTH
#define GLX_HEIGHT_SGIX                 GLX_HEIGHT
#define GLX_EVENT_MASK_SGIX             GLX_EVENT_MASK

/* glXCreateNewContext render_type attribute values */
#define GLX_RGBA_TYPE                   0x8014
#define GLX_COLOR_INDEX_TYPE            0x8015
#define GLX_RGBA_TYPE_SGIX              GLX_RGBA_TYPE
#define GLX_COLOR_INDEX_TYPE_SGIX       GLX_COLOR_INDEX_TYPE
 
/* glXQueryContext-specific attributes */
#define GLX_SCREEN                      0x800C
 
/* glXSelectEvent event mask bits */
#define GLX_PBUFFER_CLOBBER_MASK        0x08000000
#define GLX_PBUFFER_CLOBBER_MASK_SGIX   GLX_PBUFFER_CLOBBER_MASK
 
/* GLXPbufferClobberEvent event_type values */
#define GLX_DAMAGED                     0x8020
#define GLX_SAVED                       0x8021

/* GLXPbufferClobberEvent draw_type values */
#define GLX_WINDOW                      0x8022
#define GLX_PBUFFER                     0x8023

/* GLXPbufferClobberEvent buffer_mask bits */
#define GLX_FRONT_LEFT_BUFFER_BIT       0x00000001
#define GLX_FRONT_RIGHT_BUFFER_BIT      0x00000002
#define GLX_BACK_LEFT_BUFFER_BIT        0x00000004
#define GLX_BACK_RIGHT_BUFFER_BIT       0x00000008
#define GLX_AUX_BUFFERS_BIT             0x00000010
#define GLX_DEPTH_BUFFER_BIT            0x00000020
#define GLX_STENCIL_BUFFER_BIT          0x00000040
#define GLX_ACCUM_BUFFER_BIT            0x00000080                              

/* glXGetConfig extension return values */
#define GLX_X_VISUAL_TYPE_EXT           0x22    /* visual_info extension type */
#define GLX_TRANSPARENT_TYPE_EXT        0x23    /* visual_info extension */
#define GLX_TRANSPARENT_INDEX_VALUE_EXT 0x24    /* visual_info extension */
#define GLX_TRANSPARENT_RED_VALUE_EXT   0x25    /* visual_info extension */
#define GLX_TRANSPARENT_GREEN_VALUE_EXT 0x26    /* visual_info extension */
#define GLX_TRANSPARENT_BLUE_VALUE_EXT  0x27    /* visual_info extension */
#define GLX_TRANSPARENT_ALPHA_VALUE_EXT 0x28    /* visual_info extension */

/* Property values for visual_type */
#define GLX_TRUE_COLOR_EXT      0x8002
#define GLX_DIRECT_COLOR_EXT    0x8003  
#define GLX_PSEUDO_COLOR_EXT    0x8004 
#define GLX_STATIC_COLOR_EXT    0x8005
#define GLX_GRAY_SCALE_EXT      0x8006  
#define GLX_STATIC_GRAY_EXT     0x8007 

/* Property values for transparent pixel */
#define GLX_NONE_EXT                0x8000     
#define GLX_TRANSPARENT_RGB_EXT     0x8008    
#define GLX_TRANSPARENT_INDEX_EXT   0x8009    

/* Property values for visual_rating */
#define GLX_VISUAL_CAVEAT_EXT           0x20  /* visual_rating extension type */
#define GLX_SLOW_VISUAL_EXT             0x8001   
#define GLX_NON_CONFORMANT_VISUAL_EXT   0x800D

/* glXGetClientString attributes */
#define GLX_VENDOR      0x1
#define GLX_VERSION     0x2
#define GLX_EXTENSIONS  0x3

/* glXQueryContextInfoEXT attributes */
#define GLX_SHARE_CONTEXT_EXT   0x800A  /* id of share context */
#define GLX_VISUAL_ID_EXT       0x800B  /* id of context's visual */
#define GLX_SCREEN_EXT          0x800C  /* screen number */

#ifndef XFree86Server

/* GLX Extension Strings */
typedef XID GLXContextID;
typedef XID GLXPixmap;
typedef XID GLXDrawable;
typedef XID GLXPbuffer;
typedef XID GLXWindow;
typedef XID GLXFBConfigID;
typedef void* GLXContext;
typedef void* GLXFBConfig;

typedef struct {
    int event_type;             /* GLX_DAMAGED or GLX_SAVED */
    int draw_type;              /* GLX_WINDOW or GLX_PBUFFER */
    unsigned long serial;       /* # of last request processed by server */
    Bool send_event;            /* true if this came for SendEvent request */
    Display *display;           /* display the event was read from */
    GLXDrawable drawable;       /* XID of Drawable */
    unsigned int buffer_mask;   /* mask indicating which buffers are affected */
    unsigned int aux_buffer;    /* which aux buffer was affected */
    int x, y;
    int width, height;
    int count;                  /* if nonzero, at least this many more */
} GLXPbufferClobberEvent;
 
typedef union __GLXEvent {
    GLXPbufferClobberEvent glxpbufferclobber;
    long pad[24];
} GLXEvent;

/* GLX 1.3 interface */
extern Bool         glXQueryExtension(Display *dpy, int *error_base, int *event_base);
extern Bool         glXQueryVersion(Display *dpy, int *major, int *minor);
extern const char*  glXQueryExtensionsString(Display *dpy, int screen);
extern const char*  glXGetClientString(Display *dpy, int name);
extern const char*  glXQueryServerString(Display *dpy, int screen, int name);
extern GLXFBConfig* glXGetFBConfigs(Display *dpy, int screen, int *nelements);
extern GLXFBConfig* glXChooseFBConfig(Display *dpy, int screen, const int *attrib_list, int *nelements);
extern int          glXGetFBConfigAttrib(Display *dpy, GLXFBConfig config, int attributes, int *value);
extern XVisualInfo* glXGetVisualFromFBConfig(Display *dpy, GLXFBConfig config);
extern GLXWindow    glXCreateWindow(Display *dpy, GLXFBConfig config, Window win, const int *attrib_list);
extern void         glXDestroyWindow(Display *dpy, GLXWindow win);
extern GLXPixmap    glXCreatePixmap(Display *dpy, GLXFBConfig config, Pixmap pixmap, const int *attrib_list);
extern void         glXDestroyPixmap(Display *dpy, GLXPixmap pixmap);
extern GLXPbuffer   glXCreatePbuffer(Display *dpy, GLXFBConfig config, const int *attrib_list);
extern void         glXDestroyPbuffer(Display *dpy, GLXPbuffer pbuf);
extern void         glXQueryDrawable(Display *dpy, GLXDrawable draw, int attribute, unsigned int *value);
extern GLXContext   glXCreateNewContext(Display *dpy, GLXFBConfig config, int render_type, GLXContext share_list, Bool direct);
extern Bool         glXIsDirect(Display *dpy, GLXContext ctx);
extern void         glXDestroyContext(Display *dpy, GLXContext ctx);
extern Bool         glXMakeContextCurrent(Display *dpy, GLXDrawable draw, GLXDrawable read, GLXContext ctx);
extern void         glXCopyContext(Display *dpy, GLXContext source, GLXContext dest, unsigned long mask);
extern GLXContext   glXGetCurrentContext(void);
extern GLXDrawable  glXGetCurrentDrawable(void);
extern GLXDrawable  glXGetCurrentReadDrawable(void);
extern Display*     glXGetCurrentDisplay(void);
extern int          glXQueryContext(Display *dpy, GLXContext ctx, int attribute, int *value);
extern void         glXSelectEvent(Display *dpy, GLXDrawable draw, unsigned long event_mask);
extern void         glXGetSelectedEvent(Display *dpy, GLXDrawable draw, unsigned long *event_mask);
extern void         glXWaitGL(void);
extern void         glXWaitX(void);
extern void         glXSwapBuffers(Display *dpy, GLXDrawable draw);
extern void         glXUseXFont(Font font, int first, int count, int list_base); 

/* Backward compatibility */
extern int          glXGetConfig(Display *dpy, XVisualInfo* visual, int attribute, int *value);
extern XVisualInfo* glXChooseVisual(Display *dpy, int screen, int *attrib_list);
extern GLXPixmap    glXCreateGLXPixmap(Display *dpy, XVisualInfo *visual, Pixmap pixmap);
extern void         glXDestroyGLXPixmap(Display *dpy, GLXPixmap pixmap);
extern GLXContext   glXCreateContext(Display *dpy, XVisualInfo *visual, GLXContext share_list, Bool direct);
extern Bool         glXMakeCurrent(Display *dpy, GLXDrawable drawable, GLXContext ctx);

/* Extensions... */

/* GLX_ARB_get_proc_address */
extern void         (*glXGetProcAddressARB(const GLubyte *procName))(void);

/* GLX_SGI_swap_control */
extern int          glXSwapIntervalSGI(int interval);

#endif

#ifdef __cplusplus
};
#endif

#endif
