/***************************************************************************************\

Module Name:    MtxMem.c

Description:    None.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------
#define MEMHANDLE_GET_LINEAR(hMemory) ((void*)hMemory)

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------
/***************************************************************************************\

Function:       memAlloc

Description:    None.

Parameters:     dwSize

Return Value:   MEMHANDLE
                Not Specified.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE MEMHANDLE memAlloc(UINT32 dwSize)
{
    return memFileAlloc(dwSize, "UNKNOWN", 0);
}

/***************************************************************************************\

Function:       memFileAlloc

Description:    None.

Parameters:     dwSize

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE MEMHANDLE memFileAlloc(
    UINT32 dwSize,
    const char* pszFileName,
    int iLine)
{
    void* pvChunk;
  #if MEMORY_STATS
    pvChunk = ClientMemStatsAlloc(dwSize + sizeof(UINT32), pszFileName, iLine);
  #else
    pvChunk = ClientMemAlloc(dwSize + sizeof(UINT32), NULL);
  #endif
    if (pvChunk)
    {
        /* First UINT32 is used to store size of memory chunk */
        *(UINT32*)pvChunk = dwSize;

        return (MEMHANDLE) ((UINT32*)pvChunk + 1);
    }

    MTX_ERROR("in mtxvxd: failed to alloc memory\n");

    /* Allocation failed */
    return (MEMHANDLE) NULL;
}

/***************************************************************************************\

Function:       memFree

Description:    None.

Parameters:     dwSize

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE BOOL32 memFree(MEMHANDLE hMemory)
{
    void* pvAddress = (void*)((UINT32*)hMemory - 1);
    UINT32 dwSize;
    
    /* Retrieve size from address pointer */
    dwSize = *(UINT32*)pvAddress;

    if (pvAddress && dwSize)
    {
        /* Retrieve size from address pointer */
      #if MEMORY_STATS
        ClientMemStatsFree(pvAddress);
      #else
        ClientMemFree(pvAddress, dwSize + sizeof(UINT32));
      #endif
        return TRUE;
    }
    else
    {
        MTX_ERROR("in mtxvxd: failed to free memory\n");
    }

    return FALSE;
}

/***************************************************************************************\

Function:       memRead

Description:    Read from a physical memory resource.

Parameters:     hMem            Memory handle returned by memMap function.
                dwOffset        Offset from memory base
                pvBuffer        Address of output buffer
                dwSize          Size of output buffer

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE BOOL32 memRead(
    IN      MEMHANDLE       hMemory,
    IN      UINT32          dwOffset,
    OUT     void*           pvBuffer,
    IN      UINT32          dwSize)
{
    volatile void* pvDest;
    volatile void* pvSrc;
    UINT32  dwCount;

    dwCount = dwSize;
    pvDest = pvBuffer;
    pvSrc  = (volatile void*)((UINT_PTR)hMemory + dwOffset);

    while (dwCount)
    {
        if ((((UINT_PTR)pvSrc & 3) == 0) && (dwCount >= sizeof(UINT32)))
        {
            volatile UINT32* pdwSrc = (volatile UINT32*)pvSrc;
            volatile UINT32* pdwDest = (volatile UINT32*)pvDest;
            
            pdwDest[0] = pdwSrc[0];
            
            pvSrc = (volatile void*)(pdwSrc + 1);
            pvDest = (volatile void*)(pdwDest + 1);

            dwCount -= sizeof(UINT32);
        }
        else if ((((UINT_PTR)pvSrc & 1) == 0) && (dwCount >= sizeof(UINT16)))
        {
            volatile UINT16* pwSrc = (volatile UINT16*)pvSrc;
            volatile UINT16* pwDest = (volatile UINT16*)pvDest;
            
            pwDest[0] = pwSrc[0];
            
            pvSrc = (volatile void*)(pwSrc + 1);
            pvDest = (volatile void*)(pwDest + 1);

            dwCount -= sizeof(UINT16);
        }
        else
        {
            volatile UINT8* pbySrc = (volatile UINT8*)pvSrc;
            volatile UINT8* pbyDest = (volatile UINT8*)pvDest;
            
            pbyDest[0] = pbySrc[0];
            
            pvSrc = (volatile void*)(pbySrc + 1);
            pvDest = (volatile void*)(pbyDest + 1);

            dwCount -= sizeof(UINT8);
        }
    }

    return TRUE;
}

/***************************************************************************************\

Function:       memWrite

Description:    Write to a physical memory resource.

Parameters:     hMemory         Memory handle returned by memMap function
                dwOffset        Offset from memory base
                pvBuffer        Address of input buffer
                dwSize          Size of input buffer

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE BOOL32 memWrite(
    IN      MEMHANDLE       hMemory,
    IN      UINT32          dwOffset,
    IN      void*           pvBuffer,
    IN      UINT32          dwSize)
{
    volatile void* pvDest;
    volatile void* pvSrc;
    DWORD  dwCount;

    dwCount = dwSize;
    pvDest = (volatile void*)((UINT_PTR)hMemory + dwOffset);
    pvSrc  = pvBuffer;

    while (dwCount)
    {
        if ((((UINT_PTR)pvDest & 3) == 0) && (dwCount >= sizeof(UINT32)))
        {
            volatile UINT32* pdwSrc = (volatile UINT32*)pvSrc;
            volatile UINT32* pdwDest = (volatile UINT32*)pvDest;
            
            pdwDest[0] = pdwSrc[0];
            
            pvSrc = (volatile void*)(pdwSrc + 1);
            pvDest = (volatile void*)(pdwDest + 1);

            dwCount -= sizeof(UINT32);
        }
        else if ((((UINT_PTR)pvDest & 1) == 0) && (dwCount >= sizeof(WORD)))
        {
            volatile UINT16* pwSrc = (volatile UINT16*)pvSrc;
            volatile UINT16* pwDest = (volatile UINT16*)pvDest;
            
            pwDest[0] = pwSrc[0];
            
            pvSrc = (volatile void*)(pwSrc + 1);
            pvDest = (volatile void*)(pwDest + 1);

            dwCount -= sizeof(UINT16);
        }
        else
        {
            volatile UINT8* pbySrc = (volatile UINT8*)pvSrc;
            volatile UINT8* pbyDest = (volatile UINT8*)pvDest;
            
            pbyDest[0] = pbySrc[0];
            
            pvSrc = (volatile void*)(pbySrc + 1);
            pvDest = (volatile void*)(pbyDest + 1);

            dwCount -= sizeof(UINT8);
        }
    }

    return TRUE;
}

/***************************************************************************************\

Function:       memReadDword

Description:    Read a DWORD from a physical memory resource.

Parameters:     

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE DWORD memReadDword(MEMHANDLE hMemory, DWORD dwOffset, DWORD* pvBuffer)
{
    return memRead(hMemory, dwOffset, pvBuffer, sizeof(*pvBuffer));
}


/***************************************************************************************\

Function:       memReadWord

Description:    None.

Parameters:     None.

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE DWORD memReadWord(MEMHANDLE hMemory, DWORD dwOffset, WORD* pvBuffer)
{
    return memRead(hMemory, dwOffset, pvBuffer, sizeof(*pvBuffer));
}

/***************************************************************************************\

Function:       memReadByte

Description:    None.

Parameters:     None.

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE DWORD memReadByte(MEMHANDLE hMemory, DWORD dwOffset, BYTE* pvBuffer)
{
    return memRead(hMemory, dwOffset, pvBuffer, sizeof(*pvBuffer));
}

/***************************************************************************************\

Function:       memWriteDword

Description:    None.

Parameters:     None.

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE DWORD memWriteDword(MEMHANDLE hMemory, DWORD dwOffset, DWORD pvBuffer)
{
    return memWrite(hMemory, dwOffset, &pvBuffer, sizeof(pvBuffer));
}


/***************************************************************************************\

Function:       memWriteWord

Description:    None.

Parameters:     None.

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE DWORD memWriteWord(MEMHANDLE hMemory, DWORD dwOffset, WORD pvBuffer)
{
    return memWrite(hMemory, dwOffset, &pvBuffer, sizeof(pvBuffer));
}


/***************************************************************************************\

Function:       memWriteByte

Description:    None.

Parameters:     None.

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE DWORD memWriteByte(MEMHANDLE hMemory, DWORD dwOffset, BYTE pvBuffer)
{
    return memWrite(hMemory, dwOffset, &pvBuffer, sizeof(pvBuffer));
}
