/***************************************************************************************\

Module Name:    MtxDbg.cpp

Description:    None.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

#define MAX_DEBUG_STRING_LENGTH 125

static char g_acDebugString[MAX_DEBUG_STRING_LENGTH];

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

/***************************************************************************************\

Function:       dbgOutput

Description:    None.

Parameters:     pszFormat

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE void dbgOutput(const char* pszFormat, ...)
{
    va_list va;
    va_start(va, pszFormat);

    // Print message to klog
    dbgOutputVA(pszFormat, va);

    va_end(va);
}

/***************************************************************************************\

Function:       dbgOutput

Description:    None.

Parameters:     pszFormat

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE void dbgOutputToString(char *pszBuffer, const char* pszFormat, ...)
{
    va_list va;
    va_start(va, pszFormat);
    
    // Print message to buffer
    ClientVSPrintf(pszBuffer, pszFormat, va);

    va_end(va);
}

/***************************************************************************************\

Function:       dbgOutputVA

Description:    None.

Parameters:     pszFormat
                va

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE void dbgOutputVA(const char* pszFormat, va_list va)
{
    // Resolve string to our temporary buffer 
    ClientVSNPrintf(g_acDebugString, MAX_DEBUG_STRING_LENGTH, pszFormat, va);

    // Print result to klog
    ClientPrintLevel(MTX_MSG_INFO, "%s", g_acDebugString);
}

/***************************************************************************************\

Function:       dbgOutputToStringVA

Description:    None.

Parameters:     pszOutputStr
                pszFormat
                va

Return Value:   void 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE void dbgOutputToStringVA(char* pszOutputStr, const char* pszFormat, va_list va)
{
    // Resolve string to our temporary buffer 
    ClientVSPrintf(pszOutputStr, pszFormat, va);
}
