/***************************************************************************************\

Module Name:    MtxCs.c

Description:    Access to configuration space registers

References:     

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/


// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "precomp.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                  L O C A L   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                         I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------


/***************************************************************************************\

Function:       csReadWrite

Description:    None.

Parameters:     None.

Return Value:   DWORD
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE BOOL32 csReadWrite(
    IN      PCIHANDLE  hDevice,
    IN      UINT32     iOffset,
    IN OUT  void*      pvBuffer,
    IN      UINT32     iSize,
    IN      UINT32     iAccess)
{
    UINT32 iWalk = 0;

    if ( iAccess == 0 )
    {
        while (iWalk < iSize)
        {       
            if ((((iOffset + iWalk) & 3) == 0) && ((iSize - iWalk) >= 4))
            {
                ClientPciConfigReadDword( hDevice, (iOffset + iWalk), (UINT32*)((BYTE*)pvBuffer + iWalk) );
                
                iWalk += 4;
            }
            else if ((((iOffset + iWalk) & 1) == 0) && ((iSize - iWalk) >= 2))
            {
                ClientPciConfigReadWord( hDevice, (iOffset + iWalk), (UINT16*)((BYTE*)pvBuffer + iWalk) );
            
                iWalk += 2;
            }
            else
            {
                ClientPciConfigReadByte( hDevice, (iOffset + iWalk), ((BYTE*)pvBuffer + iWalk) );
            
                iWalk ++;
            }
        }
    }
    else
    {
        while (iWalk < iSize)
        {       
            if ((((iOffset + iWalk) & 3) == 0) && ((iSize - iWalk) >= 4))
            {
                ClientPciConfigWriteDword( hDevice, (iOffset + iWalk), *((UINT32*)((BYTE*)pvBuffer + iWalk)) );
                
                iWalk += 4;
            }
            else if ((((iOffset + iWalk) & 1) == 0) && ((iSize - iWalk) >= 2))
            {
                ClientPciConfigWriteWord( hDevice, (iOffset + iWalk), *((UINT16*)((BYTE*)pvBuffer + iWalk)) );
            
                iWalk += 2;
            }
            else
            {
                ClientPciConfigWriteByte( hDevice, (iOffset + iWalk), *(((BYTE*)pvBuffer + iWalk)) );
            
                iWalk ++;
            }
        }
    }

    return (TRUE);
}

/***************************************************************************************\

Function:       csRead

Description:    None.

Parameters:     None.

Return Value:   UINT32
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE UINT32 DECL csRead(
    PCIHANDLE   hDevice,
    UINT32      iOffset,
    void*       pvBuffer,
    UINT32      iSize)
{
    return csReadWrite(hDevice, iOffset, pvBuffer, iSize, 0);
}


/***************************************************************************************\

Function:       csReadDword

Description:    None.

Parameters:     None.

Return Value:   UINT32
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE UINT32 DECL csReadDword(
    PCIHANDLE   hPci,
    UINT32      iOffset,
    UINT32*     pvBuffer)
{
    return csRead(hPci, iOffset, pvBuffer, sizeof(UINT32));
}


/***************************************************************************************\

Function:       csReadWord

Description:    None.

Parameters:     None.

Return Value:   UINT32
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE UINT32 DECL csReadWord(
    PCIHANDLE   hPci,
    UINT32      iOffset,
    UINT16*     pvBuffer)
{
    return csRead(hPci, iOffset, pvBuffer, sizeof(UINT16));
}


/***************************************************************************************\

Function:       csReadByte

Description:    None.

Parameters:     None.

Return Value:   UINT32
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE UINT32 DECL csReadByte(
    PCIHANDLE   hPci,
    UINT32      iOffset,
    UINT8*      pvBuffer)
{
    return csRead(hPci, iOffset, pvBuffer, sizeof(UINT8));
}


/***************************************************************************************\

Function:       csWrite

Description:    None.

Parameters:     None.

Return Value:   UINT32
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE UINT32 DECL csWrite(
    PCIHANDLE   hDevice,
    UINT32      iOffset,
    void*       pvBuffer,
    UINT32      iSize)
{
    return csReadWrite(hDevice, iOffset, pvBuffer, iSize, 1);
}


/***************************************************************************************\

Function:       csWriteDword

Description:    None.

Parameters:     None.

Return Value:   UINT32
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE UINT32 DECL csWriteDword(
    PCIHANDLE   hPci,
    UINT32      iOffset,
    UINT32      pvBuffer)
{
    return csWrite(hPci, iOffset, &pvBuffer, sizeof(pvBuffer));
}


/***************************************************************************************\

Function:       csWriteWord

Description:    None.

Parameters:     None.

Return Value:   UINT32 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE UINT32 DECL csWriteWord(
    PCIHANDLE   hPci,
    UINT32      iOffset,
    UINT16      pvBuffer)
{
    return csWrite(hPci, iOffset, &pvBuffer, sizeof(pvBuffer));
}


/***************************************************************************************\

Function:       csWriteByte

Description:    None.

Parameters:     None.

Return Value:   UINT32 
                None.

Comments:       None.

\***************************************************************************************/
STACK_LINKAGE UINT32 DECL csWriteByte(
    PCIHANDLE   hPci,
    UINT32      iOffset,
    UINT8       pvBuffer)
{
    return csWrite(hPci, iOffset, &pvBuffer, sizeof(pvBuffer));
}
