/***************************************************************************************\

File Name:      mtx_mem_type.h

Description:    Public memory type shared with userspace.

References:     None.

    Copyright (c) 2004, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTX_MEM_TYPE_H
#define INC_MTX_MEM_TYPE_H

/*-------------------------------------------------------------------------------------*\
                                 H E A D E R   F I L E S
\*-------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------*\
                          C O N S T A N T S   A N D   T Y P E S
\*-------------------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------------------*\
                   G L O B A L   V A R I A B L E   R E F E R E N C E S
\*-------------------------------------------------------------------------------------*/

/* Type of memory location */
typedef enum {
   
    MTX_MEMTYPE_IO,
    MTX_MEMTYPE_PCI_LOCKED,
    MTX_MEMTYPE_AGP,
    MTX_MEMTYPE_SYS,

    MTX_MEMTYPE_COUNT

} mtx_memory_type;

#define MTX_MEMTYPE_LOCAL       MTX_MEMTYPE_IO

/* Sharing scopes for buffer memory (keep this order!!!) */
typedef enum {

    MTX_MEMSCOPE_KERNEL,                /* Buffer is for kernel use only (cannot be used on ioctl) */
    MTX_MEMSCOPE_PRIVATE,               /* Buffer is for process private use */
    MTX_MEMSCOPE_ROOT,                  /* Buffer can only be shared to root processes */
    MTX_MEMSCOPE_AUTH,                  /* Buffer is shared to all authorized processes */
    MTX_MEMSCOPE_ALL,                   /* Buffer is shared to all process */

    MTX_MEMSCOPE_COUNT

} mtx_memory_scope;

/*-------------------------------------------------------------------------------------*\
                 I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
\*-------------------------------------------------------------------------------------*/

#endif  // #ifndef INC_MTX_MEM_TYPE_H
