/***************************************************************************************\

Module Name:    mtx_client.h

Description:    This module defines an abstraction layer of the kernel services used by 
                the kernel module.

Comments:       This is simply used to allow the binary to be compatible with kernels 
                compiled with switches that modifies the ABI.  It allows the binary to
                be kernel-independant.

    Copyright (C) 2004, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_CLIENT_H
#define INC_CLIENT_H

/*-------------------------------------------------------------------------------------*\
                                 H E A D E R   F I L E S
\*-------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------*\
                          C O N S T A N T S   A N D   T Y P E S
\*-------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------*\
                   G L O B A L   V A R I A B L E   R E F E R E N C E S
\*-------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------*\
                 I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
\*-------------------------------------------------------------------------------------*/

/* Memory management functions called from binary modules */
#if MEMORY_STATS
EXTERN_C STACK_LINKAGE void* ClientMemStatsAlloc(size_t size, const char* filename, int line);
EXTERN_C STACK_LINKAGE void  ClientMemStatsFree(void* ptr);
#endif
EXTERN_C STACK_LINKAGE void* ClientMemAlloc(size_t size, HREGION region);
EXTERN_C STACK_LINKAGE void  ClientMemFree(void* ptr, size_t size);

EXTERN_C STACK_LINKAGE void* ClientIoRemap(ULONG_PTR offset, ULONG size);
EXTERN_C STACK_LINKAGE void  ClientIoUnmap(void* ptr);

// Function prototypes
EXTERN_C STACK_LINKAGE ULONG ClientRegisterReadDword(HDEVICE hDevice, ULONG ulOffset, UINT32 *pdData);
EXTERN_C STACK_LINKAGE ULONG ClientRegisterReadWord(HDEVICE hDevice, ULONG ulOffset, UINT16 *pwData);
EXTERN_C STACK_LINKAGE ULONG ClientRegisterReadByte(HDEVICE hDevice, ULONG ulOffset, UINT8 *pbData);
EXTERN_C STACK_LINKAGE ULONG ClientRegisterWriteDword(HDEVICE hDevice, ULONG ulOffset, UINT32 dwData);
EXTERN_C STACK_LINKAGE ULONG ClientRegisterWriteWord(HDEVICE hDevice, ULONG ulOffset, UINT16 wData);
EXTERN_C STACK_LINKAGE ULONG ClientRegisterWriteByte(HDEVICE hDevice, ULONG ulOffset, UINT8 bData);

EXTERN_C STACK_LINKAGE BYTE   ClientIoReadByte(UINT_PTR iPort);
EXTERN_C STACK_LINKAGE UINT16 ClientIoReadWord(UINT_PTR iPort);
EXTERN_C STACK_LINKAGE UINT32 ClientIoReadDword(UINT_PTR iPort);
EXTERN_C STACK_LINKAGE void   ClientIoWriteByte(UINT_PTR iPort, BYTE iValue);
EXTERN_C STACK_LINKAGE void   ClientIoWriteWord(UINT_PTR iPort, UINT16 iValue);
EXTERN_C STACK_LINKAGE void   ClientIoWriteDword(UINT_PTR iPort, UINT32 iValue);

EXTERN_C STACK_LINKAGE ULONG ClientPciConfigReadByte(PCIHANDLE hDevice, ULONG iOffset, UINT8* piValue);
EXTERN_C STACK_LINKAGE ULONG ClientPciConfigReadWord(PCIHANDLE hDevice, ULONG iOffset, UINT16* piValue);
EXTERN_C STACK_LINKAGE ULONG ClientPciConfigReadDword(PCIHANDLE hDevice, ULONG iOffset, UINT32* piValue);
EXTERN_C STACK_LINKAGE ULONG ClientPciConfigWriteByte(PCIHANDLE hDevice, ULONG iOffset, UINT8 iValue);
EXTERN_C STACK_LINKAGE ULONG ClientPciConfigWriteWord(PCIHANDLE hDevice, ULONG iOffset, UINT16 iValue);
EXTERN_C STACK_LINKAGE ULONG ClientPciConfigWriteDword(PCIHANDLE hDevice, ULONG iOffset, UINT32 iValue);

EXTERN_C STACK_LINKAGE void  ClientPrintLevel(ULONG iVerboseLevel, const char* pszFormat, ...);
EXTERN_C STACK_LINKAGE INT   ClientVSPrintf(char *buf, const char *fmt, va_list args);
EXTERN_C STACK_LINKAGE INT   ClientVSNPrintf(char *buf, size_t size, const char *fmt, va_list args);

EXTERN_C STACK_LINKAGE void  ClientMicroDelay(ULONG iMicroSecs);

EXTERN_C STACK_LINKAGE INT   ClientGetNbCPUs(void);

EXTERN_C STACK_LINKAGE void  ClientSchedule(void);

EXTERN_C STACK_LINKAGE INT   ClientCopyFromUserSpace(void* pvKnlData, void* pvUserData, ULONG ulSize);
EXTERN_C STACK_LINKAGE INT   ClientCopyToUserSpace(void* pvUserData, void* pvKnlData, ULONG ulSize);

EXTERN_C STACK_LINKAGE void  ClientAtomicInc(void* pvValue);
EXTERN_C STACK_LINKAGE void  ClientAtomicDec(void* pvValue);
EXTERN_C STACK_LINKAGE INT   ClientAtomicDecAndTest(void* pvValue);

EXTERN_C STACK_LINKAGE INT   ClientGetPageSize(void);

/*-------------------------------------------------------------------------------------*\
                             I N L I N E S   A N D   M A C R O S
\*-------------------------------------------------------------------------------------*/

#define MTX_MODPARM(name)   { #name, &name }

#define MTX_GEN_MODPARM_LUT     0 
#define MTX_PARHL_MODPARM_LUT   1
#define MTX_MODPARM_LUT_COUNT   2

#define MTX_MSG_CRIT    0
#define MTX_MSG_ERROR   1
#define MTX_MSG_WARNING 2
#define MTX_MSG_INFO    3
#define MTX_MSG_DETAIL  4
#define MTX_MSG_NOISE   5

/*** Print statements to use in the generic layer and during initialization phase ***/
#define MTX_PRINT(fmt, arg...)   ClientPrintLevel(MTX_MSG_CRIT, "[mtx] "fmt, ##arg)
#define MTX_ERROR(fmt, arg...)   ClientPrintLevel(MTX_MSG_ERROR, "[mtx] *ERROR* "fmt, ##arg)
#define MTX_WARNING(fmt, arg...) ClientPrintLevel(MTX_MSG_WARNING, "[mtx] *WARNING* "fmt, ##arg)
#define MTX_INFO(fmt, arg...)    ClientPrintLevel(MTX_MSG_INFO, "[mtx] "fmt, ##arg)

#define MTX_STATUS_NOERROR	 0
#define MTX_STATUS_ERROR	 ~MTX_STATUS_NOERROR

#ifdef DEBUG
#define MTX_DEBUG(fmt, arg...)   ClientPrintLevel(MTX_MSG_INFO, "[%s(%s,%u)]: "fmt, __FUNCTION__, __FILE__, __LINE__, ##arg)
#else
#define MTX_DEBUG(fmt, arg...)
#endif


#endif  /* #ifndef INC_CLIENT_H */
