/* Linux kernel config parser
 *
 * The purpose of this file is to parse config files used to build the
 * kernel we want to compile for, giving us information about what the
 * kernel support and how to compile the driver for it.
 */

/* Include here configuration-dependent kernel header files */
#include <linux/config.h>
#include <linux/version.h>
#include <linux/rhconfig.h>

/* Assign NULL value to undefined tags we are interested with */
#ifndef CONFIG_SMP
#define CONFIG_SMP 0
#endif

#ifndef CONFIG_MODULES
#define CONFIG_MODULES 0
#endif

#ifndef CONFIG_MODVERSIONS
#define CONFIG_MODVERSIONS 0
#endif

#ifndef CONFIG_AGP_MODULE
#define CONFIG_AGP_MODULE 0
#endif

#ifndef CONFIG_AGP
#define CONFIG_AGP 0
#endif

#ifndef RED_HAT_LINUX_KERNEL
#define RED_HAT_LINUX_KERNEL 0
#endif

/* Following lines will be output from compilation of this file using 
 * the -E flags. Use them to retrieve configuration values */

/* Do kernel support multi-processor? */
SMP = CONFIG_SMP

/* Do kernel support loadable modules? */
MODULES = CONFIG_MODULES

/* Do we need to compile our module with versionning? */
MODVERSIONS = CONFIG_MODVERSIONS

/* What's the kernel release number? */
RELEASE = UTS_RELEASE

/* Do kernel support AGP devices? (one of those two should be raised) */
AGP = CONFIG_AGP
AGP_MODULE = CONFIG_AGP_MODULE

/* Are we compiling for a Redhat-patched kernel? */
REDHAT_KERNEL = RED_HAT_LINUX_KERNEL
