#!/bin/bash

SOURCES=$1
DESTDIR=$2

HEADERS=$SOURCES/include

CFLAGS="-D__KERNEL__ \
-nostdinc  \
-Werror -Wimplicit-function-declaration"

CFLAGS="$CFLAGS -I$HEADERS -I$HEADERS/asm/mach-default"

echo "#include <linux/types.h>
#include <linux/agp_backend.h>
typedef struct agp_bridge_data agp_bridge_data;
agp_bridge_data *mtx_agp_backend_acquire(struct pci_dev *dev) 
{
    return agp_backend_acquire(dev);
}" > $DESTDIR/agp_test$$.c

gcc $CFLAGS -c $DESTDIR/agp_test$$.c -o $DESTDIR/agp_test$$.o> /dev/null 2>&1
rm -f $DESTDIR/agp_test$$.c

if [ -f $DESTDIR/agp_test$$.o ]; then
    rm -f $DESTDIR/agp_test$$.o
    echo 1
else
    echo 0
fi

