#ifndef _PCI_H
#define _PCI_H

/*++

Filename:       Pci.h

Description:    Definitions for pci registers and functions.

Documentation:  Check out the following PDF files:

                    \\urgent\projects\mgihard\public\spec...\PCI_Spec\pci22rd2.pdf
                    \\urgent\projects\mgihard\public\spec...\AGP_Spec\Agp2.0.pdf
                    \\urgent\projects\mgihard\public\spec...\PCI_Spec\Bridge\ppb11.pdf

Comments:     - The functions are implemented in Pci.c.  If you include this file, then
                you will need MtxVxd.h and MtxVxd.lib

--*/

// Function prototypes
EXTERN_C UINT32 DECL pciReadDword(
    IN      PCIHANDLE   hPCI,
    IN      UINT32      ulOffset,
    OUT     UINT32*     pdData
);

EXTERN_C UINT32 DECL pciReadWord(
    IN      PCIHANDLE   hPCI,
    IN      UINT32      ulOffset,
    OUT     UINT16*     pwData
);

EXTERN_C UINT32 DECL pciReadByte(
    IN      PCIHANDLE   hPCI,
    IN      UINT32      ulOffset,
    OUT     UINT8*      pbData
);

EXTERN_C UINT32 DECL pciWriteDword(
    IN      PCIHANDLE   hPCI,
    IN      UINT32      ulOffset,
    IN      UINT32      dwData
);

EXTERN_C UINT32 DECL pciWriteWord(
    IN      PCIHANDLE   hPCI,
    IN      UINT32      ulOffset,
    IN      UINT16      wData
);

EXTERN_C UINT32 DECL pciWriteByte(
    IN      PCIHANDLE   hPCI,
    IN      UINT32      ulOffset,
    IN      UINT8       bData
);

#endif // _PCI_H
