/***************************************************************************************\

Module Name:    MtxPci.h

Description:    Interface for PCI devices.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXPCI_H
#define INC_MTXPCI_H

/* --------------------------------------------------------------------------------------
                                 H E A D E R   F I L E S
   ----------------------------------------------------------------------------------- */

/* --------------------------------------------------------------------------------------
                          C O N S T A N T S   A N D   T Y P E S
   ----------------------------------------------------------------------------------- */

/* Compare function for pciSearchDevice */
typedef BOOL32 (DECL * PCISEARCH)(
    PCIHANDLE   hPci, 
    void*       pvRefData
);

/* PCI Location Information */
typedef struct {

    UINT function   :3;     /* 2::0 */
    UINT device     :5;     /* 7::3 */
    UINT bus        :8;     /* 15::8 */ 
    UINT reserved   :16;    /* 31::16 */

} PCILOCATION;

#define PCI_LOCATION_FUNCTION_SHIFT     0
#define PCI_LOCATION_FUNCTION_MASK      (07 << PCI_LOCATION_FUNCTION_SHIFT)
#define PCI_LOCATION_DEVICE_SHIFT       3
#define PCI_LOCATION_DEVICE_MASK        (0x1F << PCI_LOCATION_DEVICE_SHIFT)
#define PCI_LOCATION_BUS_SHIFT          8
#define PCI_LOCATION_BUS_MASK           (0xFF << PCI_LOCATION_BUS_SHIFT)

/* --------------------------------------------------------------------------------------
                   G L O B A L   V A R I A B L E   R E F E R E N C E S
   ----------------------------------------------------------------------------------- */

/* --------------------------------------------------------------------------------------
                 I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
   ----------------------------------------------------------------------------------- */

EXTERN_C STACK_LINKAGE BOOL32 DECL pciScan(
    IN      PCISEARCH       fnSearch, 
    IN OUT  void*           pvRefData
);

EXTERN_C STACK_LINKAGE BOOL32 DECL pciScanBus(
    IN      PCISEARCH       fnSearch,
    IN OUT  void*           pvRefData
);

EXTERN_C STACK_LINKAGE BOOL32 DECL pciFindCapability(
    IN      PCIHANDLE       hPci, 
    OUT     UINT32*         pdwOffset, 
    IN      UINT32          dwCapId
);

EXTERN_C STACK_LINKAGE BOOL32 DECL pciFindPMCapability(
    IN      PCIHANDLE       hPci, 
    OUT     UINT32*         pdwOffset
);

EXTERN_C STACK_LINKAGE BOOL32 DECL pciFindAGPCapability(
    IN      PCIHANDLE       hPci, 
    OUT     UINT32*         pdwOffset
);

EXTERN_C STACK_LINKAGE BOOL32 DECL pciGetTermbase(
    IN      PCIHANDLE       hPci, 
    IN      UINT32          dwOffset, 
    OUT     UINT32*         pdwBase, 
    OUT     UINT32*         pdwSize
);

EXTERN_C STACK_LINKAGE BOOL32 DECL pciGetLocation(
    IN      PCIHANDLE       hPci,
    OUT     PCILOCATION*    pInfo
);

/* FOR linux */
EXTERN_C STACK_LINKAGE PCIHANDLE pciGetHandle( 
    UINT32      dwBus,
    UINT32      dwDevice,
    UINT32      dwFunction);

/* --------------------------------------------------------------------------------------
                             I N L I N E S   A N D   M A C R O S
   ----------------------------------------------------------------------------------- */

#endif  

