/***************************************************************************************\

Module Name:    MtxMem.h

Description:    Interface for physical memory access.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXMEM_H
#define INC_MTXMEM_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

#include "MtxMap.h"

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

EXTERN_C STACK_LINKAGE BOOL32 DECL memReadWrite(
    IN      MEMHANDLE       hMemory,
    IN      UINT32          lOffset,
    IN OUT  void*           pvBuffer,
    IN      UINT32          lSize,
    IN      UINT32          lAccess
);

EXTERN_C STACK_LINKAGE BOOL32 DECL memRead(
    IN      MEMHANDLE       hMemory,
    IN      UINT32          lOffset,
    OUT     void*           pvBuffer,
    IN      UINT32          lSize
);

EXTERN_C STACK_LINKAGE BOOL32 DECL memReadDword(
    IN      MEMHANDLE       hMemory,
    IN      UINT32          lOffset,
    OUT     UINT32*         pvBuffer
);

EXTERN_C STACK_LINKAGE BOOL32 DECL memReadWord(
    IN      MEMHANDLE       hMemory,
    IN      UINT32          lOffset,
    OUT     UINT16*         pvBuffer
);

EXTERN_C STACK_LINKAGE BOOL32 DECL memReadByte(
    IN      MEMHANDLE       hMemory,
    IN      UINT32          lOffset,
    OUT     UINT8*          pvBuffer
);

EXTERN_C STACK_LINKAGE BOOL32 DECL memWrite(
    IN      MEMHANDLE       hMemory,
    IN      UINT32          lOffset,
    IN      void*           pvBuffer,
    IN      UINT32          lSize
);

EXTERN_C STACK_LINKAGE BOOL32 DECL memWriteDword(
    IN      MEMHANDLE       hMemory,
    IN      UINT32          lOffset,
    IN      UINT32          pvBuffer
);

EXTERN_C STACK_LINKAGE BOOL32 DECL memWriteWord(
    IN      MEMHANDLE       hMemory,
    IN      UINT32          lOffset,
    IN      UINT16          pvBuffer
);

EXTERN_C STACK_LINKAGE UINT32 DECL memWriteByte(
    IN      MEMHANDLE       hMemory,
    IN      UINT32          lOffset,
    IN      UINT8           pvBuffer
);

// for linux

EXTERN_C STACK_LINKAGE MEMHANDLE memAlloc(
    DWORD           dwSize);

EXTERN_C STACK_LINKAGE MEMHANDLE memFileAlloc(
    UINT32 dwSize,
    const char* pszFileName,
    int iLine);

EXTERN_C STACK_LINKAGE BOOL32 memFree(
    MEMHANDLE hMemory);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXMEM_H
