/***************************************************************************************\

Module Name:    MtxMap.h

Description:    Interface for physical memory access.

References:     None.

    Copyright (c) 2001, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXMAP_H
#define INC_MTXMAP_H

// --------------------------------------------------------------------------------------
//                        I N C L U D E S   A N D   U S I N G S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

typedef UINT_PTR MEMHANDLE;

// Caching types for memMapEx
#define MM_CACHING_UC           0L
#define MM_CACHING_WC           1L
#define MM_CACHING_WB           6L

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               G L O B A L   F U N C T I O N   D E C L A R A T I O N S
// --------------------------------------------------------------------------------------

EXTERN_C STACK_LINKAGE MEMHANDLE DECL memMap(
    IN      UINT_PTR        dwPhysical, 
    IN      UINT32          dwSize
);

EXTERN_C STACK_LINKAGE MEMHANDLE DECL memMapEx(
    IN      UINT32          dwPhysical,
    IN      UINT32          dwSize,
    IN      UINT32          dwCachingType
);

EXTERN_C STACK_LINKAGE MEMHANDLE DECL memMap64(
    IN      UINT64          uiwPhysical,
    IN      UINT32          uiSize,
    IN      UINT32          uiCachingType
);

EXTERN_C STACK_LINKAGE BOOL32 DECL memUnmap(
    IN      MEMHANDLE       hMemory
);

// --------------------------------------------------------------------------------------
//     I N L I N E S,  M A C R O S,  A N D   T E M P L A T E   D E F I N I T I O N S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXMAP_H
