/***************************************************************************************\

Module Name:    MtxIo.h

Description:    Definitions for IO access.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXIO_H
#define INC_MTXIO_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

typedef UINT32 IOHANDLE;

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------

EXTERN_C STACK_LINKAGE BOOL32 DECL ioReadWrite(
    IN      IOHANDLE    hPort,
    IN OUT  void*       pvBuffer,
    IN      UINT32      lSize,
    IN      UINT32      lAccess
);

EXTERN_C STACK_LINKAGE BOOL32 DECL ioRead(
    IN      IOHANDLE    hPort, 
    OUT     void*       pvBuffer, 
    IN      UINT32      lSize
);

EXTERN_C STACK_LINKAGE BOOL32 DECL ioReadByte(
    IN      IOHANDLE    hPort,
    OUT     UINT8*      pvBuffer
);

EXTERN_C STACK_LINKAGE BOOL32 DECL ioReadWord(
    IN      IOHANDLE    hPort,
    OUT     UINT16*     pvBuffer
);

EXTERN_C STACK_LINKAGE BOOL32 DECL ioReadDword(
    IN      IOHANDLE    hPort,
    OUT     UINT32*     pvBuffer
);

EXTERN_C STACK_LINKAGE BOOL32 DECL ioWrite(
    IN      IOHANDLE    hPort, 
    IN      void*       pvBuffer, 
    IN      UINT32      lSize
);

EXTERN_C STACK_LINKAGE BOOL32 DECL ioWriteByte(
    IN      IOHANDLE    hPort,
    IN      UINT8       bData
);

EXTERN_C STACK_LINKAGE BOOL32 DECL ioWriteWord(
    IN      IOHANDLE    hPort,
    IN      UINT16      wData
);

EXTERN_C STACK_LINKAGE BOOL32 DECL ioWriteDword(
    IN      IOHANDLE    hPort,
    IN      UINT32      dData
);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXIO_H
