/***************************************************************************************\

Module Name:    MtxDbg.h

Description:    Output to debug window.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXDBG_H
#define INC_MTXDBG_H

// --------------------------------------------------------------------------------------
//                               H E A D E R   F I L E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//                        C O N S T A N T S   A N D   T Y P E S
// --------------------------------------------------------------------------------------

typedef void* DEBUGHANDLE;

// --------------------------------------------------------------------------------------
//                 G L O B A L   V A R I A B L E   R E F E R E N C E S
// --------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------
//               I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
// --------------------------------------------------------------------------------------


EXTERN_C STACK_LINKAGE void dbgOutput(
        const char *pszFormat,
        ...);

EXTERN_C STACK_LINKAGE void dbgOutputToString(
        char *pszOutputStr,
        const char *pszFormat,
        ...);

EXTERN_C STACK_LINKAGE void dbgOutputVA(
        const char *pszFormat,
        va_list va);

EXTERN_C STACK_LINKAGE void dbgOutputToStringVA(
        char *pszOutputStr,
        const char *pszFormat,
        va_list va);

// --------------------------------------------------------------------------------------
//                           I N L I N E S   A N D   M A C R O S
// --------------------------------------------------------------------------------------

#endif  // #ifndef INC_MTXDBG_H
