/***************************************************************************************\

Module Name:    MtxCs.h

Description:    Definitions for CS access.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\***************************************************************************************/

#ifndef INC_MTXCS_H
#define INC_MTXCS_H

/* --------------------------------------------------------------------------------------
                                 H E A D E R   F I L E S
   ------------------------------------------------------------------------------------*/

/* --------------------------------------------------------------------------------------
                          C O N S T A N T S   A N D   T Y P E S
   ----------------------------------------------------------------------------------- */

typedef ULONG_PTR PCIHANDLE;

/* --------------------------------------------------------------------------------------
                   G L O B A L   V A R I A B L E   R E F E R E N C E S
   ----------------------------------------------------------------------------------- */

/* --------------------------------------------------------------------------------------
                 I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
   ----------------------------------------------------------------------------------- */

EXTERN_C STACK_LINKAGE BOOL32 DECL csReadWrite(
    IN      PCIHANDLE  hPci,
    IN      UINT32     iOffset,
    IN OUT  void*      pvBuffer,
    IN      UINT32     iSize,
    IN      UINT32     iAccess
);

EXTERN_C STACK_LINKAGE BOOL32 DECL csRead(
    IN      PCIHANDLE  hPci, 
    IN      UINT32     iOffset, 
    OUT     void*      pvBuffer, 
    IN      UINT32     iSize
);

EXTERN_C STACK_LINKAGE BOOL32 DECL csReadDword(
    IN      PCIHANDLE  hPci, 
    IN      UINT32     iOffset, 
    OUT     UINT32*    pvBuffer
);

EXTERN_C STACK_LINKAGE BOOL32 DECL csReadWord(
    IN      PCIHANDLE  hPci, 
    IN      UINT32     iOffset, 
    OUT     UINT16*    pvBuffer
);

EXTERN_C STACK_LINKAGE BOOL32 DECL csReadByte(
    IN      PCIHANDLE  hPci, 
    IN      UINT32     iOffset, 
    OUT     UINT8*     pvBuffer
);

EXTERN_C STACK_LINKAGE BOOL32 DECL csWrite(
    IN      PCIHANDLE  hPci, 
    IN      UINT32     iOffset, 
    IN      void*      pvBuffer, 
    IN      UINT32     iSize
);

EXTERN_C STACK_LINKAGE BOOL32 DECL csWriteDword(
    IN      PCIHANDLE  hPci, 
    IN      UINT32     iOffset, 
    IN      UINT32     pvBuffer
);

EXTERN_C STACK_LINKAGE BOOL32 DECL csWriteWord(
    IN      PCIHANDLE  hPci, 
    IN      UINT32     iOffset, 
    IN      UINT16     pvBuffer
);

EXTERN_C STACK_LINKAGE BOOL32 DECL csWriteByte(
    IN      PCIHANDLE  hPci, 
    IN      UINT32     iOffset, 
    IN      UINT8      pvBuffer
);

/* --------------------------------------------------------------------------------------
                             I N L I N E S   A N D   M A C R O S
   ----------------------------------------------------------------------------------- */

#endif  

