/*-------------------------------------------------------------------------------------*\

Module Name:    MtxTypesLnx.h

Description:    Content all OS specific types, constants, macros that should be defined
                to get the OS independent code to compile.  You can include a header file
                that defines all this stuff or you can define each conposant individually.

References:     None.

    Copyright (c) 2000, Matrox Graphics Inc.
    All Rights Reserved.

\*-------------------------------------------------------------------------------------*/

#ifndef INC_MTXTYPESLNX_H
#define INC_MTXTYPESLNX_H

/*---------------------------------------------------------------------------------------*\
                        H E A D E R   F I L E S   R E Q U I R E D
\*---------------------------------------------------------------------------------------*/
#ifndef EXTERN_C
  #ifdef __cplusplus
    #define EXTERN_C extern "C"
  #else  
    #define EXTERN_C extern
  #endif 
#endif 

#ifdef __cplusplus
 #define INLINE          __inline__
 #define FINLINE         __inline__
#else
 #define INLINE          static __inline__
 #define FINLINE         static __inline__
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __KERNEL__
#include <stdint.h>
#else
#include <linux/types.h>
#endif

#include <stdarg.h>
#include <stddef.h>

#if __GNUC__ >= 3 
#define STACK_LINKAGE   __attribute__((regparm(0)))
#else
#define STACK_LINKAGE
#endif

STACK_LINKAGE void*   LocMemSet(void* pvDst, int iValue, int szByteCount);
STACK_LINKAGE void*   LocMemCpy(void* pvSrc1, const void* pvSrc2, int szByteCount);

#ifdef __cplusplus
};
#endif

#if defined(__cplusplus) && defined(OS_LINUX) && defined(__KERNEL__)
extern "C" {
static INLINE void* memset( void* s, int c, size_t count )
{
    return LocMemSet( s, c, count );
}

static INLINE void *memcpy(void *dest, const void *src, size_t n)
{
    return LocMemCpy(dest, src, n);
}
}
#endif
/*-------------------------------------------------------------------------------------*\
                                    C O N S T A N T S
\*-------------------------------------------------------------------------------------*/


#define _T(string)      L ## string

#define IN
#define OUT
#define INOUT

#define TRUE            1
#define FALSE           0

#define __cdecl
#define __stdcall
#define CALLBACK
#define FAR
#define OPTIONAL
#define DECL

#define FIELD_OFFSET(type, field)    ((LONG)&(((type *)0)->field))

/* invalidate pragmas */
#define MTX_CODE_SEG_BEGIN
#define MTX_CODE_SEG_END
#define MM_CODE_SEG_BEGIN
#define MM_CODE_SEG_END

#define NEG_NULL    ((unsigned)(~0))

#define FLOAT_TO_DWORD_ZERO 0x00000000
#define FLOAT_TO_DWORD_ONE  0x3F800000

typedef enum _DBG_LEVEL
{
    DBGL_CRITICAL       = 0,
    DBGL_ERROR,          
    DBGL_WARNING,
    DBGL_INFO,
    DBGL_DETAIL,
    DBGL_NOISE,
    DBGL_FORCE_LONG     = -1 
} DBG_LEVEL;

/*-------------------------------------------------------------------------------------*\
                             T Y P E   D E F I N I T I O N S
\*-------------------------------------------------------------------------------------*/

#ifdef __KERNEL__
  typedef __s8                  INT8;
  typedef __s16                 INT16;
  typedef __s32                 MTX_INT32;
  typedef __s64                 INT64;
  typedef __u8                  UINT8;
  typedef __u16                 UINT16;
  typedef __u32                 UINT32;
  typedef __u64                 UINT64;
  typedef unsigned long         UINT_PTR;
  typedef long                  INT_PTR;
#else
    typedef int8_t              INT8;
    typedef int16_t             INT16;
    typedef int32_t             MTX_INT32;
    typedef int64_t             INT64;
    typedef uint8_t             UINT8;
    typedef uint16_t            UINT16;
    typedef uint32_t            UINT32;
    typedef uint64_t            UINT64;
    typedef uintptr_t           UINT_PTR;
    typedef intptr_t            INT_PTR;
#endif

/* INT32 is a special type for X.*/
#ifndef XFree86LOADER
    typedef MTX_INT32           INT32;
#endif

typedef INT16                   SHORT;
typedef UINT16                  USHORT;
typedef UINT16                  WORD;
typedef UINT16                  FLAG16;

typedef MTX_INT32               INT;
typedef MTX_INT32               LONG;
typedef UINT32                  DWORD;
typedef UINT32                  DWORD_PTR;
typedef UINT32                  ULONG;
typedef UINT32                  UINT;

typedef UINT8                   FLAG8;
typedef UINT8                   BOOL8;
typedef UINT32                  FLAG32;
typedef UINT32                  BOOL32;

typedef UINT_PTR                ULONG_PTR;

/*Must always be the size of a pointer*/
#ifdef GL32ON64
typedef unsigned long long      HANDLE;
#else
typedef ULONG_PTR               HANDLE;
#endif

typedef INT_PTR                 LONG_PTR;

typedef ULONG                   FLONG;
typedef ULONG                   LBOOL;
typedef LONG                    HRESULT;

typedef float                   FLOAT;

typedef char                    CHAR;
typedef unsigned char           UCHAR;
typedef unsigned char           BOOLEAN;
typedef unsigned char           BOOL;
typedef unsigned char           BYTE;
typedef unsigned char           FCHAR;
typedef const char *            PSTR;
typedef BYTE*                   LPBYTE;


typedef char                    TCHAR;
typedef char                    ACHAR;
typedef TCHAR                   WCHAR;

typedef void                    VOID;
typedef void                    (*PFN);

typedef double                  DOUBLE;

typedef UINT32                  BFUNSIGNED;     /* Unsigned bit field */
typedef MTX_INT32               BFSIGNED;       /* Signed bit field */
typedef UINT32                  BFBOOL;         /* Boolean bit field (1-bit only) */

#ifndef __STRICT_ANSI__
typedef unsigned long long      DWORDLONG;
typedef long long               LONGLONG;
typedef unsigned long long      ULONGLONG;
#endif

typedef struct 
{                                                   
     LONG   x;                                      
     LONG   y;                                      
     
} LPOINT, POINT, POINT32;

typedef struct
{                                                   
     LONG   left;                                   
     LONG   top;                                    
     LONG   right;                                  
     LONG   bottom;                                 
     
} LRECT, RECT, RECT32;

typedef struct
{
    LONG        cx;
    LONG        cy;
    
} LSIZE, SIZE, SIZE32;

/* Handy structure for (Width, Height) packed in a ULONG.*/
typedef struct
{
    USHORT  usWidth;
    USHORT  usHeight;
    
} USHORT_SIZE;

typedef struct
{
    ULONG   ulWidth;
    ULONG   ulHeight;
    
} ULONG_SIZE;

typedef LPOINT POINTL;
typedef LSIZE SIZEL;
typedef LRECT RECTL;
typedef HANDLE HWND;


#ifndef __STRICT_ANSI__

enum {
    BMF_1BPP    = 1,
    BMF_4BPP    = 4,
    BMF_8BPP    = 8,
    BMF_16BPP   = 16,
    BMF_24BPP   = 24,
    BMF_32BPP   = 32,
};

typedef union _LARGE_INTEGER{
    
    struct{
        
        DWORD LowPart;
        LONG HighPart;
    };
    
    LONGLONG QuadPart;
    
} LARGE_INTEGER;

typedef union _ULARGE_INTEGER{
    
    struct{
        
        DWORD LowPart;
        ULONG HighPart;
    };
    
    ULONGLONG QuadPart;
    
} ULARGE_INTEGER;

#endif

typedef FLOAT FLOATOBJ;
#define FLOATOBJ_Add(pFloat, pFloat2)      (*pFloat += *pFloat2)
#define FLOATOBJ_Mul(pFloat, pFloat2)      (*pFloat *= *pFloat2)
#define FLOATOBJ_SetLong(pFloat, lLong)   (*pFloat = lLong)
#define FLOATOBJ_GetLong(pFloat)          ((LONG)*pFloat)
#define FLOATOBJ_MulLong(pFloat, lLong)   (*pFloat *= lLong)
#define FLOATOBJ_DivLong(pFloat, lLong)   (*pFloat /= lLong)
#define FLOATOBJ_SetFloat(pFloat, fFloat) (*pFloat = fFloat)

typedef struct _ENUMRECTS {
    
    ULONG  c;
    RECTL  arcl[1];
  
} ENUMRECTS;

/*-------------------------------------------------------------------------------------*\
                    G L O B A L   V A R I A B L E   R E F E R E N C E S
\*-------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------*\
                 I N T E R F A C E   F U N C T I O N   P R O T O T Y P E S
\*-------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------*\
                             I N L I N E S   A N D   M A C R O S
\*-------------------------------------------------------------------------------------*/

/* Macro used to generate compilation message */

#define chSTR(x)    #x
#define chSTR2(x)   chSTR(x)

#if 0
    #define COMPMSG(x)  message(__FILE__ "(" chSTR2(__LINE__) ") : " #x)
#else
    #define COMPMSG(x)  
#endif

/* Define for enumeration to use to be compatible with Windows 9x. */
#define ENUM(Name)     enum Name

#endif  /* #ifndef INC_MTXTYPESLNX_H */
