@set LOGFILE=%temp%\OFUInstall.log
@echo %time%:Starting the Installation of Online Flash Update Utility >> %LOGFILE%
@if "%1c"=="c" goto usage
@set PLTFRM=%1 
@echo %time%:Platform number detected is %PLTFRM% >> %LOGFILE%

if %PLTFRM%==1 goto start
if %PLTFRM%==2 goto start
if %PLTFRM%==3 goto start
if %PLTFRM%==4 goto start
if %PLTFRM%==5 goto start
if %PLTFRM%==6 set PLTFRM=1
if %PLTFRM%==7 set PLTFRM=1
goto start

:usage
@echo.
@echo USAGE: Install [Platform]
@echo The Platform is the  number corresponding to different platforms.
@echo S5000 = 1, SHW40 = 2, SE752 = 3, SBX44 = 4, S3000 = 5, SFC4UR = 6, S3200 = 7.
@echo.
@echo Example:
@echo.
@echo         Install 3
@echo.
@goto exit
 

:start
@set CURDIR=%cd%
@set DEST_DIR=%ProgramFiles%
cd %ProgramFiles%
@echo %time%:Checking for the existence of  %ProgramFiles%\Intel >> %LOGFILE%
if not exist  Intel\nul goto setdir1

@echo %time%: %ProgramFiles%\Intel\ exists >> %LOGFILE%
cd %ProgramFiles%\Intel
@set DEST_DIR=%cd%

@echo %time%:Checking for the existing of  %ProgramFiles%\Intel\Flashupdt  >> %LOGFILE%
if not exist Flashupdt\nul goto setdir2

@echo %time%: %ProgramFiles%\Intel\flashupdt exists >> %LOGFILE%
cd %ProgramFiles%\Intel\Flashupdt
@set DEST_DIR=%cd%
cd  "%CURDIR%"
goto checkdir

:setdir1
@set DEST_DIR=%DEST_DIR%\Intel
:setdir2
@set DEST_DIR=%DEST_DIR%\Flashupdt
cd  "%CURDIR%"

:checkdir
@echo %time%:Checking the Current Installation Directory >> %LOGFILE%

if "%CURDIR%"=="%DEST_DIR%" goto setvar 
@echo %time%:Current Installation Directory different from the Destination directory >> %LOGFILE%
@goto checkProc

:setvar
@echo %time%:Setting the Installation Directory and Destination Directory same >> %LOGFILE%
@set OFU_INSTALL_DIR=%DEST_DIR%
@echo %time%:Starting the Driver Installation >> %LOGFILE%

:checkProc
@echo %time%:Checking the Processor Type >> %LOGFILE%
@set IBS_UTIL_INF=IBSMUtil.inf
@set FLASH_DRV_INF=flashud.inf
@set IMB_DRV_INF=imbdrv.inf
echo %time%:Processor Architecture is %PROCESSOR_ARCHITECTURE% >> %LOGFILE%
echo %time%:Processor W6432 support is %PROCESSOR_ARCHITEW6432% >> %LOGFILE%
if "%PROCESSOR_ARCHITEW6432%"=="AMD64" goto Intel64
if "%PROCESSOR_ARCHITEW6432%"=="amd64" goto Intel64
if "%PROCESSOR_ARCHITEW6432%"=="X64" goto Intel64
if "%PROCESSOR_ARCHITEW6432%"=="x64" goto Intel64
if "%PROCESSOR_ARCHITEW6432%"=="Intel64" goto Intel64
if "%PROCESSOR_ARCHITECTURE%"=="X86" goto win32
if "%PROCESSOR_ARCHITECTURE%"=="x86" goto win32
:Intel64
@echo %time%:Processor is a 64 bit processor >> %LOGFILE%
@set IBS_UTIL_INF=IBSMUx64.inf
if "%OFU_INSTALL_DIR%"=="%DEST_DIR%" goto install
@set OFU_INSTALL_DIR=..\..\IPMIDriver\windows\x86_64
@set OS_SPEC_DIR=.\winEM64T

@goto filecopy
	

:win32
@echo %time%:Processor is a 32 bit processor >> %LOGFILE%
if "%OFU_INSTALL_DIR%"=="%DEST_DIR%" goto install
@set OFU_INSTALL_DIR=..\..\IPMIDriver\windows\ia32
@set OS_SPEC_DIR=.\win32


:filecopy

@set bio_str_src=enus\BiosUpdate\str
@set cfg_str_src=enus\CfgFile\str
@set sdr_str_src=enus\sdrdata\str
@set fru_str_src=enus\frudata\str
@set fla_str_src=enus\flashupdt\str
@set smb_str_src=enus\smbios\str
@set fwu_str_src=enus\fwupdate\str
@set fwdu_str_src=enus\fwdupdate\str
@set acpi_str_src=enus\acpi\str
@set bio_str_dest=enus\BiosUpdate\str
@set cfg_str_dest=enus\CfgFile\str
@set sdr_str_dest=enus\sdrdata\str
@set fru_str_dest=enus\frudata\str
@set fla_str_dest=enus\flashupdt\str
@set smb_str_dest=enus\smbios\str
@set fwu_str_dest=enus\fwupdate\str
@set fwdu_str_dest=enus\fwdupdate\str
@set acpi_str_dest=enus\acpi\str



@echo %time%:Creating the Destination Directory >> %LOGFILE%
mkdir "%DEST_DIR%\"
@echo %time%:Starting the File copy from Installation Directory to Destination Directory >> %LOGFILE%

if "%OFUOSVERSION%"=="2K0" goto 2kfiles
goto 2k3files
:2kfiles
@set SRCFILES=bud.dll biosupdate.dll frudata.dll fwupdate.dll fwdupdate.dll sdrdata.dll smbios_w2k.dll  cfgfile.dll  flashupdt.exe uninstall.cmd install.cmd  msvcr71.dll msvcp71.dll msipmi.dll acpi.dll runtime.dll DeviceSetup.exe
goto cmncopy
:2k3files
@set SRCFILES=bud.dll biosupdate.dll frudata.dll fwupdate.dll fwdupdate.dll sdrdata.dll smbios.dll  cfgfile.dll  flashupdt.exe uninstall.cmd install.cmd  msvcr71.dll msvcp71.dll msipmi.dll acpi.dll runtime.dll %OS_SPEC_DIR%\DeviceSetup.exe %OS_SPEC_DIR%\IBSMUtil.sys %OS_SPEC_DIR%\IBSMUtil.cat %OS_SPEC_DIR%\%IBS_UTIL_INF% 

:cmncopy
FOR %%i IN (%SRCFILES%) DO xcopy /y %%i "%DEST_DIR%"
@if %ERRORLEVEL% NEQ 0 goto error

xcopy /y /I ..\setup_win.exe "%DEST_DIR%"
@if %ERRORLEVEL% NEQ 0 goto error

xcopy /y /I %cfg_str_src%\*.* "%DEST_DIR%"\%cfg_str_dest%
@if %ERRORLEVEL% NEQ 0 goto error

xcopy /y /I %smb_str_src%\*.* "%DEST_DIR%"\%smb_str_dest%
@if %ERRORLEVEL% NEQ 0 goto error

xcopy /y /I %fla_str_src%\*.* "%DEST_DIR%"\%fla_str_dest%
@if %ERRORLEVEL% NEQ 0 goto error


if %PLTFRM%==5 goto S3000

@set FWFILES=sdrdata.dll fwupdate.dll

FOR %%i IN (%FWFILES%) DO xcopy /y %%i "%DEST_DIR%"
@if %ERRORLEVEL% NEQ 0 goto error

xcopy /y /I %fwu_str_src%\*.* "%DEST_DIR%"\%fwu_str_dest%
@if %ERRORLEVEL% NEQ 0 goto error

xcopy /y /I %sdr_str_src%\*.* "%DEST_DIR%"\%sdr_str_dest%
@if %ERRORLEVEL% NEQ 0 goto error

if %PLTFRM%==1 goto S5000
if %PLTFRM%==2 goto SHW40
if %PLTFRM%==3 goto SE752
if %PLTFRM%==4 goto ofucopy




:S5000
@set ADDFILES=fwdupdate.dll frudata.dll  biosupdate.dll bud.dll %OS_SPEC_DIR%\flashud.sys %OS_SPEC_DIR%\flashud.inf %OS_SPEC_DIR%\flashud.cat

xcopy /y /I %acpi_str_src%\*.* "%DEST_DIR%"\%acpi_str_dest%
@if %ERRORLEVEL% NEQ 0 goto error

xcopy /y /I %fwdu_str_src%\*.* "%DEST_DIR%"\%fwdu_str_dest%
@if %ERRORLEVEL% NEQ 0 goto error


xcopy /y /I %bio_str_src%\*.* "%DEST_DIR%"\%bio_str_dest%
@if %ERRORLEVEL% NEQ 0 goto error
 
copy /y %OS_SPEC_DIR%\flashud.inf %windir%\inf
copy /y %OS_SPEC_DIR%\flashud.sys %windir%\system32\drivers  



copy /y %OFU_INSTALL_DIR%\imbdrv.inf %windir%\inf
copy /y %OFU_INSTALL_DIR%\imbdrv.sys %windir%\system32\drivers  

if "%OFUOSVERSION%"=="2K0"  goto addcopy

copy /y %OS_SPEC_DIR%\%IBS_UTIL_INF%  %windir%\inf
copy /y %OS_SPEC_DIR%\ibsmutil.sys %windir%\system32\drivers  

goto addcopy

:SHW40
@set ADDFILES=frudata.dll  biosupdate.dll  bud.dll %OS_SPEC_DIR%\flashud.sys %OS_SPEC_DIR%\flashud.inf %OS_SPEC_DIR%\flashud.cat

xcopy /y /I %bio_str_src%\*.* "%DEST_DIR%"\%bio_str_dest%
@if %ERRORLEVEL% NEQ 0 goto error

goto addcopy

:SE752


goto addcopy



:S3000
@set ADDFILES=biosupdate.dll bud.dll %OS_SPEC_DIR%\flashud.sys %OS_SPEC_DIR%\flashud.inf %OS_SPEC_DIR%\flashud.cat

xcopy /y /I %bio_str_src%\*.* "%DEST_DIR%"\%bio_str_dest%

copy /y %OS_SPEC_DIR%\flashud.inf %windir%\inf
copy /y %OS_SPEC_DIR%\flashud.sys %windir%\system32\drivers  

if "%OFUOSVERSION%"=="2K0"  goto s3000copy

copy /y %OS_SPEC_DIR%\%IBS_UTIL_INF%  %windir%\inf
copy /y %OS_SPEC_DIR%\ibsmutil.sys %windir%\system32\drivers  

goto s3000copy

:addcopy

xcopy /y /I %fru_str_src%\*.* "%DEST_DIR%"\%fru_str_dest%
@if %ERRORLEVEL% NEQ 0 goto error

:s3000copy

FOR %%i IN (%ADDFILES%) DO xcopy /y %%i "%DEST_DIR%"
@if %ERRORLEVEL% NEQ 0 goto error

if %PLTFRM%==5 goto doccopy

:ofucopy

xcopy /y /s "%OFU_INSTALL_DIR%"\*.*  "%DEST_DIR%\"
@if %ERRORLEVEL% NEQ 0 goto error

:doccopy

xcopy /y /s  ..\doc\*.*  "%DEST_DIR%\"
@if %ERRORLEVEL% NEQ 0 goto error
xcopy /y /s  ..\Setup_win.exe  "%DEST_DIR%\"
@if %ERRORLEVEL% NEQ 0 goto error
if "%OFUOSVERSION%"=="2K0" rename "%DEST_DIR%"\smbios_w2k.dll smbios.dll
@echo %time%:File copy completed >> %LOGFILE%



:install
if "%OFUOSVERSION%"=="2K0" goto imbinstall
@echo.
@echo %time%:Installing MEMORYMAP driver >> %LOGFILE%
@echo Installing MEMORYMAP driver...
@echo.
"%DEST_DIR%"\DeviceSetup.exe -v install "%DEST_DIR%"\%IBS_UTIL_INF% *IntelUtilDeV >> %LOGFILE%
@if %ERRORLEVEL% == -1  goto error
@echo "Memory Map Driver installed successfully"
@echo %time%:Installation of MEMORYMAP driver is successful>> %LOGFILE%

:imbinstall

if "%MSIPMIINSTALLED%"=="YES" goto flashudinstall
if %PLTFRM%==5 goto flashudinstall
@echo.
@echo %time%:Installing IMB driver >> %LOGFILE%
@echo Installing IMB driver...
@echo.
cd "%OFU_INSTALL_DIR%"
DeviceSetup.exe -v install %IMB_DRV_INF% *IMBDRV >>  %LOGFILE%
cd  "%CURDIR%"
@if %ERRORLEVEL% NEQ -1  goto flashudinstall
@echo %time%:Installation of IMB driver failed >> %LOGFILE%
goto error


:flashudinstall
if "%MSIPMIINSTALLED%"=="YES" @echo %time%:Microsoft IPMI driver detected>> %LOGFILE%
if "%MSIPMIINSTALLED%"=="NO" @echo %time%:Installation of IMB driver is successful>> %LOGFILE%

if %PLTFRM%==3 goto done
if %PLTFRM%==4 goto done
@echo.
@echo %time%:Installing FLASHUD driver >> %LOGFILE%
@echo Installing FLASHUD driver...
@echo.
"%DEST_DIR%"\DeviceSetup.exe -v install "%DEST_DIR%"\%FLASH_DRV_INF% *INT0800 >>  %LOGFILE%
@if %ERRORLEVEL% == -1 goto error
@echo %time%:Installation of FLASHUD driver is successful>> %LOGFILE%




@goto done

:done
@echo Done!
@echo.
@echo %time%:Installation of Online Flash Update Utility is successful>> %LOGFILE%
@echo ************************************************************** >> %LOGFILE%
@echo Successfully installed the Online Flash Update Utility !
@echo DONT REBOOT if the Operating system is Windows PE.
@echo For other operating systems PLEASE REBOOT the system in order 
@echo for the drivers to be loaded.
@echo.
@goto exit

:error
@echo.
@echo %time%:Error installing the Online Flash Update Utility >> %LOGFILE%
@echo ******************************************************* >> %LOGFILE%
@echo @@@@ Error installing the Online Flash Update Utility drivers @@@@
@echo.

:exit


