#!/bin/sh

# main
SUM=$1
KERNEL=$2
VERSION=`echo ${KERNEL} | cut -f2 -d "-"`
BOOT_KERNEL=`echo ${KERNEL} | sed -e 's/'-"$VERSION"'//'`
BUILD_PATH=$3
UPDATE_FILE=$4
DRIVER_PATH=kernel/drivers/message/fusion
found_kernel=no
is_boot=no

# MD5SUM Check and make sure we are booting to the same kernel
if [ -e "/boot/vmlinuz" ]; then
	kernel_md5sum=`md5sum /boot/vmlinuz | awk '{print $1}'`
	if [ ${kernel_md5sum} = ${SUM} -a \
	     `grep -c ${BOOT_KERNEL} /proc/version` -gt 0 ]; then
		found_kernel=yes;
	fi
fi	
if [ -e "/boot/vmlinuz-${KERNEL}" ]; then
	kernel_md5sum=`md5sum /boot/vmlinuz-${KERNEL} | awk '{print $1}'`
	BOOT_KERNEL=${KERNEL}
	if [ ${kernel_md5sum} = ${SUM} -a \
	     `grep -c ${BOOT_KERNEL} /proc/version` -gt 0 ]; then
		found_kernel=yes;
	fi
fi

if [ "${found_kernel}" = "yes" ]; then
	
	echo "Detected ${KERNEL} kernel"

#Copy files up to /lib/modules
	if [ -d "${BUILD_PATH}"/"${KERNEL}" ] ; then
		echo "Updating Fusion-MPT binaries in  /lib/modules/${BOOT_KERNEL}"
		cp -f ${BUILD_PATH}/${KERNEL}/${DRIVER_PATH}/* /lib/modules/${BOOT_KERNEL}/${DRIVER_PATH}/
		echo ${BOOT_KERNEL} >> ${UPDATE_FILE}
	else
		echo "No Fusion-MPT binary update for this kernel"
		exit
	fi

# Find out if RAMDISK needs updating
	if [ -e /etc/rc.config ]; then
		if [ `grep -c "mptbase" /etc/rc.config` -gt 0 ]; then
			is_boot=yes;
		fi;
	fi
	if [ -e /etc/sysconfig/kernel ]; then
		if [ `grep -c "mptscsih" /etc/sysconfig/kernel` -gt 0 ]; then
			is_boot=yes;
		fi;
	fi

	if [ "${is_boot}" = "yes" ]; then
		echo -e "Detected Fusion-MPT driver is used for boot. Updating initrd."
		bootpart=boot
		if [ -e /${bootpart}/initrd ]; then
			echo Saving initrd in initrd.orig
			mv /${bootpart}/initrd /${bootpart}/initrd.orig
		fi
		if [ -e /${bootpart}/initrd.shipped ]; then
			echo Saving initrd.shipped in initrd.shipped.orig
			mv /${bootpart}/initrd.shipped /${bootpart}/initrd.shipped.orig
		fi
		if [ -e /${bootpart}/initrd.suse ]; then
			echo Saving initrd.suse in initrd.suse.orig
			mv /${bootpart}/initrd.suse /${bootpart}/initrd.suse.orig
		fi
		echo Creating initrd images...
		/sbin/mk_initrd
		echo -e "\nIMPORTANT: /"${bootpart} " has been modified!"
		echo -e "If LILO is your boot loader, please re-run /sbin/lilo."
		echo -e "You must reboot for the change to take effect."
	fi

fi


