Name: iANS
Summary: Intel(R) Advanced Network Services for Linux
Version: 3.4.3a
Release: 2.4.21_15.EL
Source: %{name}-%{version}.tar.gz
Vendor: Intel Corporation
License: Proprietary
ExclusiveOS: linux
Group: System Environment/Kernel
Requires: kernel = 2.4.21-15.EL                                                               
Provides: %{name} = %{version}-%{release}
URL: http://support.intel.com/support/go/linux/ans.htm
BuildRoot: /tmp/%{name}-%{version}-root

%description
This package contains the Intel(R) Advanced Network Services driver for Linux.
The driver provides advanced features including: Adapter Fault Tolerance,
Switch Fault Tolerance, Adaptive Load Balancing on transmit, IPv4 Receive
Load Balancing, 802.3ad Dynamic/Static Link Aggregation, 802.3ac VLAN tagging,
Dynamic VLAN configuration with GVRP standard and Zero Copy support.

This package contains modules for kernel 2.4.21-15.EL

%prep
%setup

%build
mkdir -p %{buildroot}


#2.4.21-15.EL gets set by the makefile when the RPM tarball is built.
KV=2.4.21-15.EL
# If not RH, then ALL_RH_KERNELS should just get one entry
# The sort ensures that the UP kernel (e.g. with no extra name on the end)
# always comes last.  This is required to support the BOOT kernel - see below.
ALL_RH_KERNELS=$(ls /lib/modules | grep "$KV" | sort -r)


for RKV in $ALL_RH_KERNELS ; do

	echo "Building against kernel $RKV"
	KSP="/lib/modules/$RKV/build
	     /usr/src/linux-$RKV
	     /usr/src/linux-$(echo $RKV | sed 's/-.*//')
	     /usr/src/kernel-headers-$RKV
	     /usr/src/kernel-source-$RKV
	     /usr/src/linux-$(echo $RKV | sed 's/\([0-9]*\.[0-9]*\)\..*/\1/')
	     /usr/src/linux"

	KSRC=$(for d in $KSP ; do [ -e $d/include/linux ] && echo $d; echo;  done)
	KSRC=$(echo $KSRC | awk '{ print $1 }')

	# check to see if this is a Red Hat kernel
	if [ -e $KSRC/include/linux/rhconfig.h ] ; then
		# Figure out which kernel we're building against and
		# set flags correctly.  If we don't do this, we'll just
		# get the configuration of the running kernel out of 
		# /boot/kernel.h, which is probably what we don't want

		# Check for x86_64 or ia32e config - they need additional defines
		# These are everything but UP; we override this below if needed
		if [ $(uname -i) = "x86_64" ] ; then
			X86_64_FLAGS="-D__MODULE_KERNEL_x86_64=1 -D__MODULE_KERNEL_ia32e=0"
		fi

		if [ $(echo $RKV | grep "enterprise") ] ; then
			CFLAGS_EXTRA="-D__BOOT_KERNEL_SMP=0 -D__BOOT_KERNEL_UP=0 -D__BOOT_KERNEL_ENTERPRISE=1 -D__BOOT_KERNEL_BIGMEM=0 -D__BOOT_KERNEL_HUGEMEM=0"
		elif [ $(echo $RKV | grep "smp") ] ; then
			CFLAGS_EXTRA="-D__BOOT_KERNEL_SMP=1 -D__BOOT_KERNEL_UP=0 -D__BOOT_KERNEL_ENTERPRISE=0 -D__BOOT_KERNEL_BIGMEM=0 -D__BOOT_KERNEL_HUGEMEM=0"
		elif [ $(echo $RKV | grep "hugemem") ] ; then
			CFLAGS_EXTRA="-D__BOOT_KERNEL_SMP=0 -D__BOOT_KERNEL_UP=0 -D__BOOT_KERNEL_ENTERPRISE=0 -D__BOOT_KERNEL_BIGMEM=0 -D__BOOT_KERNEL_HUGEMEM=1"
		elif [ $(echo $RKV | grep "BOOT") ] ; then
			CFLAGS_EXTRA="-D__BOOT_KERNEL_SMP=0 -D__BOOT_KERNEL_UP=1 -D__BOOT_KERNEL_ENTERPRISE=0 -D__BOOT_KERNEL_BIGMEM=0 -D__BOOT_KERNEL_HUGEMEM=0"
		elif [ "$RKV" = "$KV" ] ; then
			CFLAGS_EXTRA="-D__BOOT_KERNEL_SMP=0 -D__BOOT_KERNEL_UP=1 -D__BOOT_KERNEL_ENTERPRISE=0 -D__BOOT_KERNEL_BIGMEM=0 -D__BOOT_KERNEL_HUGEMEM=0"
			if [ $(uname -i) = "x86_64" ] ; then
				X86_64_FLAGS="-D__MODULE_KERNEL_x86_64=0 -D__MODULE_KERNEL_ia32e=1"
			fi

		else
			echo "Cannot determine kernel config!"
			exit 1
		fi
		CFLAGS_EXTRA="$CFLAGS_EXTRA $X86_64_FLAGS"
		make -C src veryclean
		make -C src INSTALL_ROOT=%{buildroot} MAN_DIR=%{_mandir} CFLAGS_EXTRA="$CFLAGS_EXTRA" BUILD_KERNEL="$KV" install
		# Makefiles can't tell the difference between the UP kernel and
		# the BOOT kernel, which is OK since they're the same config
		# as far as we are concerned.
		# But WE can tell, so once it runs, we check again and move
		# the module to the right place.  Since the UP kernel will 
		# always build last, this doesn't break anything.
		if [ $(echo $RKV | grep "BOOT") ] ; then
			mkdir -p %{buildroot}/lib/modules/$RKV/kernel/drivers/net/
			mv %{buildroot}/lib/modules/$KV/kernel/drivers/net/ians.o %{buildroot}/lib/modules/$RKV/kernel/drivers/net/
		fi
	else
		# not a Red Hat kernel, just build
		make -C src veryclean
		make -C src INSTALL_ROOT=%{buildroot} MAN_DIR=%{_mandir} install
	fi
done

%install
cd %{buildroot}
find . -name modules.* -exec rm -f {} \;
find . -type f -fprintf %{_builddir}/%{name}-%{version}/file.list "/%p\n"

%clean
rm -rf %{buildroot}

%files -f %{_builddir}/%{name}-%{version}/file.list
%defattr(-,root,root)
%doc LICENSE
%doc README
%doc ldistrib.txt
%doc file.list

%post
uname -r | grep BOOT || /sbin/depmod -aqs > /dev/null 2>&1 || true

%postun
uname -r | grep BOOT || /sbin/depmod -aqs > /dev/null 2>&1 || true
