/*******************************************************************************
* 
* Copyright(c) 1999 - 2004 Intel Corporation. All rights reserved.
* 
* "This software program is licensed subject to the GNU General Public License 
* (GPL). Version 2, June 1991, available at 
* <http://www.fsf.org/copyleft/gpl.html>"
* 
* GNU General Public License 
* 
* Version 2, June 1991
* 
* Copyright (C) 1989, 1991 Free Software Foundation, Inc.  
* 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
* 
* Everyone is permitted to copy and distribute verbatim copies of this license
* document, but changing it is not allowed.
* 
* Preamble
* 
* The licenses for most software are designed to take away your freedom to 
* share and change it. By contrast, the GNU General Public License is intended
* to guarantee your freedom to share and change free software--to make sure 
* the software is free for all its users. This General Public License applies 
* to most of the Free Software Foundation's software and to any other program 
* whose authors commit to using it. (Some other Free Software Foundation 
* software is covered by the GNU Library General Public License instead.) You 
* can apply it to your programs, too.
* 
* When we speak of free software, we are referring to freedom, not price. Our
* General Public Licenses are designed to make sure that you have the freedom 
* to distribute copies of free software (and charge for this service if you 
* wish), that you receive source code or can get it if you want it, that you 
* can change the software or use pieces of it in new free programs; and that 
* you know you can do these things.
* 
* To protect your rights, we need to make restrictions that forbid anyone to 
* deny you these rights or to ask you to surrender the rights. These 
* restrictions translate to certain responsibilities for you if you distribute
* copies of the software, or if you modify it.
* 
* For example, if you distribute copies of such a program, whether gratis or 
* for a fee, you must give the recipients all the rights that you have. You 
* must make sure that they, too, receive or can get the source code. And you 
* must show them these terms so they know their rights.
*  
* We protect your rights with two steps: (1) copyright the software, and (2) 
* offer you this license which gives you legal permission to copy, distribute 
* and/or modify the software. 
* 
* Also, for each author's protection and ours, we want to make certain that 
* everyone understands that there is no warranty for this free software. If 
* the software is modified by someone else and passed on, we want its 
* recipients to know that what they have is not the original, so that any 
* problems introduced by others will not reflect on the original authors' 
* reputations. 
* 
* Finally, any free program is threatened constantly by software patents. We 
* wish to avoid the danger that redistributors of a free program will 
* individually obtain patent licenses, in effect making the program 
* proprietary. To prevent this, we have made it clear that any patent must be 
* licensed for everyone's free use or not licensed at all. 
* 
* The precise terms and conditions for copying, distribution and modification 
* follow. 
* 
* TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
* 
* 0. This License applies to any program or other work which contains a notice
*    placed by the copyright holder saying it may be distributed under the 
*    terms of this General Public License. The "Program", below, refers to any
*    such program or work, and a "work based on the Program" means either the 
*    Program or any derivative work under copyright law: that is to say, a 
*    work containing the Program or a portion of it, either verbatim or with 
*    modifications and/or translated into another language. (Hereinafter, 
*    translation is included without limitation in the term "modification".) 
*    Each licensee is addressed as "you". 
* 
*    Activities other than copying, distribution and modification are not 
*    covered by this License; they are outside its scope. The act of running 
*    the Program is not restricted, and the output from the Program is covered 
*    only if its contents constitute a work based on the Program (independent 
*    of having been made by running the Program). Whether that is true depends
*    on what the Program does. 
* 
* 1. You may copy and distribute verbatim copies of the Program's source code 
*    as you receive it, in any medium, provided that you conspicuously and 
*    appropriately publish on each copy an appropriate copyright notice and 
*    disclaimer of warranty; keep intact all the notices that refer to this 
*    License and to the absence of any warranty; and give any other recipients 
*    of the Program a copy of this License along with the Program. 
* 
*    You may charge a fee for the physical act of transferring a copy, and you 
*    may at your option offer warranty protection in exchange for a fee. 
* 
* 2. You may modify your copy or copies of the Program or any portion of it, 
*    thus forming a work based on the Program, and copy and distribute such 
*    modifications or work under the terms of Section 1 above, provided that 
*    you also meet all of these conditions: 
* 
*    * a) You must cause the modified files to carry prominent notices stating 
*         that you changed the files and the date of any change. 
* 
*    * b) You must cause any work that you distribute or publish, that in 
*         whole or in part contains or is derived from the Program or any part 
*         thereof, to be licensed as a whole at no charge to all third parties
*         under the terms of this License. 
* 
*    * c) If the modified program normally reads commands interactively when 
*         run, you must cause it, when started running for such interactive 
*         use in the most ordinary way, to print or display an announcement 
*         including an appropriate copyright notice and a notice that there is
*         no warranty (or else, saying that you provide a warranty) and that 
*         users may redistribute the program under these conditions, and 
*         telling the user how to view a copy of this License. (Exception: if 
*         the Program itself is interactive but does not normally print such 
*         an announcement, your work based on the Program is not required to 
*         print an announcement.) 
* 
*    These requirements apply to the modified work as a whole. If identifiable 
*    sections of that work are not derived from the Program, and can be 
*    reasonably considered independent and separate works in themselves, then 
*    this License, and its terms, do not apply to those sections when you 
*    distribute them as separate works. But when you distribute the same 
*    sections as part of a whole which is a work based on the Program, the 
*    distribution of the whole must be on the terms of this License, whose 
*    permissions for other licensees extend to the entire whole, and thus to 
*    each and every part regardless of who wrote it. 
* 
*    Thus, it is not the intent of this section to claim rights or contest 
*    your rights to work written entirely by you; rather, the intent is to 
*    exercise the right to control the distribution of derivative or 
*    collective works based on the Program. 
* 
*    In addition, mere aggregation of another work not based on the Program 
*    with the Program (or with a work based on the Program) on a volume of a 
*    storage or distribution medium does not bring the other work under the 
*    scope of this License. 
* 
* 3. You may copy and distribute the Program (or a work based on it, under 
*    Section 2) in object code or executable form under the terms of Sections 
*    1 and 2 above provided that you also do one of the following: 
* 
*    * a) Accompany it with the complete corresponding machine-readable source 
*         code, which must be distributed under the terms of Sections 1 and 2 
*         above on a medium customarily used for software interchange; or, 
* 
*    * b) Accompany it with a written offer, valid for at least three years, 
*         to give any third party, for a charge no more than your cost of 
*         physically performing source distribution, a complete machine-
*         readable copy of the corresponding source code, to be distributed 
*         under the terms of Sections 1 and 2 above on a medium customarily 
*         used for software interchange; or, 
* 
*    * c) Accompany it with the information you received as to the offer to 
*         distribute corresponding source code. (This alternative is allowed 
*         only for noncommercial distribution and only if you received the 
*         program in object code or executable form with such an offer, in 
*         accord with Subsection b above.) 
* 
*    The source code for a work means the preferred form of the work for 
*    making modifications to it. For an executable work, complete source code 
*    means all the source code for all modules it contains, plus any 
*    associated interface definition files, plus the scripts used to control 
*    compilation and installation of the executable. However, as a special 
*    exception, the source code distributed need not include anything that is 
*    normally distributed (in either source or binary form) with the major 
*    components (compiler, kernel, and so on) of the operating system on which
*    the executable runs, unless that component itself accompanies the 
*    executable. 
* 
*    If distribution of executable or object code is made by offering access 
*    to copy from a designated place, then offering equivalent access to copy 
*    the source code from the same place counts as distribution of the source 
*    code, even though third parties are not compelled to copy the source 
*    along with the object code. 
* 
* 4. You may not copy, modify, sublicense, or distribute the Program except as
*    expressly provided under this License. Any attempt otherwise to copy, 
*    modify, sublicense or distribute the Program is void, and will 
*    automatically terminate your rights under this License. However, parties 
*    who have received copies, or rights, from you under this License will not
*    have their licenses terminated so long as such parties remain in full 
*    compliance. 
* 
* 5. You are not required to accept this License, since you have not signed 
*    it. However, nothing else grants you permission to modify or distribute 
*    the Program or its derivative works. These actions are prohibited by law 
*    if you do not accept this License. Therefore, by modifying or 
*    distributing the Program (or any work based on the Program), you 
*    indicate your acceptance of this License to do so, and all its terms and
*    conditions for copying, distributing or modifying the Program or works 
*    based on it. 
* 
* 6. Each time you redistribute the Program (or any work based on the 
*    Program), the recipient automatically receives a license from the 
*    original licensor to copy, distribute or modify the Program subject to 
*    these terms and conditions. You may not impose any further restrictions 
*    on the recipients' exercise of the rights granted herein. You are not 
*    responsible for enforcing compliance by third parties to this License. 
* 
* 7. If, as a consequence of a court judgment or allegation of patent 
*    infringement or for any other reason (not limited to patent issues), 
*    conditions are imposed on you (whether by court order, agreement or 
*    otherwise) that contradict the conditions of this License, they do not 
*    excuse you from the conditions of this License. If you cannot distribute 
*    so as to satisfy simultaneously your obligations under this License and 
*    any other pertinent obligations, then as a consequence you may not 
*    distribute the Program at all. For example, if a patent license would 
*    not permit royalty-free redistribution of the Program by all those who 
*    receive copies directly or indirectly through you, then the only way you 
*    could satisfy both it and this License would be to refrain entirely from 
*    distribution of the Program. 
* 
*    If any portion of this section is held invalid or unenforceable under any
*    particular circumstance, the balance of the section is intended to apply
*    and the section as a whole is intended to apply in other circumstances. 
* 
*    It is not the purpose of this section to induce you to infringe any 
*    patents or other property right claims or to contest validity of any 
*    such claims; this section has the sole purpose of protecting the 
*    integrity of the free software distribution system, which is implemented 
*    by public license practices. Many people have made generous contributions
*    to the wide range of software distributed through that system in 
*    reliance on consistent application of that system; it is up to the 
*    author/donor to decide if he or she is willing to distribute software 
*    through any other system and a licensee cannot impose that choice. 
* 
*    This section is intended to make thoroughly clear what is believed to be 
*    a consequence of the rest of this License. 
* 
* 8. If the distribution and/or use of the Program is restricted in certain 
*    countries either by patents or by copyrighted interfaces, the original 
*    copyright holder who places the Program under this License may add an 
*    explicit geographical distribution limitation excluding those countries, 
*    so that distribution is permitted only in or among countries not thus 
*    excluded. In such case, this License incorporates the limitation as if 
*    written in the body of this License. 
* 
* 9. The Free Software Foundation may publish revised and/or new versions of 
*    the General Public License from time to time. Such new versions will be 
*    similar in spirit to the present version, but may differ in detail to 
*    address new problems or concerns. 
* 
*    Each version is given a distinguishing version number. If the Program 
*    specifies a version number of this License which applies to it and "any 
*    later version", you have the option of following the terms and 
*    conditions either of that version or of any later version published by 
*    the Free Software Foundation. If the Program does not specify a version 
*    number of this License, you may choose any version ever published by the 
*    Free Software Foundation. 
* 
* 10. If you wish to incorporate parts of the Program into other free programs
*     whose distribution conditions are different, write to the author to ask 
*     for permission. For software which is copyrighted by the Free Software 
*     Foundation, write to the Free Software Foundation; we sometimes make 
*     exceptions for this. Our decision will be guided by the two goals of 
*     preserving the free status of all derivatives of our free software and 
*     of promoting the sharing and reuse of software generally. 
* 
*    NO WARRANTY
* 
* 11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY 
*     FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN 
*     OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES 
*     PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
*     EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
*     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
*     ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH 
*     YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL 
*     NECESSARY SERVICING, REPAIR OR CORRECTION. 
* 
* 12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING 
*     WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR 
*     REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR 
*     DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL 
*     DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM 
*     (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED 
*     INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF 
*     THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR 
*     OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 
* 
* END OF TERMS AND CONDITIONS
* 
* How to Apply These Terms to Your New Programs
* 
* If you develop a new program, and you want it to be of the greatest 
* possible use to the public, the best way to achieve this is to make it free 
* software which everyone can redistribute and change under these terms. 
* 
* To do so, attach the following notices to the program. It is safest to 
* attach them to the start of each source file to most effectively convey the
* exclusion of warranty; and each file should have at least the "copyright" 
* line and a pointer to where the full notice is found. 
* 
* one line to give the program's name and an idea of what it does.
* Copyright (C) yyyy  name of author
* 
* This program is free software; you can redistribute it and/or modify it 
* under the terms of the GNU General Public License as published by the Free 
* Software Foundation; either version 2 of the License, or (at your option) 
* any later version.
* 
* This program is distributed in the hope that it will be useful, but WITHOUT 
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
* more details.
* 
* You should have received a copy of the GNU General Public License along with
* this program; if not, write to the Free Software Foundation, Inc., 59 
* Temple Place - Suite 330, Boston, MA  02111-1307, USA.
* 
* Also add information on how to contact you by electronic and paper mail. 
* 
* If the program is interactive, make it output a short notice like this when 
* it starts in an interactive mode: 
* 
* Gnomovision version 69, Copyright (C) year name of author Gnomovision comes 
* with ABSOLUTELY NO WARRANTY; for details type 'show w'.  This is free 
* software, and you are welcome to redistribute it under certain conditions; 
* type 'show c' for details.
* 
* The hypothetical commands 'show w' and 'show c' should show the appropriate 
* parts of the General Public License. Of course, the commands you use may be 
* called something other than 'show w' and 'show c'; they could even be 
* mouse-clicks or menu items--whatever suits your program. 
* 
* You should also get your employer (if you work as a programmer) or your 
* school, if any, to sign a "copyright disclaimer" for the program, if 
* necessary. Here is a sample; alter the names: 
* 
* Yoyodyne, Inc., hereby disclaims all copyright interest in the program 
* 'Gnomovision' (which makes passes at compilers) written by James Hacker.
* 
* signature of Ty Coon, 1 April 1989
* Ty Coon, President of Vice
* 
* This General Public License does not permit incorporating your program into 
* proprietary programs. If your program is a subroutine library, you may 
* consider it more useful to permit linking proprietary applications with the 
* library. If this is what you want to do, use the GNU Library General Public 
* License instead of this License.
*******************************************************************************/

/*****************************************************************************
******************************************************************************
**                                                                          **
** INTEL CORPORATION                                                        **
**                                                                          **
** This software is supplied under the terms of the license included        **
** above.  All use of this software must be in accordance with the terms    **
** of that license.                                                         **
**                                                                          **
** THIS FILE IS USED WHEN CREATING ians_core.o. HENCE, IT SHOULD NOT BE     **
** MODIFIED!                                                                **
**                                                                          **
**  Module Name:    incg_dev.c                                              **
**                                                                          **
**  Abstract:       This module contains all the functions needed for the   **
**                  interface of network devices with the kernel.           **
**                                                                          **
**  Environment:    Kernel Mode (Linux 2.4.x)                               **
**                                                                          **
**                  Written using Tab Size = 4, Indent Size = 4             **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
**      01-01-2002  Shmulik Hen,    1st created                             **
**                                                                          **
******************************************************************************
*****************************************************************************/

#include <linux/netdevice.h>
#include <linux/rtnetlink.h>
#include <linux/skbuff.h>
#include <linux/if.h>
#include <linux/sockios.h>
#include <linux/string.h>
#include <net/pkt_sched.h>
#include <asm/uaccess.h>
 
#ifdef IFF_802_1Q_VLAN
    #include <linux/if_vlan.h>
#endif //IFF_802_1Q_VLAN

#ifdef SIOCETHTOOL
    #include <linux/ethtool.h>

    #ifndef ETHTOOL_BUSINFO_LEN
        #define ETHTOOL_BUSINFO_LEN 32
    #endif

    #ifndef SUPPORTED_10000baseT_Full
        #define SUPPORTED_10000baseT_Full (1 << 12)
    #endif
    #ifndef SPEED_10000
        #define SPEED_10000 10000
    #endif
#endif //SIOCETHTOOL

#include "ians_kcompat.h"
#include "ians_status.h"
#include "ans_interface.h"
#include "lib/incg_defs.h"
#include "lib/incg_dev.h"
#include "lib/incg_open_utils.h"
#include "lib/incg_gp_mem.h"
#include "lib/incg_message.h"

#ifndef SIOCGMIIPHY
#define SIOCGMIIPHY (SIOCDEVPRIVATE)        /* Get the PHY in use. */
#define SIOCGMIIREG (SIOCDEVPRIVATE+1)      /* Read a PHY register. */
#endif //SIOCGMIIPHY


/* This struct is a wrapper node for a list of packet_type structs.
 * We save the entire packet_type inside (and not just a pointer to it)
 * so that we'll only need one allocation per such node. */
struct packet_node {
    struct packet_type type;
    struct packet_node *next;
};

/*-------------------------- SERVICE FUNCTIONS -----------------------------*/
#ifdef MAX_SKB_FRAGS
static inline IANS_STATUS _ConvertAnsFeaturesToNetDevFeatures(UINT32 features, int *dev_features);
static inline IANS_STATUS _ConvertNetDevFeaturesToAnsFeatures(int dev_features, UINT32 *features);
#endif //MAX_SKB_FRAGS


/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: wrapper for rtnl_lock                                         **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iansDevRtnlLock(void)
{
    rtnl_lock();
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: wrapper for rtnl_unlock                                       **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iansDevRtnlUnlock(void)
{
    rtnl_unlock();
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
int iansOpenReceive(struct sk_buff *skb, struct net_device *dev, struct packet_type *pt)
{
    IANS_FLOW_STATUS res;
    message_t msg; //automatic variable to save allocation time.

    if (skb == NULL) {
       IANS_PRINT_ERROR("skb == NULL\n");
       return NET_RX_BAD;
    }

    if (dev == NULL) {
        IANS_PRINT_ERROR("dev == NULL\n");
        kfree_skb(skb);
        return NET_RX_BAD;
    }

    if (dev->name == NULL) {
        IANS_PRINT_ERROR("dev->name == NULL\n");
        kfree_skb(skb);
        return NET_RX_BAD;
    }

    if (skb->pkt_type == PACKET_OUTGOING) {
        //We are not interested in seeing evry outgoing packet
        kfree_skb(skb);
        return 0;
    }

    /*
    * we can't clone, because we need to kfree the original skb before returning
    if ((skb = skb_share_check(skb, GFP_ATOMIC)) == NULL) {
        return NET_RX_DROP;
    }
    */

    iAnsMemSet(&msg, 0, sizeof(message_t));
    iansConvertMessageToAnsMessage(skb, &msg, RECEIVE_FLOW);

    ANSConfigLock();

    res = ANSReceive(&msg, dev->name, (pPacket_t) pt);

    ANSConfigUnlock();

    if(res == FLOW_CONTINUE) {
        netif_rx(skb);
    }
    else {
        kfree_skb(skb);
    }

    if (res == FLOW_OK || res == FLOW_CONTINUE) {
               return NET_RX_SUCCESS;
    }

    // anything else is considered an error
    switch(res) {
        case FLOW_DOESNT_EXIST:
            IANS_PRINT_DEBUG("flow doesn't exist\n");
            break;
        case FLOW_DROP:
            IANS_PRINT_DEBUG("packet dropped\n");
            break;
        case FLOW_INTERNAL_ERROR:
            IANS_PRINT_DEBUG("internal error\n");
            break;
        case FLOW_WRONG_STATE:
            IANS_PRINT_DEBUG("flow in wrong state\n");
            break;
        default:
            break;
    }

    return NET_RX_DROP;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: This function receives unstripped vlan packets, stripps them  **
**            and sends them back up through the matching vadapter.         **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
int iansVlanOpenReceive(struct sk_buff *skb, struct net_device *dev, struct packet_type *pt)
{
    IANS_FLOW_STATUS res;
    message_t msg; //automatic variable to save allocation time.

    if (skb == NULL) {
       IANS_PRINT_ERROR("skb == NULL\n");
       return NET_RX_BAD;
    }

    if (dev == NULL) {
        IANS_PRINT_ERROR("dev == NULL\n");
        kfree_skb(skb);
        return NET_RX_BAD;
    }

    if (dev->name == NULL) {
        IANS_PRINT_ERROR("dev->name == NULL\n");
        kfree_skb(skb);
        return NET_RX_BAD;
    }

    if (skb->pkt_type == PACKET_OUTGOING) {
        //We are not interested in seeing evry outgoing packet
        kfree_skb(skb);
        return 0;
    }

    if (skb->protocol != PKT_TYPE_VLAN) {
        IANS_PRINT_ERROR("Not a vlan packet");
        kfree_skb(skb);
        return 0;
    }

    iAnsMemSet(&msg, 0, sizeof(message_t));
    iansConvertMessageToAnsMessage(skb, &msg, RECEIVE_FLOW);

    ANSConfigLock();

    res = ANSVlanReceive(&msg, dev->name);

    ANSConfigUnlock();

    if(res == FLOW_CONTINUE) {
        netif_rx(skb);
    }
    else {
        kfree_skb(skb);
    }

    if (res == FLOW_CONTINUE) {
               return NET_RX_SUCCESS;
    }

    // anything else is considered an error
    switch(res) {
        case FLOW_DOESNT_EXIST:
            IANS_PRINT_DEBUG("flow doesn't exist\n");
            break;
        case FLOW_DROP:
            IANS_PRINT_DEBUG("packet dropped\n");
            break;
        case FLOW_INTERNAL_ERROR:
            IANS_PRINT_DEBUG("internal error\n");
            break;
        case FLOW_WRONG_STATE:
            IANS_PRINT_DEBUG("flow in wrong state\n");
            break;
    default:
            IANS_PRINT_DEBUG("bad flow - drop packet!\n");
            break;
    }

    return NET_RX_DROP;

}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: set the mac address of the ans device and the net_device      **
**            The ans device points to the net_device addr                  **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:the rtnl_lock is held                                       **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iansDevSetMac(device_t *ansDev, MAC_ADDR addr)
{
    ASSERT(ansDev);

    ASSERT_RTNL();

    *(ansDev->mac) = addr;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: set the mac address of the ans device and the net_device      **
**            The ans device points to the net_device addr                  **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:the rtnl_lock is held                                       **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
MAC_ADDR iansDevGetMac(device_t *ansDev)
{
    ASSERT(ansDev);

    ASSERT_RTNL();

    return *(ansDev->mac);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions: This function is only called when rtnl_lock is held.       **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void baseSetPromiscuousMode(device_t *ansDev, BOOLEAN mode)
{
    struct net_device *dev = (struct net_device *) GET_OS_DEV(ansDev) ;

    ASSERT_RTNL();

    if(mode == TRUE) {
        dev_set_promiscuity(dev, 1);
    }
    else {
        dev_set_promiscuity(dev, -1);
    }
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions: This function is only called when rtnl_lock is held.       **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void baseSetAllMultiMode(device_t *ansDev, BOOLEAN mode)
{
    struct net_device *dev = (struct net_device *) GET_OS_DEV(ansDev) ;

    ASSERT_RTNL();

    if(mode == TRUE) {
        dev_set_allmulti(dev, 1);
    }
    else {
        dev_set_allmulti(dev, -1);
    }
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: Allocate a packet type and add to it the kernel network stack **
**            to the list of ANS packet types.                              **
**                                                                          **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value: the allocated packet type struct in pktType and the       **
**                IANS_STATUS                                               **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iansDevAddPack(unsigned int type, device_t *ansDev, pOsPktType_t *pktType)
{
    pOsPktType_t newType = NULL;

    //allocate packet type
    iNCGGPSizedMemAlloc((void **)(&newType), sizeof(struct packet_node));

    if (newType == NULL) {
        IANS_PRINT_ERROR("Failed to allocate a packet type struct.\n");
        return IANS_MEM_ERROR;
    }

    memset(newType, 0, sizeof(struct packet_node));

    //initialize packet type
    newType->type.type = type;
    newType->type.dev = (struct net_device*) GET_OS_DEV(ansDev);
    newType->type.func = (type == PKT_TYPE_VLAN ? iansVlanOpenReceive : iansOpenReceive);
    newType->type.data = (void*)1;  // understand shared skbs

    //add new packet type to internal ANS list
    newType->next = *pktType;
    *pktType = newType;

    dev_add_pack(&(newType->type));

    return IANS_OK;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:Remove a list of packet types from kernel net_work stack and   **
**           free the packet type struct.                                   **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iansDevRemPack(pOsPktType_t *pktType)
{
    pOsPktType_t currType = NULL;
    pOsPktType_t nextType = *pktType;

    while (nextType) {
        currType = nextType;
        nextType = nextType->next;
        dev_remove_pack(&(currType->type));
        //free packet type
        iNCGGPMemFree((void **)&currType);
    }

    *pktType = NULL;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iansRegisterDev(device_t *ansDev)
{
    struct net_device * dev;

    ASSERT(ansDev);
    ASSERT(ansDev->name);
    ASSERT_RTNL();

    dev = (struct net_device *) GET_OS_DEV(ansDev);

    if (dev == NULL) {
        return IANS_VADAPTER_REGISTER_FAIL;
    }

    //IANS_PRINT_DEBUG("Registering vadapter %s\n", dev->name);

    register_netdevice(dev);

    return IANS_OK;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iansUnregisterDev(device_t *ansDev, BOOLEAN close)
{
    struct net_device * devExist = NULL;

    ASSERT(ansDev);
    ASSERT(ansDev->name);
    ASSERT_RTNL();

    if ((devExist = dev_get_by_name(ansDev->name))) {
        dev_put(devExist);
        if (devExist != (struct net_device *) GET_OS_DEV(ansDev)) {
            IANS_PRINT_ERROR("Mismatch of kernel and ANS pointers to %s's device structure - cann't unregister the net device!\n", ansDev->name);
            return;
        }
        else {//unregister the device.
            if (close) {
                dev_close(devExist);
            }

            unregister_netdevice(devExist);
        }
    }
    else {
        IANS_PRINT_ERROR("Device %s doesn't exist - cann't unregister the net device!\n", ansDev->name);
    }
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iansSetMaster(device_t *ansSlave, device_t *ansMaster)
{
    struct net_device *slave = (struct net_device *)GET_OS_DEV(ansSlave);
    struct net_device *master = NULL;
    IANS_STATUS res = IANS_OK;

    ASSERT(slave);
    ASSERT_RTNL();

    if (ansMaster) { //enslave
        master = (struct net_device *)GET_OS_DEV(ansMaster);
    }

    if (netdev_set_master(slave, master) != 0) {
        res = (master ? IANS_FAILED_ENSLAVE_MEMBER : IANS_FAILED_RELEASE_MEMBER);
    }

    return res;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iansDevPut(device_t *ansDev)
{
    struct net_device *dev = (struct net_device *) GET_OS_DEV(ansDev);
    ASSERT(dev);

    dev_put(dev);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
BOOLEAN iansIfStopped(device_t *ansDev)
{
    struct net_device *dev = (struct net_device *) GET_OS_DEV(ansDev);
    ASSERT(dev);

    return netif_queue_stopped(dev);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iansIfStop(device_t *ansDev)
{
    struct net_device *dev = (struct net_device *) GET_OS_DEV(ansDev);
    ASSERT(dev);

    netif_stop_queue(dev);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iansIfWake(device_t *ansDev)
{
    struct net_device *dev = (struct net_device *) GET_OS_DEV(ansDev);
    ASSERT(dev);

    netif_wake_queue(dev);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iansIfFlush(device_t *ansDev)
{
    unsigned long flags;
    struct net_device *dev = (struct net_device *) GET_OS_DEV(ansDev);
    ASSERT(dev);

    spin_lock_irqsave(&dev->queue_lock, flags);
    qdisc_reset(dev->qdisc);
    spin_unlock_irqrestore(&dev->queue_lock, flags);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
BOOLEAN iansBaseDevIsOpen(device_t *ansDev)
{
    struct net_device *dev=NULL;
    ASSERT(ansDev);
    dev = (struct net_device *) GET_OS_DEV(ansDev);
    ASSERT(dev);

    if (netif_running(dev) || (dev->flags & IFF_UP)) {
        return TRUE;
    }
    return FALSE;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
ULONG iansGetDeviceBaseAddr(device_t *ansDev)
{
    struct net_device *dev=NULL;
    ASSERT(ansDev);
    dev = (struct net_device *) GET_OS_DEV(ansDev);
    ASSERT(dev);

    return(ULONG)(dev->base_addr ? dev->base_addr : dev->mem_start);
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iansGetDevBaseAddrByName(char *devName, UINT32 *baseAddr)
{
    struct net_device *dev;

    dev = dev_get_by_name(devName);
    if (dev == NULL) {
        //IANS_PRINT_ERROR("Device %s doesn't exist!\n", devName);
        return IANS_ERROR;
    }

    *baseAddr = (UINT32)dev->base_addr;

    dev_put(dev);

    return IANS_OK;
}

/*----------------------------- Scatter-Gather -----------------------------*/

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iansGetDevFeatures(device_t *ansDev, UINT32 *features)
{
#ifdef MAX_SKB_FRAGS
    struct net_device *dev=NULL;
    IANS_STATUS res = IANS_OK;

    ASSERT(ansDev);
    dev = (struct net_device *) GET_OS_DEV(ansDev);
    ASSERT(dev);

    res = _ConvertNetDevFeaturesToAnsFeatures(dev->features, features);
    if (res != IANS_OK) {
        return res;
    }

    IANS_PRINT_DEBUG("%s:\nSG %sabled FRAGLIST %sabled HIGHDMA %sabled IP_CSUM %sabled HW_CSUM %sabled\n",
                     dev->name,
                     (dev->features & NETIF_F_SG)       ? "en" : "dis",
                     (dev->features & NETIF_F_FRAGLIST) ? "en" : "dis",
                     (dev->features & NETIF_F_HIGHDMA)  ? "en" : "dis",
                     (dev->features & NETIF_F_IP_CSUM)  ? "en" : "dis",
                     (dev->features & NETIF_F_HW_CSUM)  ? "en" : "dis");
#endif //MAX_SKB_FRAGS

    return IANS_OK;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iansSetDevFeatures(device_t *ansDev, UINT32 features)
{
#ifdef MAX_SKB_FRAGS
    struct net_device *dev=NULL;
    IANS_STATUS res = IANS_OK;

    ASSERT(ansDev);
    dev = (struct net_device *) GET_OS_DEV(ansDev);
    ASSERT(dev);

    res = _ConvertAnsFeaturesToNetDevFeatures(features, &(dev->features));
    if (res != IANS_OK) {
        return res;
    }

    IANS_PRINT_DEBUG("%s:\nSG %sabled FRAGLIST %sabled HIGHDMA %sabled IP_CSUM %sabled HW_CSUM %sabled\n",
                     dev->name,
                     (dev->features & NETIF_F_SG)       ? "en" : "dis",
                     (dev->features & NETIF_F_FRAGLIST) ? "en" : "dis",
                     (dev->features & NETIF_F_HIGHDMA)  ? "en" : "dis",
                     (dev->features & NETIF_F_IP_CSUM)  ? "en" : "dis",
                     (dev->features & NETIF_F_HW_CSUM)  ? "en" : "dis");
#endif //MAX_SKB_FRAGS

    return IANS_OK;
}

#ifdef MAX_SKB_FRAGS
/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
static inline IANS_STATUS _ConvertNetDevFeaturesToAnsFeatures(int dev_features, UINT32 *features)
{
    *features = 0;

    if (dev_features & NETIF_F_SG) {
        *features |= IANS_NETIF_SG;
    }
    if (dev_features & NETIF_F_IP_CSUM) {
        *features |= IANS_NETIF_IP_CSUM;
    }
    if (dev_features & NETIF_F_HW_CSUM) {
        *features |= IANS_NETIF_HW_CSUM;
    }
    if (dev_features & NETIF_F_HIGHDMA) {
        *features |= IANS_NETIF_HIGHDMA;
    }
    if (dev_features & NETIF_F_FRAGLIST) {
        *features |= IANS_NETIF_FRAGLIST;
    }

    return IANS_OK;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
static inline IANS_STATUS _ConvertAnsFeaturesToNetDevFeatures(UINT32 features, int *dev_features)
{
    if (features & IANS_NETIF_SG) {
        *dev_features |= NETIF_F_SG;
    }
    else {
        *dev_features &= ~(NETIF_F_SG);
    }
    if (features & IANS_NETIF_IP_CSUM) {
        *dev_features |= NETIF_F_IP_CSUM;
    }
    else {
        *dev_features &= ~(NETIF_F_IP_CSUM);
    }
    if (features & IANS_NETIF_HW_CSUM) {
        *dev_features |= NETIF_F_HW_CSUM;
    }
    else {
        *dev_features &= ~(NETIF_F_HW_CSUM);
    }
    if (features & IANS_NETIF_HIGHDMA) {
        *dev_features |= NETIF_F_HIGHDMA;
    }
    else {
        *dev_features &= ~(NETIF_F_HIGHDMA);
    }
    if (features & IANS_NETIF_FRAGLIST) {
        *dev_features |= NETIF_F_FRAGLIST;
    }
    else {
        *dev_features &= ~(NETIF_F_FRAGLIST);
    }

    return IANS_OK;
}
#endif //MAX_SKB_FRAGS


/*-------------------------- VLAN hwaccel support --------------------------*/

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: Checks whether the base driver + kernel support hwaccel       **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
BOOLEAN iNCGDevSupportsVLANHwaccel(device_t *baseDev)
{
#ifdef NETIF_F_HW_VLAN_TX  
    struct net_device *dev = GET_OS_DEV(baseDev);

    ASSERT(dev);

    if (dev->features & NETIF_F_VLAN_CHALLENGED) {
        printk(KERN_INFO "Device %s cannot handle VLAN packets\n", dev->name);
        return FALSE;
    }

    //check if there is hw stripping and tagging
    if (!(dev->features & NETIF_F_HW_VLAN_RX) || !(dev->features & NETIF_F_HW_VLAN_TX)) {
        printk(KERN_INFO "Device %s does NOT support Tx/Rx VLAN hw acceleration\n", dev->name);
        return FALSE;
    }

    //check if base driver hwaccel is not buggy
    if ((dev->features & NETIF_F_HW_VLAN_RX) && (dev->vlan_rx_register == NULL || dev->vlan_rx_kill_vid == NULL)) {
        IANS_PRINT_ERROR("Device %s has buggy Rx VLAN hw acceleration\n", dev->name);
        return FALSE;
    }

    if ((dev->features & NETIF_F_HW_VLAN_FILTER) && (dev->vlan_rx_add_vid == NULL || dev->vlan_rx_kill_vid == NULL)) {
        IANS_PRINT_ERROR("Device %s has buggy VLAN Rx filtering hw acceleration.\n", dev->name);
        return FALSE;
    }

    printk(KERN_INFO "Device %s supports VLAN hw acceleration\n", dev->name);

    return TRUE;

#else

    printk(KERN_INFO "The running kernel does not support VLAN hw acceleration\n");        

#endif //NETIF_F_HW_VLAN_TX

    return FALSE;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: Checks whether the base driver + kernel support hwaccel       **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
BOOLEAN iNCGDevSupportsVLANHwaccelFiltering(device_t *baseDev)
{
#if defined(DEBUG) || defined(NETIF_F_HW_VLAN_TX)  
    struct net_device *dev = GET_OS_DEV(baseDev);    
    ASSERT(dev);
#endif    

#ifdef NETIF_F_HW_VLAN_TX
    if ((dev->features & NETIF_F_HW_VLAN_FILTER)) {
        IANS_PRINT_DEBUG("adapter %s supports vlan hwaccel filtering\n", dev->name);
        return TRUE;
    }
#endif //NETIF_F_HW_VLAN_TX

    IANS_PRINT_DEBUG("adapter %s does NOT support vlan hwaccel filtering\n", dev->name);
    return FALSE;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: Initializes the vlan part of the vadapter net_device          **
**            1. allocates dev->priv                                        **
**            2. initializes vlan related flags                             **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions: This data structure is needed so that the vlan_hwaccel_rx()**
**               function will work properly since it accesses the ingress  **
**               priority table. We do not initialize any of the fields in  **
**               this struct and hope that there will no be any problems    **
**               in the future.                                             **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iNCGDevVlanInit(device_t *vadapterDev)
{
#ifdef IFF_802_1Q_VLAN  
    struct net_device *dev = GET_OS_DEV(vadapterDev);

    ASSERT(dev);

    IANS_PRINT_DEBUG("alloc dev->priv \n");

    //alocate the private dev
    iNCGGPSizedMemAlloc((void **)(&(dev->priv)), sizeof(struct vlan_dev_info));

    if (dev->priv == NULL) {
        return IANS_MEM_ERROR;
    }

    memset(dev->priv, 0, sizeof(struct vlan_dev_info));

    IANS_PRINT_DEBUG(KERN_DEBUG "Initialized vlan dev!\n");

    return IANS_OK;

#endif //IFF_802_1Q_VLAN

    //IANS_PRINT_DEBUG("iNCGDevVlanInit: hwaccel not supported!\n");
    return IANS_OK;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**                                                                          **
**  Abstract: De-Initializes the vlan part of the vadapter net_device       **
**            1. De-allocates dev->priv                                     **
**                                                                          **
**                                                                          **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iNCGDevVlanDeinit(device_t *vadapterDev)
{
    struct net_device *dev = GET_OS_DEV(vadapterDev);

    ASSERT(dev);

    IANS_PRINT_DEBUG("Vlan dev de-init!\n");

    if (dev->priv) {
        iNCGGPMemFree(&(dev->priv));
    }

    return IANS_OK;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: Allocate and initialize a struct vlan_group                   **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
pOsVlanGrp_t iNCGDevVlanInitVlanGroup(void)
{
#ifdef NETIF_F_HW_VLAN_TX
    struct vlan_group *grp = NULL;

    iNCGGPSizedMemAlloc((void **)(&grp), sizeof(struct vlan_group));

    if (grp == NULL) {
        IANS_PRINT_ERROR("failed to allocate the vlan group!\n");
        return NULL;
    }

    //IANS_PRINT_DEBUG("allocated vlan group!\n");
    memset(grp, 0, sizeof(struct vlan_group));

    return grp;

#else //NETIF_F_HW_VLAN_TX

    //IANS_PRINT_DEBUG("hwaccel not supported - did not alloc vlan group\n");

    return NULL;

#endif //NETIF_F_HW_VLAN_TX

}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: Allocate and initialize a struct vlan_group                   **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
void iNCGDevVlanDeinitVlanGroup(pOsVlanGrp_t grp)
{
    //IANS_PRINT_DEBUG("De-Initialized vlan group!\n");

    if (grp) {
        iNCGGPMemFree((void **)&grp);
    }
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:  Adds the vadapter's net_device to a vlan_group.              **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iNCGDevVlanAddToVlanGroup(device_t *vadapterDev, unsigned short vlanid, pOsVlanGrp_t grp)
{
#ifdef NETIF_F_HW_VLAN_TX  
    struct net_device *dev = GET_OS_DEV(vadapterDev);

    ASSERT(dev);

    if (grp == NULL) {
        IANS_PRINT_ERROR("vlan group doesn't exist!\n");
        return IANS_MEM_ERROR;
    }

    //check range of vlanid
    if (vlanid >= 0xfff || vlanid == 0) {
        IANS_PRINT_ERROR("Vlan id is out of range!\n");
        return IANS_VLAN_ID_OUT_OF_RANGE;
    }


    if (grp->vlan_devices[vlanid]) {
        IANS_PRINT_ERROR("Vlan id is not unique!\n");
        return IANS_VLAN_ID_NOT_UNIQUE;
    }

    grp->vlan_devices[vlanid] = dev;

    IANS_PRINT_DEBUG("Added vlanid %d to vlan group!\n", vlanid);

    return IANS_OK;

#else //NETIF_F_HW_VLAN_TX

    return IANS_OK;

#endif //NETIF_F_HW_VLAN_TX

}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: Deletes the vadapter's net_device from the vlan_group.        **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iNCGDevVlanDelFromVlanGroup(pOsVlanGrp_t grp, unsigned short vlanid)
{
    //The base driver does this when it is instructed to remove the vlanid
    //When this vlan group is over a team the team has one shared vlan group for
    //all members in the team. Removing the valnid from the table removes it from all
    //members. The hwaccel implementation is that the base driver removes the vlanid
    //from the vlan group when vlan_rx_kill_vid is called. The base driver disables
    //all irq events on the adapter when doing this so that to avoid a race with the receive
    //function. ANS will not disable receive on all the team adapters before performing this operation
    //but rather will rely on the check of the vlan_hwaccel_rx function that the vlan_devices[vlanid] is
    //not NULL. If it is found to be NULL the packet is dropped!


#ifdef NETIF_F_HW_VLAN_TX

    if (grp == NULL) {
        IANS_PRINT_ERROR("vlan group doesn't exist!\n");
        return IANS_MEM_ERROR;
    }

    //check range of vlanid
    if (vlanid >= 0xfff || vlanid == 0) {
        IANS_PRINT_ERROR("Vlan id is out of range!\n");
        return IANS_VLAN_ID_OUT_OF_RANGE;
    }

    grp->vlan_devices[vlanid] = NULL;

    IANS_PRINT_DEBUG("Deleted vlanid %d from vlan group\n", vlanid);

    return IANS_OK;

#else //NETIF_F_HW_VLAN_TX

    return IANS_OK;

#endif //NETIF_F_HW_VLAN_TX

}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:  instruct the base driver to add the vlanid to its valn       **
**             filtering table.                                             **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iNCGDevVlanAddToBaseDev(device_t *baseDev, unsigned short vlanid)
{
#ifdef NETIF_F_HW_VLAN_TX  
    struct net_device *dev = GET_OS_DEV(baseDev);

    ASSERT(dev);

    //The vlan group is NOT referenced by the base driver during this opertaion
    if (dev->features & NETIF_F_HW_VLAN_FILTER) {
        dev->vlan_rx_add_vid(dev, vlanid);
    }

    IANS_PRINT_DEBUG("Added vlanid %d to adapter %s\n", vlanid, dev->name);

    return IANS_OK;

#endif //NETIF_F_HW_VLAN_TX

    IANS_PRINT_DEBUG("iNCGDevVlanAddToBaseDev: vlan hwaccel not supported!\n");

    return IANS_NOT_SUPPORTED_YET;

}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:  Instructs the base driver to remove the vlan id from its     **
**             valn filtering table and from the vlan group.                **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iNCGDevVlanDelFromBaseDev(device_t *baseDev, unsigned short vlanid)
{
#ifdef NETIF_F_HW_VLAN_TX
    struct net_device *dev = GET_OS_DEV(baseDev);

    ASSERT(dev);

    //assumption - rtnl_lock is held (problem with hot plug ?)
    if (dev->features & (NETIF_F_HW_VLAN_RX | NETIF_F_HW_VLAN_FILTER)) {
        //The following operation removes the vlanid from the valn group which is shared by all members in a team.
        //If this is called when removing a member we must make sure that the vlan group has
        //already been unregistered from the base driver at this point so that the vlanid is
        //not removed from the shared vlan group
        dev->vlan_rx_kill_vid(dev, vlanid);
    }

    IANS_PRINT_DEBUG("Deleted vlanid %d from adapter %s\n", vlanid, dev->name);

    return IANS_OK;

#endif //NETIF_F_HW_VLAN_TX

    IANS_PRINT_DEBUG("iNCGDevVlanDelFromBaseDev: vlan hwaccel not supported!\n");

    return IANS_NOT_SUPPORTED_YET;

}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: Deletes the vadapter's net_device from the vlan_group.        **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iNCGDevVlanRegisterVlanGroup(device_t *baseDev, pOsVlanGrp_t grp)
{
#ifdef NETIF_F_HW_VLAN_TX  
    struct net_device *dev = GET_OS_DEV(baseDev);

    ASSERT(dev);

    if (grp == NULL) {
        IANS_PRINT_DEBUG("The vlan group is NULL\n");
        return IANS_MEM_ERROR;
    }

    if (dev->features & NETIF_F_HW_VLAN_RX) {
        dev->vlan_rx_register(dev, grp);
    }

    IANS_PRINT_DEBUG("Registered vlan group with adapter %s\n", dev->name);

    return IANS_OK;

#endif //NETIF_F_HW_VLAN_TX

    IANS_PRINT_DEBUG("iNCGDevVlanRegisterVlanGroup: vlan hwaccel not supported!\n");

    return IANS_NOT_SUPPORTED_YET;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract: Deletes the vadapter's net_device from the vlan_group.        **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS iNCGDevVlanUnregisterVlanGroup(device_t *baseDev)
{
#ifdef NETIF_F_HW_VLAN_TX  
    struct net_device *dev = GET_OS_DEV(baseDev);

    ASSERT(dev);

    if (dev->features & NETIF_F_HW_VLAN_RX) {
        dev->vlan_rx_register(dev, NULL);
    }

    IANS_PRINT_DEBUG("Unregistered vlan group from adapter %s\n", dev->name);

    return IANS_OK;

#endif //NETIF_F_HW_VLAN_TX

    IANS_PRINT_DEBUG("iNCGDevVlanUnregisterVlanGroup: vlan hwaccel not supported!\n");

    return IANS_NOT_SUPPORTED_YET;
}


/*------------------------------- Link Status ------------------------------*/

/*------------------------------ Netif support -----------------------------*/

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS baseGetNetifLinkState(device_t *ansDev, IANS_BD_IOC_PARAM_STATUS *stat)
{
    struct net_device *dev = (struct net_device *) GET_OS_DEV(ansDev);

    if (dev == NULL) {
        IANS_PRINT_ERROR("dev == NULL\n");
        return IANS_IOCTL_FAILED;
    }

    if (netif_carrier_ok(dev)) {
        stat->Status.LinkStatus = IANS_STATUS_LINK_OK;
    }
    else {
        stat->Status.LinkStatus = IANS_STATUS_LINK_FAIL;
    }

    return IANS_OK;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters: int on: 1 if link is up and 0 otherwise                     **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
VOID baseSetNetifLinkState(device_t *ansDev, int on)
{
    struct net_device *dev = (struct net_device *) GET_OS_DEV(ansDev);

    if (dev == NULL) {
        IANS_PRINT_ERROR("dev == NULL\n");
        return;
    }

    if (on) {
        netif_carrier_on(dev);
    }
    else {
        netif_carrier_off(dev);
    }
}

/*------------------------------- MII support ------------------------------*/

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS baseMIIGetPhyAddress(device_t *ansDev, UINT16 *phy_addr, BOOLEAN UseOldMII)
{
    struct net_device *dev = (struct net_device *) GET_OS_DEV(ansDev);
    struct ifreq ifr;
    UINT16 *buf;
    IANS_STATUS res = IANS_OK;

    if (dev == NULL) {
        IANS_PRINT_ERROR("dev == NULL\n");
        return IANS_IOCTL_FAILED;
    }

    if(dev->do_ioctl == NULL) {
        IANS_PRINT_ERROR("%s: dev->do_ioctl == NULL\n", dev->name);
        return IANS_IOCTL_FAILED;
    }

    memset(&ifr, 0, sizeof(struct ifreq));
    strcpy(ifr.ifr_ifrn.ifrn_name, dev->name);
    buf = (UINT16*)&(ifr.ifr_data);

    if((dev->do_ioctl(dev, &ifr, SIOCGMIIPHY)) != 0) {
        //IANS_PRINT_DEBUG("%s: did not recognize SIOCGMIIPHY\n", dev->name);
        res = IANS_IOCTL_FAILED;

        if (UseOldMII && (SIOCGMIIPHY != SIOCDEVPRIVATE)) {
            res = IANS_OK;
            // quick workaround to bypass the fact that some drivers do not implement the new MII ioctls.
            if((dev->do_ioctl(dev, &ifr, SIOCDEVPRIVATE)) != 0) {
                // the driver has some other bug - can't find any way to read MII.
                //IANS_PRINT_DEBUG("%s: did not recognize SIOCGMIIPHY or SIOCDEVPRIVATE\n", dev->name);
                res = IANS_IOCTL_FAILED;
            }
        }
    }

    *phy_addr = buf[0];
    return res;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS baseMIIReadRegister(device_t *ansDev, UINT16 phy_addr, UINT16 reg_addr, UINT16 *reg_data, BOOLEAN UseOldMII)
{
    struct net_device *dev = (struct net_device *) GET_OS_DEV(ansDev);
    struct ifreq ifr;
    UINT16 *buf;
    IANS_STATUS res = IANS_OK;

    if (dev == NULL) {
        IANS_PRINT_ERROR("dev == NULL\n");
        return IANS_IOCTL_FAILED;
    }

    if(dev->do_ioctl == NULL) {
        IANS_PRINT_ERROR("%s: dev->do_ioctl == NULL\n", dev->name);
        return IANS_IOCTL_FAILED;
    }

    memset(&ifr, 0, sizeof(struct ifreq));
    strcpy(ifr.ifr_ifrn.ifrn_name, dev->name);
    buf = (UINT16*)&(ifr.ifr_data);

    buf[0] = phy_addr;
    buf[1] = reg_addr;
    if((dev->do_ioctl(dev, &ifr, SIOCGMIIREG)) != 0) {
        //IANS_PRINT_DEBUG("%s: did not recognize SIOCGMIIREG\n", dev->name);
        res = IANS_IOCTL_FAILED;

        if (UseOldMII && (SIOCGMIIREG != (SIOCDEVPRIVATE+1))) {
            res = IANS_OK;
            // quick workaround to bypass the fact that some drivers do not implement the new MII ioctls.
            if((dev->do_ioctl(dev, &ifr, SIOCDEVPRIVATE+1)) != 0) {
                //IANS_PRINT_DEBUG("%s: did not recognize SIOCGMIIREG or SIOCDEVPRIVATE+1\n", dev->name);
                res = IANS_IOCTL_FAILED;
            }
        }
    }

    *reg_data = buf[3];
    return res;
}

/*----------------------------- EthTool support ----------------------------*/

#ifdef SIOCETHTOOL
/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
#ifdef ETHTOOL_GLINK
static inline void _convertEthToolToLinkState(struct ethtool_value *eval, IANS_BD_IOC_PARAM_STATUS *stat)
{
    stat->Status.LinkStatus = IANS_STATUS_LINK_NOT_SUPPORTED;

    if (eval->data) {
        stat->Status.LinkStatus = IANS_STATUS_LINK_OK;
    }
    else {
        stat->Status.LinkStatus = IANS_STATUS_LINK_FAIL;
    }
}
#endif //ETHTOOL_GLINK

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
#ifdef ETHTOOL_GSET
static inline void _convertEthToolToStats(struct ethtool_cmd *ecmd, IANS_BD_IOC_PARAM_STATUS *stat)
{
    stat->Status.Duplex = IANS_STATUS_DUPLEX_NOT_SUPPORTED;
    stat->Status.LinkSpeed = IANS_STATUS_LINK_SPEED_NOT_SUPPORTED;

    switch(ecmd->duplex) {
        case DUPLEX_FULL:
            stat->Status.Duplex = IANS_STATUS_DUPLEX_FULL;
            break;
        case DUPLEX_HALF:
            stat->Status.Duplex = IANS_STATUS_DUPLEX_HALF;
            break;
        default:
            break;
    }

    switch(ecmd->speed) {
        case SPEED_10:
            stat->Status.LinkSpeed = IANS_STATUS_LINK_SPEED_10MBPS;
            break;
        case SPEED_100:
            stat->Status.LinkSpeed = IANS_STATUS_LINK_SPEED_100MBPS;
            break;
        case SPEED_1000:
            stat->Status.LinkSpeed = IANS_STATUS_LINK_SPEED_1000MBPS;
            break;
        case SPEED_10000:
            stat->Status.LinkSpeed = IANS_STATUS_LINK_SPEED_10000MBPS;
            break;          
        default:
            break;
    }
}
#endif //ETHTOOL_GSET

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
#ifdef ETHTOOL_GSET
static inline void _convertEthToolToSpeeds(struct ethtool_cmd *ecmd, UINT32 *speeds)
{
    *speeds = IANS_STATUS_LINK_SPEED_NOT_SUPPORTED;

    if (ecmd->supported & (SUPPORTED_10baseT_Half | SUPPORTED_10baseT_Full)) {
        *speeds |= IANS_STATUS_LINK_SPEED_10MBPS;
    }
    if (ecmd->supported & (SUPPORTED_100baseT_Half | SUPPORTED_100baseT_Full)) {
        *speeds |= IANS_STATUS_LINK_SPEED_100MBPS;
    }
    if (ecmd->supported & (SUPPORTED_1000baseT_Half | SUPPORTED_1000baseT_Full)) {
        *speeds |= IANS_STATUS_LINK_SPEED_1000MBPS;
    }
    if (ecmd->supported & SUPPORTED_10000baseT_Full) {
        *speeds |= IANS_STATUS_LINK_SPEED_10000MBPS;
    }
}
#endif //ETHTOOL_GSET

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS baseGetEthToolLinkState(device_t *ansDev, IANS_BD_IOC_PARAM_STATUS *stat)
{
    IANS_STATUS res = IANS_OK;
#ifdef ETHTOOL_GLINK
    struct net_device *dev = NULL;
    struct ethtool_value eval;
    struct ifreq ifr;
    mm_segment_t fs;
    int ret_val = 0;
    int use_ethtool_ops = 0;

    if (ansDev == NULL) {
        IANS_PRINT_ERROR("ansDev == NULL\n");
        return IANS_ERROR;
    }

    if (stat == NULL) {
        IANS_PRINT_ERROR("stat == NULL\n");
        return IANS_ERROR;
    }

    dev = (struct net_device *) GET_OS_DEV(ansDev);

    if (dev == NULL) {
        IANS_PRINT_ERROR("dev == NULL\n");
        return IANS_ERROR;
    }

    memset(&eval, 0, sizeof(struct ethtool_value));
    eval.cmd = ETHTOOL_GLINK;

#ifdef SET_ETHTOOL_OPS
    if (dev->ethtool_ops && dev->ethtool_ops->get_link) {
        use_ethtool_ops = 1;
    }
#endif

    if (use_ethtool_ops) {
#ifdef SET_ETHTOOL_OPS
        eval.data = dev->ethtool_ops->get_link(dev);
#endif
    }
    else {
        if(dev->do_ioctl == NULL) {
            IANS_PRINT_ERROR("%s: dev->do_ioctl == NULL\n", dev->name);
            return IANS_ERROR;
        }

        memset(&ifr, 0, sizeof(struct ifreq));
        strcpy(ifr.ifr_ifrn.ifrn_name, dev->name);
        ifr.ifr_data = (char*)&eval;

        fs = get_fs();
        set_fs(get_ds());
        ret_val = dev->do_ioctl(dev, &ifr, SIOCETHTOOL);
        if(ret_val != 0) {
            if (ret_val == -EOPNOTSUPP) {
                IANS_PRINT_ERROR("%s: ioctl not recognized\n", dev->name);
                res = IANS_NOT_SUPPORTED_YET;
            }
            else {
                IANS_PRINT_ERROR("%s: ioctl failed\n", dev->name);
                res = IANS_IOCTL_FAILED;
            }
        }
        set_fs(fs);
    } // end of else use_ethtool_ops

    stat->Status.LinkStatus = IANS_STATUS_LINK_NOT_SUPPORTED;
    if (res == IANS_OK) {
        _convertEthToolToLinkState(&eval, stat);
    }
    //IANS_PRINT_DEBUG("%s: link status = %d\n", dev->name, (int)stat->Status.LinkStatus);

#else //ETHTOOL_GLINK
    stat->Status.LinkStatus = IANS_STATUS_LINK_NOT_SUPPORTED;
    res = IANS_NOT_SUPPORTED_YET;
#endif //ETHTOOL_GLINK

    return res;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS baseGetEthToolLinkStatus(device_t *ansDev, IANS_BD_IOC_PARAM_STATUS *stat)
{
    IANS_STATUS res = IANS_OK;
#ifdef ETHTOOL_GSET
    struct net_device *dev = NULL;
    struct ethtool_cmd ecmd;
    struct ifreq ifr;
    mm_segment_t fs;
    int ret_val = 0;
    int use_ethtool_ops = 0;

    if (ansDev == NULL) {
        IANS_PRINT_ERROR("ansDev == NULL\n");
        return IANS_ERROR;
    }

    if (stat == NULL) {
        IANS_PRINT_ERROR("stat == NULL\n");
        return IANS_ERROR;
    }

    dev = (struct net_device *) GET_OS_DEV(ansDev);

    if (dev == NULL) {
        IANS_PRINT_ERROR("dev == NULL\n");
        return IANS_ERROR;
    }

    memset(&ecmd, 0, sizeof(struct ethtool_cmd));
    ecmd.cmd = ETHTOOL_GSET;

#ifdef SET_ETHTOOL_OPS
    if (dev->ethtool_ops && dev->ethtool_ops->get_settings) {
        use_ethtool_ops = 1;
    }
#endif

    if (use_ethtool_ops) {
#ifdef SET_ETHTOOL_OPS
        ret_val = dev->ethtool_ops->get_settings(dev, &ecmd);
#endif
    }
    else {
        if (dev->do_ioctl == NULL) {
            IANS_PRINT_ERROR("%s: dev->do_ioctl == NULL\n", dev->name);
            return IANS_ERROR;
        }

        memset(&ifr, 0, sizeof(struct ifreq));
        strcpy(ifr.ifr_ifrn.ifrn_name, dev->name);
        ifr.ifr_data = (char*)&ecmd;

        fs = get_fs();
        set_fs(get_ds());
        ret_val = dev->do_ioctl(dev, &ifr, SIOCETHTOOL);
        set_fs(fs);
    } //end of else use_ethtool_ops

    if (ret_val != 0) {
        if (ret_val == -EOPNOTSUPP) {
            IANS_PRINT_ERROR("%s: ioctl not recognized\n", dev->name);
            res = IANS_NOT_SUPPORTED_YET;
        }
        else {
            IANS_PRINT_ERROR("%s: ioctl failed\n", dev->name);
            res = IANS_IOCTL_FAILED;
        }
    }

    stat->Status.Duplex = IANS_STATUS_DUPLEX_NOT_SUPPORTED;
    stat->Status.LinkSpeed = IANS_STATUS_LINK_SPEED_NOT_SUPPORTED;
    if (res == IANS_OK) {
        _convertEthToolToStats(&ecmd, stat);
    }
    //IANS_PRINT_DEBUG("%s: speed = %d\n", dev->name, (int)stat->Status.LinkSpeed);

#else //ETHTOOL_GSET
    stat->Status.Duplex = IANS_STATUS_DUPLEX_NOT_SUPPORTED;
    stat->Status.LinkSpeed = IANS_STATUS_LINK_SPEED_NOT_SUPPORTED;
    res = IANS_NOT_SUPPORTED_YET;
#endif //ETHTOOL_GSET

    return res;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS baseGetEthToolSupportedSpeeds(device_t *ansDev, UINT32 *speeds)
{
    IANS_STATUS res = IANS_OK;
#ifdef ETHTOOL_GSET
    struct net_device *dev = NULL;
    struct ethtool_cmd ecmd;
    struct ifreq ifr;
    mm_segment_t fs;
    int ret_val = 0;
    int use_ethtool_ops = 0;

    if (ansDev == NULL) {
        IANS_PRINT_ERROR("ansDev == NULL\n");
        return IANS_ERROR;
    }

    if (speeds == NULL) {
        IANS_PRINT_ERROR("stat == NULL\n");
        return IANS_ERROR;
    }

    dev = (struct net_device *) GET_OS_DEV(ansDev);

    if (dev == NULL) {
        IANS_PRINT_ERROR("dev == NULL\n");
        return IANS_ERROR;
    }

    memset(&ecmd, 0, sizeof(struct ethtool_cmd));
    ecmd.cmd = ETHTOOL_GSET;

#ifdef SET_ETHTOOL_OPS
    if (dev->ethtool_ops && dev->ethtool_ops->get_settings) {
        use_ethtool_ops = 1;
    }
#endif

    if (use_ethtool_ops) {
#ifdef SET_ETHTOOL_OPS
        ret_val = dev->ethtool_ops->get_settings(dev, &ecmd);
#endif
    }
    else {
        if(dev->do_ioctl == NULL) {
            IANS_PRINT_ERROR("%s: dev->do_ioctl == NULL\n", dev->name);
            return IANS_ERROR;
        }

        memset(&ifr, 0, sizeof(struct ifreq));
        strcpy(ifr.ifr_ifrn.ifrn_name, dev->name);
        ifr.ifr_data = (char*)&ecmd;

        fs = get_fs();
        set_fs(get_ds());
        ret_val = dev->do_ioctl(dev, &ifr, SIOCETHTOOL);
        set_fs(fs);
    } //else of use_ethtool_ops

    if(ret_val != 0) {
        if (ret_val == -EOPNOTSUPP) {
            IANS_PRINT_ERROR("%s: ioctl not recognized\n", dev->name);
            res = IANS_NOT_SUPPORTED_YET;
        }
        else {
            IANS_PRINT_ERROR("%s: ioctl failed\n", dev->name);
            res = IANS_IOCTL_FAILED;
        }
    }

    *speeds = IANS_STATUS_LINK_SPEED_NOT_SUPPORTED;
    if (res == IANS_OK) {
        _convertEthToolToSpeeds(&ecmd, speeds);
    }
    //IANS_PRINT_DEBUG("%s: speeds = %08X\n", dev->name, *speeds);

#else //ETHTOOL_GSET
    *speeds = IANS_STATUS_LINK_SPEED_NOT_SUPPORTED;
    res = IANS_NOT_SUPPORTED_YET;
#endif //ETHTOOL_GSET

    return res;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
IANS_STATUS baseEthToolReadEeprom(device_t *ansDev, char *buf, int len, int offset)
{
    IANS_STATUS res = IANS_OK;
#ifdef ETHTOOL_GEEPROM
    struct net_device *dev = (struct net_device *) GET_OS_DEV(ansDev);
    struct ethtool_eeprom *ecmd;
    struct ifreq ifr;
    mm_segment_t fs;
    int ret_val = 0;
    int use_ethtool_ops = 0;

    if (dev == NULL) {
        IANS_PRINT_ERROR("dev == NULL\n");
        return IANS_ERROR;
    }

    if (buf == NULL) {
        IANS_PRINT_ERROR("buf == NULL\n");
        return IANS_ERROR;
    }

    /* Check for wrap and zero */
    if (offset + len <= offset) {
        IANS_PRINT_ERROR("offset + len <= offset\n");
        return IANS_ERROR;
    }

#ifdef SET_ETHTOOL_OPS
    if (dev->ethtool_ops && dev->ethtool_ops->get_eeprom) {
        use_ethtool_ops = 1;
    }
#endif

    if(!use_ethtool_ops && (dev->do_ioctl == NULL)) {
        IANS_PRINT_ERROR("%s: dev->do_ioctl == NULL\n", dev->name);
        return IANS_ERROR;
    }
    
    iNCGGPSizedMemAlloc((void **)(&ecmd), sizeof(struct ethtool_eeprom) + len);
    if(ecmd == NULL) {
        IANS_PRINT_ERROR("Failed to allocate ecmd buffer.\n");
        return IANS_MEM_ERROR;
    }

    memset(ecmd, 0, sizeof(struct ethtool_eeprom) + len);
    ecmd->cmd = ETHTOOL_GEEPROM;
    ecmd->len = len;
    ecmd->offset = offset;

    if(use_ethtool_ops) {
#ifdef SET_ETHTOOL_OPS
         /* Check for exceeding total eeprom len      
        if ((offset + len) > dev->ethtool_ops->get_eeprom_len(dev)) {
            res = IANS_ERROR;
            IANS_PRINT_ERROR("length to read is longer than eeprom length\n");
            goto out;
        }
        */

        ret_val = dev->ethtool_ops->get_eeprom(dev, ecmd, ecmd->data);
#endif
    }
    else {
        memset(&ifr, 0, sizeof(struct ifreq));
        strcpy(ifr.ifr_ifrn.ifrn_name, dev->name);
        ifr.ifr_data = (char*)ecmd;

        fs = get_fs();
        set_fs(get_ds());
        ret_val = dev->do_ioctl(dev, &ifr, SIOCETHTOOL);
        set_fs(fs);
    } //else of if(use_ethtool_ops)

    if(ret_val != 0) {
        if (ret_val == -EOPNOTSUPP) {
            IANS_PRINT_ERROR("%s: ioctl not recognized\n", dev->name);
            res = IANS_NOT_SUPPORTED_YET;
        }
        else {
            IANS_PRINT_ERROR("%s: ioctl failed\n", dev->name);
            res = IANS_IOCTL_FAILED;
        }
    }

    memset(buf, 0, len);
    if (res == IANS_OK) {
        memcpy(buf, ecmd->data, len);
    }

//out:

    iNCGGPMemFree((void **)&ecmd);

#else //ETHTOOL_GEEPROM
    memset(buf, 0, len);
    res = IANS_NOT_SUPPORTED_YET;
#endif //ETHTOOL_GEEPROM

    return res;
}

/*****************************************************************************
**                                                                          **
**  Function Name:                                                          **
**                                                                          **
**  Abstract:                                                               **
**                                                                          **
**  Parameters:                                                             **
**                                                                          **
**  Assumptions:                                                            **
**                                                                          **
**  Return Value:                                                           **
**                                                                          **
**  Revision History:                                                       **
**                                                                          **
*****************************************************************************/
//bus_info parameter must be of length ETHTOOL_BUSINFO_LEN (=32)
IANS_STATUS baseGetEthtoolBusInfo(device_t *ansDev, char bus_info[]) {
    IANS_STATUS res = IANS_OK;
#ifdef ETHTOOL_GDRVINFO
    struct net_device *dev = NULL;
    struct ifreq ifr;
    struct ethtool_drvinfo drvinfo;
    mm_segment_t fs;
    int ret_val = 0;
    int use_ethtool_ops = 0;

    if (ansDev == NULL) {
        IANS_PRINT_ERROR("ansDev == NULL\n");
        return IANS_ERROR;
    }

    dev = (struct net_device *) GET_OS_DEV(ansDev);

    if (dev == NULL) {
        IANS_PRINT_ERROR("dev == NULL\n");
        return IANS_ERROR;
    }

    memset(&drvinfo, 0, sizeof(struct ethtool_drvinfo));
    drvinfo.cmd = ETHTOOL_GDRVINFO;

#ifdef SET_ETHTOOL_OPS
    if (dev->ethtool_ops && dev->ethtool_ops->get_drvinfo) {
        use_ethtool_ops = 1;
    }
#endif

    if (use_ethtool_ops) {
#ifdef SET_ETHTOOL_OPS
        dev->ethtool_ops->get_drvinfo(dev, &drvinfo);
#endif
    }
    else {
        if (dev->do_ioctl == NULL) {
            IANS_PRINT_ERROR("%s: dev->do_ioctl == NULL\n", dev->name);
            return IANS_ERROR;
        }

        memset(&ifr, 0, sizeof(struct ifreq));
        strcpy(ifr.ifr_ifrn.ifrn_name, dev->name);
        ifr.ifr_data = (char*)&drvinfo;
 
        fs = get_fs();
        set_fs(get_ds());
        ret_val = dev->do_ioctl(dev, &ifr, SIOCETHTOOL);
        set_fs(fs);

        if(ret_val != 0) {
            if (ret_val == -EOPNOTSUPP) {
                IANS_PRINT_ERROR("%s: ioctl ETHTOOL_GDRVINFO not recognized\n", dev->name);
                res = IANS_NOT_SUPPORTED_YET;
            }
            else {
                IANS_PRINT_ERROR("%s: ioctl failed\n", dev->name);
                res = IANS_IOCTL_FAILED;
            }
        }
    }

    if (res == IANS_OK) {
        memcpy(bus_info, drvinfo.bus_info, ETHTOOL_BUSINFO_LEN);
        //printk("ethtool bus_info = %s\n", bus_info);
    }

#else
      res = IANS_NOT_SUPPORTED_YET;
      IANS_PRINT_ERROR("ioctl ETHTOOL_GDRVINFO not recognized\n");
#endif

      return res;
}

#endif //SIOCETHTOOL

