#ifndef _GDG_DRM_H_
#define _GDG_DRM_H_

/* Please note that modifications to all structs defined here are
 * subject to backwards-compatibility constraints.
 */

#include "drm.h"

/* Each region is a minimum of 16k, and there are at most 255 of them.
 */
#define GDG_NR_TEX_REGIONS 255	/* table size 2k - maximum due to use
				 * of chars for next/prev indices */
#define GDG_LOG_MIN_TEX_REGION_SIZE 14


typedef struct _drm_gdg_init {
	enum {
		GDG_INIT_DMA = 0x01,
		GDG_CLEANUP_DMA = 0x02
	} func;
	unsigned int mmio_offset;
	int sarea_priv_offset;
	unsigned int ring_start;
	unsigned int ring_end;
	unsigned int ring_size;
	unsigned int front_offset;
	unsigned int back_offset;
	unsigned int depth_offset;
	unsigned int w;
	unsigned int h;
	unsigned int pitch;
	unsigned int pitch_bits;
	unsigned int back_pitch;
	unsigned int depth_pitch;
	unsigned int cpp;
        unsigned int chipset;
} drm_gdg_init_t;


typedef struct _drm_gdg_sarea {
	drm_tex_region_t texList[GDG_NR_TEX_REGIONS+1];
        int last_upload;	/* last time texture was uploaded */
        int last_enqueue;	/* last time a buffer was enqueued */
	int last_dispatch;	/* age of the most recently dispatched buffer */
	int ctxOwner;		/* last context to upload state */
	int texAge;
        int pf_enabled;		/* is pageflipping allowed? */
        int pf_active;               
        int pf_current_page;	/* which buffer is being displayed? */
        int perf_boxes;	        /* performance boxes to be displayed */   
} drm_gdg_sarea_t;

/* Flags for perf_boxes
 */
#define GDG_BOX_RING_EMPTY    0x1 
#define GDG_BOX_FLIP          0x2 
#define GDG_BOX_WAIT          0x4 
#define GDG_BOX_TEXTURE_LOAD  0x8 
#define GDG_BOX_LOST_CONTEXT  0x10 


/* GDG specific ioctls
 * The device specific ioctl range is 0x40 to 0x79.
 */
#define DRM_IOCTL_GDG_INIT		DRM_IOW( 0x40, drm_gdg_init_t)
#define DRM_IOCTL_GDG_FLUSH		DRM_IO ( 0x41)
#define DRM_IOCTL_GDG_FLIP		DRM_IO ( 0x42)
#define DRM_IOCTL_GDG_BATCHBUFFER	DRM_IOW( 0x43, drm_gdg_batchbuffer_t)
#define DRM_IOCTL_GDG_IRQ_EMIT          DRM_IOWR(0x44, drm_gdg_irq_emit_t)
#define DRM_IOCTL_GDG_IRQ_WAIT          DRM_IOW( 0x45, drm_gdg_irq_wait_t)
#define DRM_IOCTL_GDG_GETPARAM          DRM_IOWR(0x46, drm_gdg_getparam_t)
#define DRM_IOCTL_GDG_SETPARAM          DRM_IOW( 0x47, drm_gdg_setparam_t)
#define DRM_IOCTL_GDG_ALLOC             DRM_IOWR(0x48, drm_gdg_mem_alloc_t)
#define DRM_IOCTL_GDG_FREE              DRM_IOW( 0x49, drm_gdg_mem_free_t)
#define DRM_IOCTL_GDG_INIT_HEAP         DRM_IOW( 0x4a, drm_gdg_mem_init_heap_t)


/* 
 */
typedef struct _drm_gdg_batchbuffer {
   	int start;		/* agp offset */
	int used;		/* nr bytes in use */
	int DR1;		/* hw flags for GFX_OP_DRAWRECT_INFO */
        int DR4;		/* window origin for GFX_OP_DRAWRECT_INFO*/
	int num_cliprects;	/* mulitpass with multiple cliprects? */
        drm_clip_rect_t *cliprects; /* pointer to userspace cliprects */
} drm_gdg_batchbuffer_t;

/* Userspace can request & wait on irq's:
 */
typedef struct drm_gdg_irq_emit {
	int *irq_seq;
} drm_gdg_irq_emit_t;

typedef struct drm_gdg_irq_wait {
	int irq_seq;
} drm_gdg_irq_wait_t;


/* Ioctl to query kernel params:
 */
#define GDG_PARAM_IRQ_ACTIVE            1

typedef struct drm_gdg_getparam {
	int param;
	int *value;
} drm_gdg_getparam_t;


/* Ioctl to set kernel params:
 */
#define GDG_SETPARAM_USE_MI_BATCHBUFFER_START            1
#define GDG_SETPARAM_TEX_LRU_LOG_GRANULARITY             2

typedef struct drm_gdg_setparam {
	int param;
	int value;
} drm_gdg_setparam_t;

/* A memory manager for regions of shared memory:
 */
#define GDG_MEM_REGION_AGP 1

typedef struct drm_gdg_mem_alloc {
	int region;
	int alignment;
	int size;
	int *region_offset;	/* offset from start of fb or agp */
} drm_gdg_mem_alloc_t;

typedef struct drm_gdg_mem_free {
	int region;
	int region_offset;
} drm_gdg_mem_free_t;

typedef struct drm_gdg_mem_init_heap {
	int region;
	int size;
	int start;	
} drm_gdg_mem_init_heap_t;


#endif /* _GDG_DRM_H_ */
