#pragma once

#include "winsock2.h"

#include <process.h>
#include "stdio.h"
namespace CleanSock
{
	class CleanSock
	{
	public:
		static void Init();
	};

	typedef unsigned int SOCKET;

	class SockConnection
	{
		SOCKET Socket;
		unsigned int threadID;
		unsigned short Port;
		char* IP;//copyme
		bool Alive;
		void Start();
	public:
		int main();
		SockConnection(){Socket=0;Alive=false;}
		void Connect(char*_IP,int _Port);
		void Connect(SOCKET _Socket)
		{
			Socket=_Socket;
			Alive=true;
			IP=0;
			Port=0;
			Start();
		}
		virtual void OnConnectionMade(){}
		virtual void OnReceive(char* _Data,int _Length){printf("Received:%s",_Data);}
		virtual void OnConnectionLost(){}
		void Write(char*_Data);
		void Write(char*_Data,int _Length);
	};

	class SockServer
	{
		SOCKET Socket;
		unsigned int threadID;
		unsigned short Port;
	public:
		int main();
		void Start(unsigned short _Port);
		virtual SockConnection*GetSock(){return new SockConnection();}
	};


	class SockConnectionUDP
	{
		SOCKET SendSocket;
		SOCKET ReceiveSocket;
		unsigned int threadID;
		unsigned short Port;
		char*IP;

		sockaddr_in RecvAddr;
		sockaddr_in SendAddr;
	public:
		int main();
		void Start(char*_IP,unsigned short _Port);
		virtual void OnReceive(char* _Data, int _Length)
		{

		}
		void Write(char* _Data,int _Length)
		{
			int result = sendto(SendSocket,_Data,_Length,0,(SOCKADDR*)&SendAddr,sizeof(SendAddr));
			if(result!=0)
			{
				printf("Failed to Send UDP datagram");
			}
		}
	};
}