#pragma once
#define LAN_RENDER 1
#define LAN_BUFRESIZE 2
#define LAN_BUFUPDATE 3

template<typename T>class LANBuffer:public RemoteBuffer<T>
{
	SockConnection*Connection;
	int size;
public:
	unsigned char ID;
	LANBuffer():RemoteBuffer<T>(),size(0){}

	int GetSize(){return size;}

	void SetConnection(SockConnection*_Connection){Connection=_Connection;}

	void RemoteUpdate(int _From,int _Count)
	{
		T*src = &localbuffer->GetPtr()[_From];
		int chunksize=(8192-10)/sizeof(T);
		for(int i=0;i<_Count;i+=chunksize)
		{
			int first=i+_From;
			int csize = MIN(_Count-i,chunksize);
			char data[8192];
			char*ptr=data;
			*ptr=LAN_BUFUPDATE;ptr++;
			*ptr=ID;ptr++;
			memcpy(ptr,&first,sizeof(int));ptr+=sizeof(int);
			memcpy(ptr,&csize,sizeof(int));ptr+=sizeof(int);
			memcpy(ptr,&src[i],csize*sizeof(T));
			Connection->Write(data,2+4+4+csize*sizeof(T));
		}
	}

	void Synchronize()
	{
		if(localbuffer==0)return;
		//resize
		int localsize = localbuffer->GetSize();
		if(size!=localsize)
		{
			char data[8192];
			char*ptr=data;
			*ptr=LAN_BUFRESIZE;ptr++;
			*ptr=ID;ptr++;
			memcpy(ptr,&localsize,sizeof(int));
			Connection->Write(data,2+4);

			size=localsize;
			lastupdate=0;//force out of sync
		}
		int localfirst = localbuffer->GetFirstUpdate();
		int locallast = localbuffer->GetLastUpdate();
		if(lastupdate<localfirst)
		{
			//out of sync!
			RemoteUpdate(0,localsize);
			lastupdate=locallast;//get in sync
			///Log::Message("buffer reverted");
		}else{
			if(lastupdate<locallast)
			{
				for(int i=lastupdate;i<locallast;i++)
				{
					//perform change
					RemoteBufferUpdate update = localbuffer->GetUpdate(i);
					RemoteUpdate(update.from,update.count);
				}
				//Log::Message("buffer synchronized");
				lastupdate=locallast;
			}
		}
	}

	T*GetPtr(){return ptr;}
};

class LANTracer;
class LANTracerConnection : public SockConnection
{
public:
	LANTracer*tracer;
	LANTracerConnection(LANTracer*_Tracer):tracer(_Tracer){}
	void OnConnectionMade();
	void OnReceive(char* _Data,int _Length);
	void OnConnectionLost();
};
class LANTracerThread;
class LANTracer : public Tracer, public SockServer
{
public:
	Timer timer;
	LANTracerConnection*connection;

	LANBuffer<int>MaterialDiffuse;
	LANBuffer<TracerMaterial>Materials;
	LANBuffer<int>RenderTarget;
	LANBuffer<TracerBVHNode>BVHNodes;
	LANBuffer<TracerTriangle>Triangles;

	LANTracerThread*thread;

	SockConnection*LANTracer::GetSock();

	Log::Logger lanlog;
	LANTracer(int _ListenerPort);
	void RenderBegin();
	void RenderEnd();
};
class LANTracerThread : public Thread
{
public:
	LANTracerThread():Thread(){}
	void run();
	HANDLE renderstart;
	HANDLE renderdone;
	LANTracer*tracer;
};
