#pragma once

#define CPUPACKETSIZE 256

class CPUTracerThread;
class CPUTracerWorker;
class RayPacket;

class CPUTracer : public Tracer
{
public:
	// ctor / dtor
	CPUTracer();
	~CPUTracer();
	void RenderBegin();
	void RenderEnd();
	volatile long waiting;
	// data members
	Timer timer;
	CPUTracerThread* thread;
	int WorkerCount;
	CPUTracerWorker* Workers;
};

class CPUTracerThread : public Thread
{
public:
	CPUTracerThread();
	void run();
	HANDLE renderstart;
	HANDLE renderdone;
	CPUTracer* tracer;
};

struct PixelData
{
	int pidx;
	int samplestaken;

};

class RayPacket
{
public:

	struct
	{
		union { float*x; __m128*x4; };
		union { float*y; __m128*y4; };
		union { float*z; __m128*z4; };
	} o, d;
	union { TracerTriangle**tri; __m128i*tri4; };
	union { float*u; __m128*u4; };
	union { float*v; __m128*v4; };
	union { float*dist; __m128*dist4; };
	union { int*depth; __m128i*depth4; };

	PixelData**pixeldata;

	int maxrays;//maximum amount of rays
	int rays;//amount of rays used

	void Malloc()
	{
		if(maxrays!=0)
		{
			o.x	 = MALLOC(maxrays, float);
			o.y	 = MALLOC(maxrays, float);
			o.z	 = MALLOC(maxrays, float);

			d.x	 = MALLOC(maxrays, float);
			d.y	 = MALLOC(maxrays, float);
			d.z	 = MALLOC(maxrays, float);

			tri	 = MALLOC(maxrays, TracerTriangle*);
			u	 = MALLOC(maxrays, float);
			v	 = MALLOC(maxrays, float);
			dist = MALLOC(maxrays, float);

			pixeldata = MALLOC(maxrays, PixelData*);
		}
	}

	void Free()
	{
		if(maxrays != 0)
		{
			FREE(o.x);
			FREE(o.y);
			FREE(o.z);

			FREE(d.x);
			FREE(d.y);
			FREE(d.z);

			FREE(tri);
			FREE(u);
			FREE(v);
			FREE(dist);

			FREE(pixeldata);
		}
	}

	void Resize(const int _MaxRays)
	{
		Free();
		maxrays = _MaxRays;
		Malloc();
	}

	RayPacket(const int _MaxRays)
	{
		maxrays = _MaxRays;
		Malloc();
	}

	~RayPacket()
	{
		Free();
	}
};

class CPUTracerWorker : public Thread
{
public:
	// ctor / dtor
	CPUTracerWorker();
	~CPUTracerWorker();

	void run();
	void DoJob(const int _JobIdx);
	void TraverseBVHPrimary( RayPacket* _Packet );
	// data members
	HANDLE renderstart;
	HANDLE renderdone;
	CPUTracer* tracer;
	RayPacket RP, SP;
	PixelData pixeldata[CPUPACKETSIZE];
};