#include "windows.h"
#include "brigade.h"

#include "btBulletDynamicsCommon.h"
using namespace B2;
// located in framework main.cpp
extern PathTracer* pathtracer;
extern Scene* scene;
extern float dtime;
bool DefaultKeyboardInput();

// Application variables

btDynamicsWorld* btdynamicsWorld;
btCollisionDispatcher* btdispatcher;
btDefaultCollisionConfiguration* btcollisionConfiguration;
btDbvtBroadphase* btbroadphase;
btConstraintSolver*	btsolver;

float time = 0;
float steering = 0;

Node* environment;

btRigidBody* BodyForMesh(Object*obj, float mass)
{
	btTriangleMesh * myTriMesh = new btTriangleMesh();
	myTriMesh->preallocateVertices(obj->GetTriangleCount() * 3);
	for(int i=0;i<obj->GetTriangleCount();i++)
	{
		Triangle*tri = obj->GetTriangle(i);
		TriangleC tric(*tri,obj->GetNode()->GetTransform());
		// TriangleC tric(tri);
		myTriMesh->addTriangle(
			*(btVector3*)&tric.V[0].pos,
			*(btVector3*)&tric.V[1].pos,
			*(btVector3*)&tric.V[2].pos);
	}
	btVector3 localInertia(0,0,0);
	btCollisionShape* myShape = new btBvhTriangleMeshShape(myTriMesh, true);
	if(mass != 0){
		btBoxShape inertiashape(btVector3(4.5,0.4f,2.0f));// make me a convex hull
		inertiashape.calculateLocalInertia(mass, localInertia);
	}
	btDefaultMotionState* myMotionState = new btDefaultMotionState();
	btRigidBody* body = new btRigidBody(mass, myMotionState, myShape, localInertia);
	btdynamicsWorld->addCollisionObject(body);
	return body;
}

class Car
{
public:
	// bullet objects
	btRigidBody* btchassis;
	btRaycastVehicle::btVehicleTuning bttuning;
	btRaycastVehicle * btvehicle;
	btVehicleRaycaster* btvehicleraycaster;
	struct Wheel
	{
		Node*node;				// scenegraph entry for the wheels
		float4x4 bindingpose;	// 'zero' position for the wheels
	} wheels[4];				// wheels
	Node*node;
	float wheelangle[4];
	Car(Node*_Node, float _ChassisMass) : node(_Node)
	{
#if 0
		Node*bodynode = node->GetNode("hull"); bodynode->SetVisible(false);
		btchassis = RigidBodyForMesh((ObjectDynamic*)bodynode->GetObjects().GetFirst()->data, _ChassisMass);
		btchassis->setCollisionFlags(0);
#else
		btCompoundShape* chassisShape = new btCompoundShape();
		btTransform transform;transform.setIdentity();
		// create box for car body
		transform.setOrigin(btVector3(0, 0.242f, -0.1));
		btCollisionShape* bodybox = new btBoxShape(btVector3(1.2f, 0.45f, 3.1f) / 2);// make me a convex hull
		chassisShape->addChildShape(transform, bodybox);
		// calculate MOI for car
		btVector3 localInertia;
		bodybox->calculateLocalInertia(_ChassisMass, localInertia);
		// create another box
		transform.setOrigin(btVector3(0, 0.7f, -0.3f));
		bodybox = new btBoxShape(btVector3(0.8f, 0.4f, 1.15f) / 2);// make me a convex hull
		chassisShape->addChildShape(transform, bodybox);
		// create car rigid body
		transform.setIdentity();
		btDefaultMotionState* motionstate = new btDefaultMotionState(transform);// transform
		btchassis = new btRigidBody(_ChassisMass, motionstate, chassisShape, localInertia);
		btchassis->setFriction(0.1f);
		btdynamicsWorld->addRigidBody(btchassis);
#endif
		btchassis->setActivationState(DISABLE_DEACTIVATION);
		btvehicleraycaster = new btDefaultVehicleRaycaster(btdynamicsWorld);
		btvehicle = new btRaycastVehicle(bttuning, btchassis, btvehicleraycaster);
		btdynamicsWorld->addVehicle(btvehicle);
		
		wheels[0].node = node->GetNode("wheelLF"); // LF
		wheels[1].node = node->GetNode("wheelRF"); // RF
		wheels[2].node = node->GetNode("wheelLR"); // LR
		wheels[3].node = node->GetNode("wheelRR"); // RR
		// when we load the model the wheels will be in the right place, remember those locations
		for(int i = 0; i < 4; i++) 
		{
			wheelangle[i] = 0;
			Wheel&wheel = wheels[i];
			bool isfrontwheel = i < 2;

			wheels[i].bindingpose = wheels[i].node->GetTransform();
			float3 cpoint = wheel.bindingpose.W.XYZ;
			btVector3 connectionpoint = *(btVector3*)&cpoint;
			float wheelradius = 0.23f;
			btVector3 wheelaxle = btVector3(1, 0, 0);
			btVector3 wheeldirection = btVector3(0, -1, 0);
			float suspensionrestlength = 0.2f;
			btvehicle->addWheel(connectionpoint, wheeldirection, wheelaxle, suspensionrestlength, wheelradius, bttuning, isfrontwheel);
		}
	}
	
	void Update()
	{
		float4x4 tr;
		btTransform bttr = btvehicle->getChassisWorldTransform();
		bttr.getOpenGLMatrix(&tr.X.X);
		node->SetTransform(tr);
		for(int i=0;i<4;i++)
		{
			// btvehicle->updateWheelTransform(i,true);
			Wheel&wheel = wheels[i];
			bool isfrontwheel = i < 2;

			float	wheelFriction = isfrontwheel ? 0.6f : 0.5f;//BT_LARGE_FLOAT;
			float	suspensionStiffness = isfrontwheel ? 15.5f : 15.5f;
			float	suspensionDamping = 2.0f;
			float	suspensionCompression = 1;
			float	rollInfluence = 1;
			
			btWheelInfo& btwheel = btvehicle->getWheelInfo(i);
			btwheel.m_suspensionStiffness = suspensionStiffness;
			btwheel.m_wheelsDampingRelaxation = suspensionDamping;
			btwheel.m_wheelsDampingCompression = suspensionCompression;
			btwheel.m_frictionSlip = wheelFriction;
			btwheel.m_rollInfluence = rollInfluence;

			wheelangle[i] += btwheel.m_deltaRotation;//*180*dtime;
			// Log::Message("%f %f", btwheel.m_rotation, btwheel.m_deltaRotation);
			// btwheel.m_rotation += btwheel.m_deltaRotation * 180;
			
			float4x4 m;
			btwheel.m_worldTransform.getOpenGLMatrix(&m.X.X);
			m = float4x4::RotateX(btwheel.m_rotation) * m;
			wheel.node->SetTransform(m * node->GetTransform().Inverse());
		}
		node->Synchronize();
	}
};

class CarCamera 
{
	float dist;//distancefromplayer;
	float height;
	Node* targetn;
public:
	CarCamera(Node*_Target,float _distancefromplayer, float _height)
	{
		targetn= _Target;
		dist=_distancefromplayer;
		height=_height;
		campos=float3(10,10,10);
		target = float3(0, 0, 0);
	};
	float4x4 transform;
	float3 campos;
	float3 target;
	void Update()
	{
		float3 _carpos = targetn->GetWorldTransform().W.XYZ;
		target -= (target - _carpos) / 5;
		float3 delta = campos - target; delta.Y = 0;
		delta = Normalize(delta) * dist;
		campos = target + delta;
		float3 from = campos + float3(0, height, 0);
		transform=float4x4::LookAt(from,target,float3(0,1,0));
	}
};
Car*vehicle;
CarCamera* carcamera;
void LoadScene()
{
	// since we're not going to converge in this demo we will now increase the raycount a bit
	pathtracer->SetRaysPerPixel(2);

	// create material to stick on the sky
	scene->SetSkyTexture( scene->CreateTexture( "../data/sky.png" ) );
	
	btcollisionConfiguration = new btDefaultCollisionConfiguration();
	btdispatcher = new btCollisionDispatcher(btcollisionConfiguration);
	btbroadphase = new btDbvtBroadphase();
	btSequentialImpulseConstraintSolver* btsolver = new btSequentialImpulseConstraintSolver();
	btdynamicsWorld = new btDiscreteDynamicsWorld(btdispatcher, btbroadphase, btsolver, btcollisionConfiguration);
	btdynamicsWorld->setGravity(btVector3(0,-10,0));
	
	Node*node = scene->GetRoot()->Add("../data/sample3/datsun.dae", false);
	vehicle = new Car(node, 1000);
	carcamera= new CarCamera(vehicle->node->GetNode("camera"),6,2);
#if 1
	environment = scene->GetRoot()->Add("../data/sample3/world.dae");
	ObjectStatic*world = (ObjectStatic*)environment->GetObjects().GetFirst()->data;
	btRigidBody*wb = BodyForMesh(world, 0);
#endif
}

void Update()
{
	float force = 0;
	float breakforce = 0;
	float maxsteer = 0.5f;
	if(GetAsyncKeyState('A') && steering <  maxsteer) steering += dtime * 2;
	if(GetAsyncKeyState('D') && steering > -maxsteer) steering -= dtime * 2;
	if(steering > maxsteer) steering =  maxsteer;
	if(steering <-maxsteer) steering = -maxsteer;

	steering /= powf(8, dtime);
	if(GetAsyncKeyState('W')) force = 3000;
	if(GetAsyncKeyState('S')) force = -500;
	if(GetAsyncKeyState(VK_SPACE)) force = 0, breakforce = 50;
	vehicle->btvehicle->setSteeringValue(steering, 0);
	vehicle->btvehicle->setSteeringValue(steering, 1);
	// vehicle->btvehicle->setSteeringValue(-steering / 2, 2);
	// vehicle->btvehicle->setSteeringValue(-steering / 2, 3);
	// vehicle->btvehicle->updateAction(btdynamicsWorld, dtime);
	for(int i=0;i<4;i++)
	{
		
		bool isfrontwheel = i < 2;
		if(!isfrontwheel) 
		{
			vehicle->btvehicle->setBrake(breakforce, i);
			vehicle->btvehicle->applyEngineForce(-force, i);
		}
	}
	time+=dtime;

	btVector3	worldBoundsMin,worldBoundsMax;
	// Timer t; t.Start();
	btdynamicsWorld->stepSimulation(dtime, 180, 1.0f / 180.0f);
	// t.Stop(); Log::Message("%i", t.ElapsedMs());
	vehicle->Update();
	carcamera->Update();
	
	bool cameramoved = DefaultKeyboardInput();
	cameramoved = true;	// because we're playing an animation we dont want to converge

	scene->GetCamera()->SetView(carcamera->transform);
	pathtracer->SetConverging(!cameramoved);
}
