#include "windows.h"
#include "brigade.h"
using namespace B2;
// located in framework main.cpp
extern PathTracer* pathtracer;
extern Scene* scene;
extern float dtime;
bool DefaultKeyboardInput();

// Application variables
Node * bob = 0;
Animation* bobanimation = 0;
float bobanimationstate = 0;

void LoadScene()
{
	// since we're not going to converge in this demo we will now increase the raycount a bit
	pathtracer ->SetRaysPerPixel(8);

	// create material to stick on the sky
	scene->SetSkyTexture( scene->CreateTexture( "../data/sky.png" ) );

	// load a model
	ImportResult result; // ImportResult is an object holding a reference to everything loaded 
	bob = scene->GetRoot()->Add("../data/sample2/bob.md5mesh", result);
	// find a animation in the loaded object
	if (result.animationcount < 1) Log::Error("No animation found.");
	bobanimation = result.animations[0];
	// because bob has Z+ as the up axis and is kind of big, we'll transform it.
	bob->SetTransform( result.root->GetTransform() * float4x4::Scale(0.1f));

	scene->GetRoot()->Add("../data/sample1/sample1.obj");
}
bool keystate = false;
void Update()
{
	// play the animation
	bobanimationstate += dtime;
	bobanimation->SetKeyFrame( bobanimationstate * bobanimation->GetFrameRate() );
	// we now set the keyframe, which basically transforms a bunch of nodes
	// now its time to tell the object that his nodes changed
	bob->Synchronize();

	// in this sample I will also show you how to change a material be 'shooting' it with a ray
	if (GetAsyncKeyState(VK_SPACE))
	{
		if(!keystate)
		{
			keystate = true;
			// extract the view
			float4x4 view = scene->GetCamera()->GetView();
			// view.W is the translation component of the matrix
			float3 RO = view.W.XYZ; // this will be the origin of our ray
			float3 RD = view.Z.XYZ; // Z is the forward component of the camera in brigade note that a maya camera uses -Z
			float dist = RAYLENGTH; // the maximum length of a ray in brigade is RAYLENGTH
			Triangle* tri = 0;		// the Trace function will store the triangle it hit here
			float3 N;				// and the normal here
			scene->Trace( RO, RD, dist, N, tri );// shoot the ray
			if (tri) // yay we hit something!
			{
				Material*material = tri->GetMaterial();
				if(material) // this should always be true
				{
					if(material->IsEmissive())// if the material is a emitter
					{
						material->emissiveColor = float3(0, 0, 0);
					}else{
						material->emissiveColor = float3(50, 50, 50);
					}
					material->Synchronize(); // synchronize informs Brigade the material has changed
					// as we could theoratically have more/less lights now we should tell brigade to syncronize them
					scene->GetRoot()->SynchronizeLights(); // inform Brigade that lights have changed
				}
			}
		}
	}else keystate = false;

	bool cameramoved = DefaultKeyboardInput();
	cameramoved = true;	// because we're playing an animation we dont want to converge
	pathtracer->SetConverging(!cameramoved);
}
