#pragma once
#include "bitmap.h"
#include "window.h"
#include "Graphics.h"
class SplashScreen
{
public:
	Bitmap image;
	WindowedWindow*window;
	GLTexture*screenbuffer;
	SplashScreen():image( "../data/logo.png" )
	{
		window = new WindowedWindow(image.GetSize(),"Splash",false);
		screenbuffer = new GLTexture( image );
		int2 screensize = int2(GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN));

		window->SetPosition(screensize / 2, true);
	}
	void Update()
	{
		window->Begin();
		glViewport( 0, 0, image.GetSize().X, image.GetSize().Y );
		glEnable( GL_TEXTURE_2D );
		screenbuffer->Bind();
		glColor3f( 1, 1, 1 );
		// draw the texture in a quad
		glBegin( GL_QUADS );
		glTexCoord2f( 0, 1 ); glVertex2f(-1,-1 );
		glTexCoord2f( 1, 1 ); glVertex2f( 1,-1 );
		glTexCoord2f( 1, 0 ); glVertex2f( 1, 1 );
		glTexCoord2f( 0, 0 ); glVertex2f(-1, 1 );
		glEnd();
		glDisable( GL_TEXTURE_2D );
		window->End();
		window->UpdateWindow();
	}
	~SplashScreen()
	{
		delete screenbuffer;
		delete window;
	}
};
