#pragma once
#include "vector.h"
using namespace Math;
typedef unsigned int GLuint;
class GLStreamingTexture
{
	GLuint texture;
	GLuint buffer;
	int2 Size;
public:
	GLStreamingTexture(int2 _Size);
	unsigned char*Lock();
	void Unlock();
	void Bind();
	int2 GetSize() { return Size; }
	~GLStreamingTexture();
};

class Bitmap;
class GLTexture
{
	uint texture;
	int2 Size;
	
	uint buffer;
public:
	
	GLTexture(Bitmap&_Bitmap);
	void Bind();
	void Draw(float2 _Pos, float2 _Size);
	void Draw(float2 _Pos) { Draw(_Pos, Size); }
	int2 GetSize()
	{
		return Size;
	}
};
