#include "windows.h"
#include "glee.h"
#include <gl\gl.h>
#include "vector.h"
#include "Graphics.h"
#include "Bitmap.h"
#include "stdio.h"
using namespace Math;
#include "settings.h"


void GLCheckForErrors(char* _FunctionName = "")
{
	int lasterror=glGetError();
	if(lasterror)
	{
		printf("OpenGL error in %s %i\n", _FunctionName, lasterror);
	}
}

GLStreamingTexture::GLStreamingTexture(int2 _Size)
{
	Size=_Size;
	glGenTextures(1,&texture);
	// gen texture
	glBindTexture(GL_TEXTURE_2D,texture);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE );
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE );
	glTexImage2D (GL_TEXTURE_2D, 0, GL_RGBA8, Size.X, Size.Y, 0, GL_RGBA, GL_UNSIGNED_INT_8_8_8_8_REV, NULL );
	glBindTexture(GL_TEXTURE_2D,0);
	GLCheckForErrors();

	// gen buffer
	glGenBuffers(1,&buffer);

	GLCheckForErrors();
}

unsigned char*GLStreamingTexture::Lock()
{
	glBindTexture( GL_TEXTURE_2D, texture );
	glBindBuffer( GL_PIXEL_UNPACK_BUFFER_ARB, buffer );
	glBufferData(GL_PIXEL_UNPACK_BUFFER_ARB,Size.X*Size.Y*sizeof(unsigned char)*4, NULL, GL_STREAM_DRAW );
	unsigned char* data = (unsigned char*)glMapBufferARB( GL_PIXEL_UNPACK_BUFFER_ARB, GL_WRITE_ONLY_ARB );
	glBindBuffer(GL_PIXEL_UNPACK_BUFFER_ARB, 0 );
	glBindTexture( GL_TEXTURE_2D, 0 );
	GLCheckForErrors();
	return data;
}

void GLStreamingTexture::Unlock()
{
	glBindTexture( GL_TEXTURE_2D, texture );
	glBindBuffer( GL_PIXEL_UNPACK_BUFFER_ARB, buffer );
	glUnmapBuffer( GL_PIXEL_UNPACK_BUFFER_ARB );
	glTexSubImage2D( GL_TEXTURE_2D, 0, 0, 0, Size.X, Size.Y, GL_RGBA, GL_UNSIGNED_INT_8_8_8_8_REV, NULL );
	glBindBuffer(GL_PIXEL_UNPACK_BUFFER_ARB, 0 );
	glBindTexture( GL_TEXTURE_2D, 0 );
	GLCheckForErrors();
}

void GLStreamingTexture::Bind()
{
	glBindBuffer(GL_PIXEL_UNPACK_BUFFER_ARB,buffer);
	glBindTexture(GL_TEXTURE_2D,texture);
	GLCheckForErrors();
}

GLStreamingTexture::~GLStreamingTexture()
{
	glBindTexture(GL_TEXTURE_2D, 0);
	glBindBuffer(GL_TEXTURE_2D, 0);
	glDeleteTextures(1, &texture);
	glDeleteBuffers(1, &buffer);
}


GLTexture::GLTexture(Bitmap&_Bitmap)
{
	Size = _Bitmap.GetSize();
	texture = 0;
	glGenTextures(1,&texture);
	glBindTexture(GL_TEXTURE_2D, texture);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, Size.X, Size.Y, 0, GL_RGBA, GL_UNSIGNED_BYTE, _Bitmap.GetBuffer() );
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);	// Linear Filtering
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);	// Linear Filtering
	
	GLCheckForErrors("GLTexture()");
}

void GLTexture::Bind()
{
	if(texture) glBindTexture(GL_TEXTURE_2D, texture);
}

void GLTexture::Draw(Math::float2 _Pos, Math::float2 _Size)
{
	_Pos.X /= 1280.0f / 2.0f;
	_Pos.Y /= 720.0f / 2.0f;
	_Size.X /= 1280.0f / 2.0f;
	_Size.Y /= 720.0f / 2.0f;
	_Pos.X -= 1;
	_Pos.Y -= 1;
	_Pos.Y *= -1;
	_Size.Y *= -1;
	Bind();
	glBegin( GL_QUADS );
	glColor3f(1, 1, 1);
	glTexCoord2f( 0, 1 ); glVertex2f( _Pos.X, _Pos.Y + _Size.Y );
	glTexCoord2f( 1, 1 ); glVertex2f( _Pos.X + _Size.X, _Pos.Y + _Size.Y );
	glTexCoord2f( 1, 0 ); glVertex2f( _Pos.X + _Size.X, _Pos.Y );
	glTexCoord2f( 0, 0 ); glVertex2f( _Pos.X, _Pos.Y );
	glEnd();
}
