
#include <windows.h>
#include "resource.h"

HWND hDlg;

// -------------------------------------------------------------------------------------------
INT_PTR CALLBACK parentProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam){

	RECT r;
	GetWindowRect(GetDlgItem(hwndDlg,CTRL_AREA),&r);
	MoveWindow(hDlg,r.left,r.top,r.right-r.left,r.bottom-r.top,TRUE);

	if (uMsg == WM_CLOSE)
		PostQuitMessage(0);	

	if (uMsg == WM_COMMAND)
		switch(wParam){
			//for people interested: how to SAVE the first dialog settings?
			//sending any message to child seems to not have effect
			//case IDOK:		
			//		SendMessage(hDlg,uMsg,wParam,lParam);		
			//case IDCANCEL:
			case IDOK:		
					PostQuitMessage(0);	
					break;
		}		
	
	return FALSE;
}
// -------------------------------------------------------------------------------------------
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow){                                               

	HMODULE hMod = LoadLibrary("c:\\windows\\system32\\nvstercp.dll");
	if (!hMod){
		MessageBox(NULL,"Error loading c:\\windows\\system32\\nvstercp.dll","Error",MB_OK);
		return 0;
	}
	FARPROC fProc1 = GetProcAddress(hMod,"GetStereoCPDlgTemplate");
	if (!fProc1){
		MessageBox(NULL,"Error getting GetStereoCPDlgTemplate","Error",MB_OK);
		goto error;
	}
	FARPROC fProc2 = GetProcAddress(hMod,"StereoCPProc");
	if (!fProc2){
		MessageBox(NULL,"Error getting StereoCPProc","Error",MB_OK);
		goto error;
	}
	
	HWND hParent = CreateDialog(NULL,MAKEINTRESOURCE(IDD_DIALOG1),NULL,(DLGPROC)parentProc);
	ShowWindow(hParent,SW_SHOW);

	// the fProc1 (GetStereoCPDlgTemplate) seems to be used to obtain
	// the dialog template #85, but return values are stranges....
	// hDlg = CreateDialog(hMod,(LPCTSTR)fProc1,hParent,(DLGPROC)fProc2);
	hDlg = CreateDialog(hMod,MAKEINTRESOURCE(85),hParent,(DLGPROC)fProc2);
	if (!hDlg){
		MessageBox(NULL,"Error creating dialog","Error",MB_OK);
		goto error;
	}
	ShowWindow(hDlg,SW_SHOW);

	MSG		msg;
	while (GetMessage(&msg,NULL,0,0))
		if (!IsDialogMessage(hDlg,(LPMSG)&msg))
			DispatchMessage ((LPMSG)&msg);		

error:

	FreeLibrary(hMod);
	return 0;
}
// -------------------------------------------------------------------------------------------
