/*********************************************************************
  global.h

  Copyright (C) 1999-2003	Promise Technology, Inc.
  May be copied or modified under the terms of the
  GNU Lesser General Public License

*********************************************************************/

#include <linux/blk.h>	
#include <linux/pci.h>

#include "/usr/src/linux/drivers/scsi/sd.h"
#include "/usr/src/linux/drivers/scsi/scsi.h"
#include "/usr/src/linux/drivers/scsi/hosts.h"

// Define Specific OEMs
// #define Linux_Fujitsu_0060
// #define Linux_Intel_0140
// #define Linux_Uniwide_0190

#define VERSION	"1.03.0.2"

#ifdef Linux_Intel_0140
#define VERSION	"2.30.0140.1"
#endif
//#define VERDATE "(21.DEC.2001)"
#define VERDATE ""

#define FT_Max_Ada	2
#define FT_Max_Arr	4

#define ChPAda		2	
#define DevPCh		2	

// Define PDC2026x Device ID
#define DID262		0x4D38	// FastTrak66
#define DID265		0x0D30	// FastTrak100 Lite
#define DID267		0x4D30	// FastTrak100
#define DID26x(x)	( (x==DID262) || (x==DID265) || (x==DID267) )
#define DID270		0x6268	// FastTrak100 LP/TX2/TX4
#define DID271		0x6269	// FastTrak TX2000
#define DID276		0x5275	// MBFastTrak133 Lite
#define DID277		0x7275	// SBFastTrak133 Lite
#define DID27x(x)	( (x==DID270) || (x==DID271) || (x==DID276) || (x==DID277) )
#ifndef Linux_Intel_0140
extern unsigned short 	FT_DEVID[8] ;
#else
extern unsigned short 	FT_DEVID[3] ;
#endif

#define FT_Max_Ch	4	
#define FT_Max_Dev	8 	
#define	Can_Queue	12
#define Max_SG_Table	32	// Engine : max bSG_Count = 255

#define DEB(x) 			//	Display messages
#define	DEBFUN(x) 	 	//	DEBUG Function	
#define	DebFtFun(x)  		//	DEBUG FastTrak Function	
#define	DebEngFun(x) 		//	DEBUG Engine   Function	
#define	DebScsiFun(x) 		//	DEBUG SCSI     Function	
#define	DebConnectStor_Series(x) //	DEBUG ConnectStor_Series     Function	

typedef struct ft_adapter ft_adapter_t ;
typedef struct ft_channel ft_channel_t ;
typedef struct ft_drive   ft_drive_t ;
typedef struct ft_proc    ft_proc_t;

/* Bits of HD_STATUS */
#define ERR	0x01
#define IDX	0x02
#define CORR	0x04
#define DRQ	0x08
#define SEEK	0x10
#define DF	0x20
#define DRDY	0x40
#define BSY	0x80

#define READ_PIO	0x20
#define WRITE_PIO	0x30
#define READ_PIO_EXT	0x24	
#define WRITE_PIO_EXT	0x34

#define READ_DMA	0xC8
#define WRITE_DMA	0xCA
#define READ_DMA_EXT	0x25	
#define WRITE_DMA_EXT	0x35	

/* definitions of LED color */
#define LED_Off		0x00
#define LED_Red		0x01
#define LED_Green	0x02
#define LED_Amber	0x03
#define LED_MASK	0x03
// -------------------------------------------------------------------
struct ft_adapter {
   unsigned char	id; 
   unsigned char	present; 
   unsigned short	deviceid;
   unsigned short	irq;
   struct pci_dev	*ft_pci_dev;
   unsigned int		rom_base;
   spinlock_t		ft_lock;
   ft_channel_t		*pchannel[2];	
}  ;
// -------------------------------------------------------------------
struct ft_channel {
   ft_adapter_t 	*padapter ;	
   unsigned char	id;
   unsigned char	abnormality;	//// 	1.2.0.12
   unsigned short	base;
   unsigned short	ctrl;
   unsigned short	bm;
   ft_drive_t		*pdrive[2];   	
}  ;
// -------------------------------------------------------------------
//The Main disk structure for each drive
struct ft_drive {
   ft_channel_t		*pchannel;	
   unsigned char	id;
   unsigned char	select;
   unsigned char	present;
   unsigned char 	downmode;	////	1.2.0.13
   unsigned char 	xfermode;
   unsigned char	arr;
   unsigned char	strm;
   unsigned char	lbusy;		////	1.2.0.11
   unsigned char	lpending;	////	1.2.0.11
   unsigned char	rebuilding;
   unsigned char	LBA_48bit;	////	1.2.0.12
   unsigned char	light;		////	1.2.0.13
   struct ft_driveid	*identify;
}  ;
// -------------------------------------------------------------------
//The SwapBox structure for IOCTL (0X3803)
typedef struct {
   unsigned char	present;
   unsigned char 	BoxID;
   unsigned short	MIC;	// monitor IC
   unsigned long	RPM;
   unsigned short	TmpC;
   unsigned short	TmpF;
   unsigned short	Vcc;	// (mv)
   unsigned short	V12;	// (mv)
}  ft_swapbox_t ;
// -------------------------------------------------------------------
//The Main Adapter structure for IOCTL(0x3801)
typedef struct {
   unsigned short	deviceid;
   unsigned char	irq;
   unsigned short	base[5];
   unsigned int 	rom;
}  ft_ladainfo_t ;
// -------------------------------------------------------------------
//The Array structure for ft_info_t - IOCTL(0x3801)
typedef struct {
   unsigned char	ID;
   unsigned char	Flag;
   unsigned char 	RAID;
   unsigned char	StripeBlockPower;
   unsigned short	Cyl;
   unsigned char	Hd;
   unsigned char	Sctr;
   unsigned int		Size;
   unsigned int		Watermark;
   unsigned char	strm;
   //By Hank, build 26
   unchar		bWidth;
}  ft_larrinfo_t ;
// -------------------------------------------------------------------
//The Main Information structure for IOCTL (0x3801)
typedef struct {
   unsigned char	ver[30];
   ft_ladainfo_t	adainfo[FT_Max_Ada];
   ft_larrinfo_t	arrinfo[FT_Max_Arr];
   unsigned char	rebdev;
}  ft_info_t ;
// -----------------------------------------------
struct	scsiengreq {	// SCSI - Engine request
   void			*cmd;
   void			*fn;
   unsigned char	target;
   unsigned char	use_sg;
   unsigned char	*buffer;
   unsigned char	*sense;
   unsigned char	cmnd[12];
   unsigned long	WStartAddr[Max_SG_Table];
   unsigned long	WCount[Max_SG_Table];   
} ; 
typedef	struct	scsiengreq *ScsiEngReq_p ;
// -------------------------------------------------------------------
/* Identify device information according to ATA6 SPEC.*/
struct ft_driveid {
	unsigned short	config;		
	unsigned short	cyls;		/* "physical" cyls */
	unsigned short	word2;	
	unsigned short	heads;		/* "physical" heads */
	unsigned short	words4[2];	/* reserved words 4-5 */
	unsigned short	sectors;	/* "physical" sectors per track */
	unsigned short	words7[3];	/* reserved words 7-9 */
	unsigned char	serial_no[20];	/* word10 - word19 */
	unsigned short	words20[3];	/* reserved words 20-22 */
	unsigned char	fw_rev[8];	
	unsigned char	model[40];	/* word27 - word46 */
	unsigned short	words47[2];	/* reserved words 47-48 */
	unsigned char	byte49;	
	unsigned char	capability;	/* word49: bit8-bit15*/
	unsigned short	word50[3];	/* reserved words 50-52 */
	unsigned short	field_valid;	/* word53 */
	unsigned short	cur_cyls;	/* logical cylinders */
	unsigned short	cur_heads;	/* logical heads */
	unsigned short	cur_sectors;	/* logical sectors per track */
	unsigned short	words57[2];	/* reserved words 57-58 */
	unsigned short	mult_sect;	
	unsigned int	lba_capacity;	
	unsigned short	word62;
	unsigned short	dma_mword;	/* word63 */
	unsigned short  word64[3]; 	/* reserved words 64-66 */
	unsigned short  eide_pio;       /* word67 */
	unsigned short  eide_pio_iordy; /* word68 */
	unsigned short  words69[11];	/* reserved words 69-79 */
	unsigned short  major_ver_num;	/* major version number */
	unsigned short  minor_ver_num;	/* minor version number */
	unsigned short  cmd_set[2];	/* command sets supported */
	unsigned short  cfs[4];		/* command set/feature (84-87) */
	unsigned short  dma_ultra;	/* word 88 */
	unsigned short  words89[11];	/* reserved words 89-99 */
	unsigned short  max_48LBA[4];	/* max LBA address for 48bit */
	unsigned short  words104[22];	/* reserved words 104-125 */
	unsigned short	last_lun;	/* word 126 */
	unsigned short	word127;	/* word 127 */
	unsigned short	dlf;		/* device lock function */
	unsigned short  csfo;		/* current set features options */
	unsigned short	words130[26];	/* reserved words 130-155 */
	unsigned short	words156[4];	/* reserved words 156-159 */
	unsigned short	words160[95];	/* reserved words 160-255 */	
};

struct ft_proc {
   char *buffer;
   int  length;
   int  offset;
   int  position;
};

extern 	ft_adapter_t 	ft_adapter[FT_Max_Ada];
extern 	ft_channel_t 	ft_channel[FT_Max_Ch];
extern 	ft_drive_t 	ft_drive[FT_Max_Dev];
extern	ft_swapbox_t 	ft_box[FT_Max_Dev];
extern	ft_info_t 	ft_info;
extern  ft_proc_t	ft_proc;
//extern 	unsigned long   DEVBUSY[FT_Max_Dev] ;
extern 	unsigned char 	blConfigDoneFlag;

#define bPOWER_UP		0x00
#define bHARD_RESET		0x01
#define bSOFT_RESET		0x02

unsigned char 	identify_device(unsigned char dev,void *id) ;
unsigned char  	bInitRAID(unsigned char bType,unsigned long wP, unsigned char *p_b, unsigned long wSize, unsigned char *p_bVir);

// fasttrak
int set_speed(unsigned char dev, unsigned char pio_mode, unsigned char dma_mode, unsigned char udma_mode);
int set_feature(unsigned char dev, unsigned char *pio_mode, unsigned char *dma_mode, unsigned char *udma_mode);

// ftlog
void 	log_event(int eventid, int ArrayID, int dev, unsigned long LBA, int percent, short command, short status);

extern unsigned char	SCSIRequestFlag ;
extern unsigned char	ProcRequestFlag ;
extern unsigned long	spenttime ;
void 			InitQueueBuffer(void) ;

char 	DefDriveStruct (void) ;
void 	SWAP_STATE(unsigned char fun,unsigned char dev) ;
void	SwapSubFun(unsigned char fun,unsigned short port) ;
unsigned char RW_Byte(unsigned char fun,unsigned char val,unsigned short port);
unsigned char RWWinReg(unsigned char fun,unsigned char dev,unsigned char index,unsigned char data) ;
void 	GetSwapInfo (unsigned char dev) ;
void 	InitLED(void) ;
void	CtrlLED(unsigned char dev, unsigned char color) ;
int 	GetProcInfo( ft_proc_t  *buff );
int 	RepArrInfo (void *buffer) ;
char 	GetAllSwapInfo (void);
int 	Check1F7(unsigned char dev,unsigned long msec,unsigned char good,unsigned char bad);
int 	CheckChannelBus(unchar ch);
int 	InitForSpecificOEM(void); 
int 	Ioctl3804(unsigned char *args) ;
int 	Ioctl3807(unsigned char *args) ;
int 	Ioctl3808(unsigned char *args) ;
int 	Ioctl3809(unsigned char *args) ;
int 	Ioctl380E(unsigned char *args) ;
int	Ioctl380F( Scsi_Device *device , unsigned char *args );

#define IOCTL_GET_ENQUIRE		0x3801
#define IOCTL_GET_IDENTIFY		0x3802
#define IOCTL_GET_SWAPBOX		0x3803
#define IOCTL_REBUILD_OPTION		0x3804
#define IOCTL_SWAPBOX_POWER		0x3805
#define IOCTL_GET_EVENT_LOG		0x3806
#define IOCTL_FORCE_SYNC		0x3807
#define IOCTL_DISK_WRITE_CACHE_OPTION	0x3808
#define IOCTL_FLUSH_DISK_CACHE_OPTION	0x3809
#define IOCTL_FASTCHECK_EVENT_LOG	0x380E
#define IOCTL_FLASH_BIOS		0x380F
#define IOCTL_READ_RESERVE_SECTOR	0x3810
#define IOCTL_CREATE_ARRAY		0x3811
#define IOCTL_DELETE_ARRAY		0x3812
#define IOCTL_BLK_IDENTIFY		0x3813

//event log struct provided thru ioctl
typedef struct {
   int sequence;
   int eventid;
   int arrayid;
   int diskid;
} snmp_log_t;

extern  snmp_log_t	snmp_log[50];
extern  int		snmp_log_index;

// By Bennett
// flash ioctl structure
extern unsigned char	*flash_pmem[FT_Max_Ada];
extern unsigned char	*flash_vmem[FT_Max_Ada];
extern unsigned short	flash_port[FT_Max_Ada];
extern unsigned short	index1[FT_Max_Ada];
extern unsigned short  	data1[FT_Max_Ada];
extern unsigned char  	old_PLLF,old_PLLODnR;
extern volatile unsigned int	flash_now;

// flash ioctl command packet
struct	flash_ioctl_args
{
	unsigned char	cmd;
	unsigned char	num;		//current adapter
	unsigned short	id_code;	//tx2 family = 1
	unsigned long	faddr;
	unsigned char	fdata;
};

// flash ioctl command list
#define	FLASH_ACCESS_ENABLE	0x01
#define	FLASH_ACCESS_DISABLE	0x02
#define	EXTERNAL_FLASH_WRITE	0x03
#define	EXTERNAL_FLASH_READ	0x04
#define	INTERNAL_FLASH_ERASE	0x05
#define	INTERNAL_FLASH_WRITE	0x06
#define	INTERNAL_FLASH_READ	0x07


// FastCheck event log ioctl
#define	MAX_EVENT	20

typedef struct
{
	int		num;
 	int    		eventid;
	int		ArrayID;
	int		dev;
	unsigned long	LBA;
        int 		percent;
	short 		command;
	short 		status;
}Event_t;

extern	Event_t		Event[MAX_EVENT];
extern	unsigned short	EventPtr;
extern	unsigned short	EventIoctlPtr;

//By Hank, build26
extern  int		stop_rebuild_flag;
extern	int		stop_rebuild(void);

//By Hank, build26
typedef struct CreateArray_Buffer
{
	//unchar bPhysIndex;
	unchar blRAID;
	unchar nDisk;
	unchar DiskID[8];
	unchar nStripeBlockSize;
	char Arrayname[32];
	long status;  // 1=ok
}  CreateArray_Buffer_t;

typedef struct DeleteArray_Buffer
{
	unchar bPhysIndex;
    	long status;  // 1=ok
}  DeleteArray_Buffer_t;

