/*
 *	@(#) Space.c 7.1 94/11/27 SCOINC
 *
 *      Copyright (C) The Santa Cruz Operation, 1993-1994.
 *      This Module contains Proprietary Information of
 *      The Santa Cruz Operation and should be treated
 *      as Confidential.
 */

/*
 *	System V STREAMS TCP - Release 4.0
 *
 *	Copyright 1987, 1988 Lachman Associates, Incorporated (LAI)
 *
 *	All Rights Reserved.
 *
 *	The copyright above and this notice must be preserved in all
 *	copies of this source code.  The copyright above does not
 *	evidence any actual or intended publication of this source
 *	code.
 *
 *	This is unpublished proprietary trade secret source code of
 *	Lachman Associates.  This source code may not be copied,
 *	disclosed, distributed, demonstrated or licensed except as
 *	expressly authorized by Lachman Associates.
 *
 *	System V STREAMS TCP was jointly developed by Lachman
 *	Associates and Convergent Technologies.
 */
#include "sys/types.h"
#include "sys/stream.h"
#include "sys/mdi.h"
#include "config.h"
#include "space.h"
#include "r3e.h"

			/* IRQ LEVEL */
u_int r3eintl[4] = {
#ifdef R3E_0
		R3E_0_IRQ,
#endif
#ifdef R3E_1
		R3E_1_IRQ,
#endif
#ifdef R3E_2
		R3E_2_IRQ,
#endif
#ifdef R3E_3
		R3E_3_IRQ,
#endif
};

			/* I/O BASE ADDRESS */
u_int r3eiobase[4] = {
#ifdef R3E_0
		R3E_0_BASE_IO,
#endif
#ifdef R3E_1
		R3E_1_BASE_IO,
#endif
#ifdef R3E_2
		R3E_2_BASE_IO,
#endif
#ifdef R3E_3
		R3E_3_BASE_IO,
#endif
};


u_int			r3e_nunit = R3E_CNTLS;
struct r3edevice	r3edevice[R3E_CNTLS];  

extern int r3eopen(), r3eclose(), r3euwput();
extern int nulldev();

struct module_info r3e_minfo = {
	0, "r3e", 1, r3eETHERMTU, 16*r3eETHERMTU, 12*r3eETHERMTU
};

struct qinit r3eurinit = {
	0,  0, r3eopen, r3eclose, nulldev, &r3e_minfo, 0
};

struct qinit r3euwinit = {
	r3euwput,0,r3eopen,r3eclose, nulldev, &r3e_minfo, 0
};

struct streamtab r3einfo = { &r3eurinit, &r3euwinit, 0, 0 };
