/*
 * filter.c
 * a program to take the output produced by Pegasus Mail/PC in standalone
 * mode, and place it appropriately. with associated
 * support .cmd and .xqt files for mail processing using the Waffle BBS uucico
 * and uuxqt programs.
 *
 * Pegasus Mail/PC (C) Copyright 1990, 1991, David Harris, Dunedin, New Zealand
 * WAFFLE  (C) Copyright 1991 by Darkside International of Mountain View CA.
 *
 * Author: Brendan Murray, Dunedin, New Zealand
 * Permission is granted to do whatever you like with this code. Just about
 * anyone ought to be able to improve on it. No warranty whatsoever is granted
 * or implied.
 *
 * V1.1
 */

/*
 *	Command line parameters.
 *	0:	the command
 *	1:	username
 *	2:	container file name -- full path
 *	3:	To: field for mail
 *	4:	The time in RFC 822 format
 *
 *	Actions
 *	1. Take the RFC 822 message produced by pmail and prepend a
 *		uucp acceptible From line
 *	2. Create a .cmd file to tell UUCICO what to do
 *	3. Create a .xqt file to tell UUXQT what to do at the other end
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <ctype.h>

void main (int argc, char * argv[] )
   {
   FILE *outfile;
   FILE *infile;

   char *dat_FileName;
   char *cmd_FileName;
   char *xqt_FileName;

   char *HostName;	/* this host */
   char *SmartHost;     /* who sends things on for us */
   char *Spool;	        /* where to put things */
   char *TimeZone;      /* for the header */

   /* for fnsplit and fnmerge */
   char *drive;
   char *dir;
   char *name;
   char *ext;

   char *wafdir;
   char *tmpstring;

   int cntr;
   int cntr2;
   char ch;

   if (argc != 5)
      {
      /* even though Pmail probably won't display this */
      fprintf(stderr,"Usage: filter username container-file to-line date\n");
/*      exit(1); */
      }


/*
 *	Waffle uses an environment variable (WAFFLE) to point at the
 *	static parameters file
 */
   wafdir = (char *) malloc(MAXPATH);
   if (( wafdir = (char *) getenv ("WAFFLE")) == NULL)
      {
      fprintf (stderr, "ERROR: WAFFLE has not been defined\n");
      exit(1);
      }

   if (( infile = fopen(wafdir,"r")) == NULL)
      {
      fprintf(stderr,"Unable to open %s",wafdir);
      exit(1);
      }

   tmpstring = (char *) malloc (132);
   while ((fgets(tmpstring, 132, infile)) != NULL)
      {
      if ((strnicmp(tmpstring, "uucpname", 8)) == 0)
	 {
	 cntr = 8; /* might as well start here */
	 /* find an alpha character, the start of the uucpname */
	 while ((!isalpha(tmpstring[cntr])) && (tmpstring[cntr] != '\0'))
	    cntr++;
	 if (tmpstring[cntr] == '\0')
	    {
	    fprintf(stderr,"No UUCPNAME specified in %s\n",wafdir);
	    exit(1);
	    }
	 HostName = (char *) malloc (132); /* it can't be bigger than this? */
	 cntr2 = 0;
	 while ((isalpha(tmpstring[cntr])) && (tmpstring[cntr] != '\0'))
	    HostName[cntr2++] = tmpstring[cntr++];
	 HostName[cntr2] = '\0';
	 }
      else
	 if (( strnicmp(tmpstring, "smarthost", 9)) == 0)
	    {
	    cntr = 9; /* might as well start here */
	    /* find an alpha character, the start of the Smart Host name */
	    while ((!isalpha(tmpstring[cntr])) && (tmpstring[cntr] != '\0'))
	       cntr++;
	    if (tmpstring[cntr] == '\0')
	       {
	       fprintf(stderr,"No SMARTHOST specified in %s\n",wafdir);
	       exit(1);
	       }
	    SmartHost = (char *) malloc (132); /* it can't be bigger than this? */
	    cntr2 = 0;
	    while ((isalpha(tmpstring[cntr])) && (tmpstring[cntr] != '\0'))
	       SmartHost[cntr2++] = tmpstring[cntr++];
	    SmartHost[cntr2] = '\0';
	    }
	 else
	    if (( strnicmp(tmpstring, "spool", 5)) == 0)
	       {
	       cntr = 5; /* might as well start here */
	       /* find an alpha character, the start of the spool directory name */
	       while ((!isalpha(tmpstring[cntr])) && (tmpstring[cntr] != '\0'))
		  cntr++;
	       if (tmpstring[cntr] == '\0')
		  {
		  fprintf(stderr,"No SPOOLDIR specified in %s\n",wafdir);
		  exit(1);
		  }
	       Spool = (char *) malloc (132); /* it can't be bigger than this? */
	       cntr2 = 0;
	       while ((tmpstring[cntr] != '\0') && (tmpstring[cntr] != '\n'))
		  if (tmpstring[cntr] == '/')
		     {
		     Spool[cntr2++] = '\\';
		     cntr++;}
		  else
		     Spool[cntr2++] = tmpstring[cntr++];
	       Spool[cntr2] = '\0';
	       }
	    else
	       if ((strnicmp(tmpstring,"timezone", 8)) == 0)
		  {
		  cntr = 8;
		  while ((tmpstring[cntr] == ':') || (tmpstring[cntr] == ' '))
		     cntr++;
		  TimeZone = (char *) malloc (132); /* a number! */
		  cntr2 = 0;
		  while ((tmpstring[cntr] != '\0') && (tmpstring[cntr] != '\n'))
		     TimeZone[cntr2++] = tmpstring[cntr++];
		  TimeZone[cntr2] = '\0';
		  }
      }
      fclose(infile);


/*
 * allocate space for file name bits
 */
   drive = (char *) malloc(MAXDRIVE);
   dir = (char *) malloc(MAXDIR);
   name = (char*) malloc(MAXFILE);
   ext = (char *) malloc(MAXEXT);


   dat_FileName = (char *) malloc (MAXPATH);
   cmd_FileName = (char *) malloc (MAXPATH);
   xqt_FileName = (char *) malloc (MAXPATH);

   Spool = strcat(Spool,"\\");
   Spool = strcat(Spool,SmartHost);
   Spool = strcat(Spool,"\\");

   /* drive and directory from Spool */
   fnsplit(Spool, drive, dir, NULL, NULL);
   /* file name from input arguments */
   fnsplit(argv[2], NULL, NULL, name, NULL);
   /* put 'em together and what do you get? */
   fnmerge(dat_FileName, drive, dir, name, ".DAT");

/*
 *	create the data file for mailing
 */
   if ((outfile = fopen(dat_FileName,"w")) == NULL)
      {
      fprintf(stderr,"Open of DAT file %s failed\n", dat_FileName);
      exit(1);
      }
   if ((infile = fopen(argv[2],"r"))== NULL)
      {
      fprintf(stderr,"Error opening container file %s\n", argv[2]);
      exit(1);
      }

   fprintf(outfile,"From %s, %s %s remote from %s\n",
	   argv[1], argv[4], TimeZone, HostName);

   while (( ch = fgetc(infile)) != EOF )
       fputc(ch, outfile);

   fclose(infile);
   fclose(outfile);

/*
 * create the ".CMD" file - commands to UUCICO (?)
 *	Format:
 *	S 0051.DAT D.home0051 brendan - 0051.DAT 0666
 *	S 0051.XQT X.home0051 brendan - 0051.XQT 0666
 *
 *  (roughly)
 *    SEND local-filename as-filename from - ????? unix-file-mode
 */
   fnsplit (dat_FileName, drive, dir, name, ext);
   fnmerge(cmd_FileName, drive, dir, name, ".CMD");
   if ((outfile = fopen (cmd_FileName,"w")) == NULL)
      {
      fprintf(stderr,"Open of CMD file %s failed\n", cmd_FileName);
      exit(1);
      }

   fnmerge(dat_FileName, NULL, NULL, name, ".DAT");
   fnmerge(xqt_FileName, NULL, NULL, name, ".XQT");

   fprintf(outfile, "S %s D.%s%s %s - %s 0666\n", dat_FileName, HostName,
	   name, argv[1], dat_FileName);

   fprintf(outfile, "S %s X.%s%s %s - %s 0666\n", xqt_FileName, HostName,
	   name, argv[1], xqt_FileName);
   fclose(outfile);

 /*
  *	Create the ".XQT" file --  commands to uuxqt at the other end!
  *
  *
  *	Format:
  *	U brendan home
  *	Z
  *	F  D.home0051
  *	I D.home0051
  *	C rmail brendan
  *
  *	where the commands defined in the uuxqt file are (as stated by
  *     Ian Taylor (Ian@airs.com, uunet!airs!ian) in a newsitem posted
  *	to comp.unix.internals 4 Apr 1992)
  *
  *	"Here are the commands defined in uuxqt files:
  *
  *	 C command-line
  *	 I standard-input
  *	 O standard-output [ system ]
  *	 F required-file filename-to-use
  *	 R requestor-address
  *	 U user system
  *	 Z (acknowledge if command failed; default)
  *	 N (no acknowledgement on failure)
  *	 n (acknowledge if command succeeded)
  *	 B (return command input on error)
  *	 e (process with sh)
  *	 E (process with exec)
  *	 M status-file
  *	 # comment					"
  *
  */
   fnmerge(xqt_FileName,drive, dir, name, ".XQT");
   if ((outfile = fopen (xqt_FileName,"w")) == NULL)
      {
      fprintf(stderr,"Open of XQT file %s.XQT failed\n", xqt_FileName);
      exit(1);
      }
   fprintf(outfile,"U %s %s\n", argv[1], HostName);
   fprintf(outfile,"Z\n");
   fprintf(outfile,"F D.%s%s\n", HostName, name);
   fprintf(outfile,"I D.%s%s\n", HostName, name);
   fprintf(outfile,"C rmail %s\n", argv[3]);
   fclose(outfile);

/*
 *	Now delete the file created by pmail, 'cos all this worked,
 *	didn't it! You might want to stop this from happening, as a
 *	log, since uucico deletes the files when finished, or just
 *	in case you're paranoid and might want to re-process it all
 *	later.
 */

/*   if ( (unlink(argv[2])) != 0)
      {
      fprintf(stderr,"Failed to delete PMAIL temporary file %s\n", argv[3]);
      exit(1);
      }
*/
   }