//////////////////////////////////////////////////////////////////////////
//
//  IGATOR Copyright (C) 1997-98 RIT Research Labs
//
//  This programs is free for commercial and non-commercial use as long as
//  the following conditions are aheared to.
//
//  Copyright remains RIT Research Labs, and as such any Copyright notices
//  in the code are not to be removed. If this package is used in a
//  product, RIT Research Labs should be given attribution as the RIT Research
//  Labs of the parts of the library used. This can be in the form of a textual
//  message at program startup or in documentation (online or textual)
//  provided with the package.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//
//  1. Redistributions of source code must retain the copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. All advertising materials mentioning features or use of this software
//     must display the following acknowledgement:
//     "Based on IGATOR by RIT Research Labs."
//
//  THIS SOFTWARE IS PROVIDED BY RIT RESEARCH LABS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//  DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
//  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
//  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
//  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
//  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
//  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//  The licence and distribution terms for any publically available
//  version or derivative of this code cannot be changed. i.e. this code
//  cannot simply be copied and put under another distribution licence
//  (including the GNU Public Licence).
//
//////////////////////////////////////////////////////////////////////////

unit _Pop;

interface

procedure CheckPop;

implementation
uses Windows, SysUtils, WinSock, Logger, Config, Utils, _In, WSocket, XReader;

procedure CheckPop;

  procedure DoCheck(U: TUser); far;
    var
        InSock: TTextReader;
        s, FName: String;
        F: TDosStream;
        Socket: TSocket;
        I,J,K,N: Integer;
        LR: Integer;
        NMsg, NBytes: Integer;

    function OKReply(const L: String): Boolean;
    var
      I: Integer;
    begin
      s := InSock.GetStr;
      if UpperCase(Copy(S,1,3)) = '+OK' then OKReply := True
         else begin
                OKReply := False;
                Delete(S, 1, 5);
                while (S[Length(S)] in [#13, #10]) do Delete(S, Length(S), 1);
                if S <> '' then Insert(', server responce: ', S, 1);
                if L <> '' then Log('ERROR: '+L+S, True);
              end;
    end;

    procedure SendCmd(S: String);
    begin
      S := S + #13#10;
      Socket.Write(S[1], Length(S));
    end;

    function ReceMessage(N: Integer): Boolean;
      var
        I,J: Integer;
        S: string;
      label 1;
    begin
      Result := False;
      Log('Getting message '+ItoS(N-LR)+' of '+ItoS(NMsg-LR), True);
      SendCmd('RETR '+ItoS(N));
      S := InSock.GetStr;
      if UpperCase(Copy(S,1,3)) <> '+OK' then
        begin
          Delete(S, 1, 3);
          Log('ERROR: Could not retrieve message, server responce:'+S, True);
          Exit;
        end;
      F := TDosStream.Create('IGATOR.POP', stCreate);
      if F.Status <> 0 then
        begin
          Log('ERROR: Could not create the output file', True);
          F.Free;
          Exit;
        end;

      repeat
        S := InSock.GetStr + #13#10;
        F.Write(S[1], Length(S));
        if S = '.'#13#10 then Break;
        if Socket.Status <> 0 then Break;
        if InSock.EOF then Break;
      until False;
      F.Free;
      if (S <> '.'#13#10) then
        begin
          Log('ERROR: Connection to server lost', True);
          DeleteFile('IGATOR.POP');
        end else
         begin
           FName := 'IGATOR.POP';
           SendNetmail(FName, U);
           if U.PopLastread < 0 then
             begin
               SendCmd('DELE '+ItoS(N));
               if OKReply('Could not delete the message from server') then
                 else Log('Message deleted from server', True);
             end;
           U.Modified := True;
           Result := True;
         end;
    end;


  begin
    InSock := nil;
    if (U.Pop = '') or (U.PopPassword = '') then Exit;
    S := U.Pop;
    I := Pos('@', S);
    if I = 0 then
      begin
        Log('ERROR: There is no POP3 user name defined for '+U.Name+'('+U.Addr+')', True);
        Exit;
      end;
    Socket := TSocket.Create(AF_INET);
    if Socket.Status <> 0 then
      begin
        Socket.Free;
        Log('ERROR: Could not open socket, error no: '+ItoS(Socket.Status), True);
        Exit;
      end;
    Delete(S, 1, I);
    Log('Trying POP3 mail server - '+S, True);
    if Socket.Connect(S, 110) then
      begin
        Log('Connected to '+S, True);
        InSock := CreateTextReaderByStream(Socket);
        if OKReply('POP server is not ready') then
        begin
          SendCmd('USER '+Copy(U.Pop, 1, I-1));
          if OKReply('User is not accepted') then
          begin
            SendCmd('PASS '+U.PopPassword);
            if OKReply('Password is not accepted') then
            begin
              SendCmd('STAT');
              if OKReply('Could not get statistics') then
              begin
                Delete(S, 1, 3);
                I := 1;
                while (I <= Length(S)) and ((S[I]<'0') or (S[I]>'9'))  do Inc(I);
                J := 1;
                while (I+J <= Length(S)) and (S[I+J]>='0') and (S[I+J]<='9') do Inc(J);
                Val(Copy(S, I, J), NMsg, J);
                LR := U.PopLastRead; if LR < 0 then LR := 0;
                Log(ItoS(NMsg-LR)+' new messages for '+U.Name, True);
                N := LR+1;
                while (N <= NMsg) and ReceMessage(N) do Inc(N);
                if (N > NMsg) and (U.PopLastread >= 0) and (NMsg > U.PopLastread) then
                  begin
                    U.PopLastRead := NMsg;
                    U.Modified := True;
                  end;
              end;
            end;
          end;
          SendCmd('QUIT');
          Log('Connection finished', True);
        end;
      end else Log('ERROR: Could not connect to pop server '+S, True);
    InSock.Free;
    Socket.Free;
  end;

  var UCount: Integer;

begin
 if NetPath[Length(NetPath)] <> '\' then NetPath := NetPath + '\';
 Log('Checking POP3 mailboxes', True);
 for UCount := 0 to Users.Count-1 do
     DoCheck(Users[UCount]);
end;




end.


