//////////////////////////////////////////////////////////////////////////
//
//  IGATOR Copyright (C) 1997-98 RIT Research Labs
//
//  This programs is free for commercial and non-commercial use as long as
//  the following conditions are aheared to.
//
//  Copyright remains RIT Research Labs, and as such any Copyright notices
//  in the code are not to be removed. If this package is used in a
//  product, RIT Research Labs should be given attribution as the RIT Research
//  Labs of the parts of the library used. This can be in the form of a textual
//  message at program startup or in documentation (online or textual)
//  provided with the package.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//
//  1. Redistributions of source code must retain the copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. All advertising materials mentioning features or use of this software
//     must display the following acknowledgement:
//     "Based on IGATOR by RIT Research Labs."
//
//  THIS SOFTWARE IS PROVIDED BY RIT RESEARCH LABS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//  DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
//  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
//  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
//  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
//  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
//  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//  The licence and distribution terms for any publically available
//  version or derivative of this code cannot be changed. i.e. this code
//  cannot simply be copied and put under another distribution licence
//  (including the GNU Public Licence).
//
//////////////////////////////////////////////////////////////////////////

unit _In;

interface
uses Config;

procedure ScanBoxes;
procedure SendNetmail(var FName: String; U: TUser);

implementation

uses Windows, SysUtils, Classes, IniFiles, Utils, SendMail, Logger, _UUE;

type
     TEncoding = (etNone, etBase64, etQuoted);


procedure CutBraces(var S: String);
  var I,J: Integer;
begin
  if S = '' then Exit;
  I := 1+Byte(S[1]='<');
  J := Length(S)-I-Byte(S[Length(S)]='>')+1;
  S := Copy(S, I, J);
end;


procedure SendNetmail(var FName: String; U: TUser);
  var Zone, Net, Node, Point: Word;
      T: Text;
      B, BF: PByteArray;
      L, BS: LongInt;
      S, S1: String;
      I,J: Word;
      C: Char;
      Msg: Boolean;
      M_From: String[34];
      M_Reply: String;
      M_Subj: String[71];
      M_Date: String[40];
      DD: TDosStream;
      H: TMsgHdr;
      F: TDosStream;
      E: TEncoding;
      UE: TMimeCoder;
      Tx: Boolean;
      BRest: String[4];

  procedure SendRRQ(S: String);
    var F, F1: Text;
        DT: record
              Year, Month, Day,
              Hour, Min, Sec: Word;
            end;
        W,SS: Word;
        D: String[255];
        I,J: Integer;

    procedure FillAddr;
      var Nm,Addr: String;
    begin
      ExtractAddrInfo(S, Nm, Addr);
      Assign(F, 'IGATOR.ADR');
      Rewrite(F);
      WriteLn(F, Addr);
      Close(F);
      Log('Sending Receipt Confirmation to <'+Addr+'>', True);
    end;

    procedure DoIns(const D: String);
    begin
      Delete(S, I, J);
      Insert(D, S, I);
      Inc(I, Length(D));
    end;

  begin
    FillAddr;
    Assign(F, 'IGATOR.RR$');
    Rewrite(F);
    S := Trim(S);
    WriteLn(F, 'To: ',S);
    DecodeDate(Now, DT.Year, DT.Month, DT.Day);
    DecodeTime(Now, DT.Hour, DT.Min, DT.Sec, SS);
    WriteLn(F, 'Date: ', Copy('SunMonTueWedThuFriSat', W*3+1, 3), ', ', DT.Day,
               ' ', Copy('JanFebMarAprMayJunJulAugSepOctNovDec', DT.Month*3-2, 3), ' ',
               DT.Year, ' ', DT.Hour, ':', SStr(DT.Min, 2, '0'), ':', SStr(DT.Sec, 2, '0'));
    WriteLn(F, 'From: Internet-Fido Gate <', U.Email, '>');
    WriteLn(F, 'Subject: Mail Received');
    WriteLn(F);
    Assign(F1, RRQFile); ClrIO;
    Reset(F1);
    if IOResult <> 0 then
      begin
        WriteLn(F, 'Your message to ', U.Name, ' <', U.Email, '> has been');
        WriteLn(F, 'successfully received by Internet<->FidoNet gate and it will be');
        WriteLn(F, 'transferred to the recipient as soon as possible');
        WriteLn(F);
        WriteLn(F, 'Thank you,');
        WriteLn(F, 'Internet<->FidoNet Gate');
      end else
      begin
        while not EOF(F1) do
          begin
            ReadLn(F1, S);
            I := 1;
            while (I <= Length(S)) do
              begin
                if S[I] = '$' then
                  begin
                    J := 1;
                    while (I+J <= Length(S)) and (S[I+J] in ['A'..'Z','a'..'z']) do Inc(J);
                    D := UpperCase(Copy(S, I+1, J-1)); 
                    if D = 'RNAME' then DoIns(U.Name) else
                      if D = 'REMAIL' then DoIns(U.eMail) else
                        if D = 'RFIDO' then DoIns(U.Addr) else Inc(I, 2);
                  end else Inc(I);
              end;
            WriteLn(F, S);
          end;
        Close(F1);
      end;
    Close(F);
    SendMessage(Smtp, U.Email, 'IGATOR.ADR', 'IGATOR.RR$');
    DeleteFile('IGATOR.ADR');
    DeleteFile('IGATOR.RR$');
  end;

  procedure StoreStr;
    var I,J,K: Integer;
        A: String[250];
        BB: Boolean;
  begin
    if Msg then
      begin
        case E of
         etBase64: begin
                     if BRest <> '' then begin Insert(BRest, S, 1); BRest := '' end;
                     J := Length(S) mod 4;
                     if J <> 0 then
                       begin
                         BRest := Copy(S, Length(S) - J + 1, J);
                         S := Copy(S, 1, Length(S)-J);
                       end;
                     A := S;
                     J := UE.Decode(S, A[1]);
                     if J > 0 then Write(T, Copy(A, 1, J));
                   end;
         etQuoted: if S = '' then WriteLn(T) else
                     begin
                       J := Length(S);
                       BB := S[J] <> '=';
                       if not BB then Dec(J);
                       I := 1; A := S; K := 1;
                       while I <= J do
                         begin
                           if (S[I] = '=') and (I < J-1) then
                             begin
                               A[K] := FromHex(S[I+1], S[I+2]);
                               Inc(I, 2);
                             end else A[K] := S[I];
                           Inc(K); Inc(I);
                         end;
                       Write(T, Copy(A, 1, K-1));
                       if BB then WriteLn(T);
                     end
           else WriteLn(T, S);
        end;
      end
      else
        begin
          if U.WriteInfo then WriteLn(T, S);
          I := Pos(':', S); A := UpperCase(Copy(S, 1, I));
          if A = 'CONTENT-TYPE:' then
            begin
              A := Trim(UpperCase(Copy(S, Length(A)+1, Length(S))));
              Tx := Copy(A, 1, 4) = 'TEXT';
            end else
          if A = 'CONTENT-TRANSFER-ENCODING:' then
            begin
              A := Trim(UpperCase(Copy(S, Length(A)+1, Length(S))));
              if A = 'BASE64' then E := etBase64 else
                if A = 'QUOTED-PRINTABLE' then E := etQuoted else E := etNone;
            end else
          if A = 'SUBJECT:' then
            begin
              if Pos('=?', S) > 0 then
                begin
                  S := DecodeKludge(S);
                end else if U.XTable <> nil then S := U.XTable.XString(S);
              M_Subj := Trim(Copy(S, 9, 255));
            end else
          if A = 'DATE:' then
            begin M_Date := Trim(Copy(S, 6, 255)) end else
          if A = 'REPLY-TO:' then
            begin
              S1 := Trim(Copy(S, 10, 255));
              if S1[1] = '"' then
                begin
                  Delete(S1, 1, 1);
                  I := PosChar('"', S1); if I = 0 then I := Length(S1)+1;
                  if M_From = '' then M_From := Copy(S1, 1, I-1); Delete(S1, 1, I); S1 := Trim(S1);
                  CutBraces(S1);
                  M_Reply := S1;
                end else
              if S1[Length(S1)] = ')' then
                begin
                  I := PosChar('(', S1); if I = 0 then I := Length(S1);
                  if M_From = '' then M_From := Copy(S1, I+1, Length(S1)-I-1); Delete(S1, I, Length(S1)-I+1); S1 := Trim(S1);
                  CutBraces(S1);
                  M_Reply := S1;
                end else
                begin
                  I := PosChar('<', S1); S1 := Trim(S1);
                  if I = 0 then
                    begin
                      M_Reply := Trim(S1);
                      if M_From = '' then M_From := M_Reply;
                    end else
                    begin
                      if M_From = '' then M_From := Copy(S1, 1, I-1); Delete(S1, 1, I);
                      M_From := Trim(M_From); S1 := Trim(S1);
                      CutBraces(S1);
                      M_Reply := S1;
                    end;
                end;
            end else
          if A = 'RETURN-RECEIPT-TO:' then
            begin
              Delete(S, 1, 18);
              SendRRQ(S);
            end else
          if A = 'FROM:' then
            begin
              S1 := TrimLeft(Copy(S, 6, 255));
              if S1[1] = '"' then
                begin
                  Delete(S1, 1, 1);
                  I := PosChar('"', S1); if I = 0 then I := Length(S1)+1;
                  M_From := Copy(S1, 1, I-1); Delete(S1, 1, I); S1 := Trim(S1);
                  CutBraces(S1);
                  if M_Reply = '' then M_Reply := S1;
                end else
                if S1[Length(S1)] = ')' then
                begin
                  I := PosChar('(', S1); if I = 0 then I := Length(S1);
                  M_From := Copy(S1, I+1, Length(S1)-I-1); Delete(S1, I, Length(S1)-I+1); S1 := Trim(S1);
                  CutBraces(S1);
                  if M_Reply = '' then M_Reply := S1;
                end else
                begin
                  I := PosChar('<', S1);
                  if I = 0 then
                    begin
                      M_From := Trim(S1);
                      if M_Reply = '' then M_Reply := M_From;
                    end else
                    begin
                      M_From := Trim(Copy(S1, 1, I-1)); Delete(S1, 1, I); S1 := Trim(S1);
                      CutBraces(S1);
                      if M_Reply = '' then M_Reply := S1;
                    end;
                end;
            end;
          if S = '' then
            begin
              Msg := True;
              if not U.WriteInfo then
                 begin
                   if M_From <> '' then
                   Write(T,   '@FROM: ', M_From);
                   if M_Reply <> '' then WriteLn(T, ' <', M_Reply, '>')
                     else WriteLn(T, ' <Address unknown>');
                   if M_Date <> '' then
                     WriteLn(T, '@DATE: ', M_Date);
                   WriteLn(T, '@TO: ', U.Name, '<', U.eMail, '>');
                   WriteLn(T);
                 end;
            end;
        end;
    S := '';
  end;

  function GetDateTime: String;
    var Year, Month, Day, DW: Word;
        HH, MM, SS: Word;
  begin
    DecodeDate(Now, Year, Month, Day);
    DecodeTime(Now, HH, MM, SS, DW);
    GetDateTime := SStr(Day,2,'0')+' '+Copy('JanFebMarAprMayJunJulAugSepOctNovDec', Month*3-2, 3)+
                   SStr(Year mod 100, 2, '0')+'  '+SStr(HH,2,'0')+':'+SStr(MM,2,'0')+':'+SStr(SS,2,'0');
  end;

  function Token(N: Integer): String;
    var A: String[10];
        I: Integer;
  begin
    A := '';
    I := 1;
    while (I <= Length(S)) and (S[I] <> ' ') do Inc(I);
    A := Copy(S, 1, I-1); Delete(S, 1, I);
    if N = 0 then Token := A
      else Token := Copy(A, Length(A)-N+1, N);
  end;

  procedure PutMsgId;
    var L: LongInt;
  begin
    L := DateTimeToFileDate(Now);
    S := #1'MSGID: '+MainAddr+' '+Hex8(L)+#13#10;
    F.Write(S[1], Length(S));
  end;


begin
  F := TDosStream.Create(FName, stRead);
  if F.Status <> stOK then
    begin
      MessageBeep(MB_ICONEXCLAMATION);
      Log('WARNING: Could not find message '+FName, True);
      F.Free; Exit;
    end;
  Zone := M_Zone; Net := M_Net; Node := M_Node; Point := 0;
  ParseAddress(U.Addr, Zone, Net, Node, Point);
  Assign(T, 'IGATOR.$$$');
  GetMem(BF, 4096);
  GetMem(B, 4096); ClrIO;
  Rewrite(T); SetTextBuf(T, BF^, 4096);
  L := F.GetSize;
  S := '';
  M_From := '';
  M_Subj := '';
  M_Reply := '';
  Msg := False;
  while F.GetPos < L do
    begin
      if L - F.GetPos < 4096 then BS := L - F.GetPos
                             else BS := 4096;
      F.Read(B^, BS);
      I := 0;
      repeat
        case B^[I] of
          10: StoreStr;
          13: if (I < BS-1) then
                begin
                  if (B^[I+1] = 10) then Inc(I);
                  StoreStr;
                end else if (BS < 4096) then Break
                      else begin
                             F.Read(C, 1);
                             if C <> #10 then F.Seek(F.GetPos-1);
                             Break;
                           end;
           else begin
                  if Length(S) > 150 then
                    begin
                      J := Length(S);
                      While (J > 2) and (S[J] <> ' ') do Dec(J);
                      S1 := Copy(S, J+1, 255);
                      SetLength(S, J);
                      StoreStr;
                      S := S1;
                    end;
                  AddStr(S, Char(B^[I]));
                end;
        end;
        Inc(I);
      until I >= BS;
    end;
  StoreStr;
  Close(T); F.Free;
  {FreeMem(BF, 4096); FreeMem(B, 4096);}
  {DD.Init('IGATOR.$$$', stOpenRead);}
  FillChar(H, SizeOf(H), 0);
  if M_Reply <> '' then M_From := M_Reply;
  if M_From = '' then M_From := '@UUCP';
  Move(M_From[1], H.F_Name, Length(M_From));
  S := Copy(U.Name, 1, 35);
  Move(S[1], H.T_Name, Length(S));
  Move(M_Subj[1], H.Subj, Length(M_Subj));
  if M_Date <> '' then
    begin
      if M_Date[4] = ',' then Delete(M_Date, 1, 4);
      M_Date := Trim(M_Date); S := M_Date;
      M_Date := Token(0)+' '+Token(0)+' '+Token(2)+'  '+Token(0);
      M_Date := Copy(M_Date, 1, 19);
    end else M_Date := GetDateTime;
  Move(M_Date[1], H.DateTime, Length(M_Date));
  H.DestZone  := U._Zone;
  H.DestNet   := U._Net;
  H.DestNode  := U._Node;
  H.DestPoint := U._Point;
  H.OrigZone  := M_Zone;
  H.OrigNet   := M_Net;
  H.OrigNode  := M_Node;
  H.OrigPoint := M_Point;
  H.Attr      := 256 + 128;  {Local + Kill/sent}
  repeat
    Inc(MaxMsg);
    F := TDosStream.Create(NetPath+ItoS(MaxMsg)+'.MSG', stOpen);
    if F.Status <> stOK then
      begin
        F.Free;
        F := TDosStream.Create(NetPath+ItoS(MaxMsg)+'.MSG', stCreate);
        if F.Status = stOK then Break;
      end;
    F.Free;
  until False;
  F.Write(H, SizeOf(H));
  S := #1'INTL '+MakeAddress(U._Zone, U._Net, U._Node, 0)+' '+
                 MakeAddress(M_Zone, M_Net, M_Node, 0)+#13#10;
  F.Write(S[1], Length(S));
  PutMsgId;
  if M_Point <> 0 then
    begin S := #1'FMPT '+ItoS(M_Point)+#13#10; F.Write(S[1], Length(S)); end;
  if U._Point <> 0 then
    begin S := #1'TOPT '+ItoS(U._Point)+#13#10; F.Write(S[1], Length(S)); end;
  if M_Reply <> '' then
    begin
      S := #1'REPLYADDR: '+M_Reply+#13#10#1'REPLY-TO: UUCP'#13#10;
      F.Write(S[1], Length(S));
    end;
  U.XinFile('IGATOR.$$$');
  DD := TDosStream.Create('IGATOR.$$$', stRead);
  Inc(U.BytesIn, DD.GetSize);
  Inc(U.MsgIn);
  U.Modified := True;
  F.CopyFrom(DD, DD.GetSize);
  DD.Free;
  S := '---'#13#10#0;
  F.Write(S[1], Length(S));
  F.Free;
  DeleteFile('IGATOR.$$$');
  if not DeleteFile(FName) then
      Log('WARNING: Could not delete POP message '+FName, True);
end;


procedure ScanBoxes;
  var NU: Integer;

  procedure DoScan(U: TUser); far;
    var D: String[255];
        SR: TSearchRec;
        F: TDosStream;
        I,J,K,L: LongInt;
        PC: TStringList;
        H: TIdxRec;

     procedure DoSend(FName: String); far;
     begin
       SendNetmail(FName, U);
     end;

  begin
    Inc(NU);
    Write(#13, NU, '  ');
    if U.Home = '' then Exit;
    D := U.Home; if D[Length(D)] <> '\' then D := D + '\';
    F := TDosStream.Create(D+'mailbox.idx', stOpen);
    if F.Status <> stOK then begin F.Free; Exit end;
    F.Read(I, 4);
    F.Read(J, 4);
    if J > 0 then
      begin
        Write(#13);
        Log(#13+ItoS(J)+' new messages for '+U.Name+', '+U.Addr, True);
        F.Read(L, 4);
        PC := TStringList.Create;
        for K := 1 to J do
          begin
            F.Read(H, SizeOf(H));
            if F.Status <> stOK then Break;
            D := Copy(H.Name, 1, 254)+#0;
            D[0] := Char(Pos(#0, D)-1);
            if D <> '' then PC.Add(D);
          end;
        J := 0;
        F.Seek(4); F.Write(J, 4); F.Write(L, 4); F.Truncate;
        F.Free;
        for K := 0 to PC.Count-1 do DoSend(PC[K]);
        PC.Free;
      end else F.Free;
  end;

  var UCount: Integer;

begin
  NU := 0;
  for UCount := 0 to Users.Count-1 do
     DoScan(Users[UCount]);
end;


end.
