//////////////////////////////////////////////////////////////////////////
//
//  IGATOR Copyright (C) 1997-98 RIT Research Labs
//
//  This programs is free for commercial and non-commercial use as long as
//  the following conditions are aheared to.
//
//  Copyright remains RIT Research Labs, and as such any Copyright notices
//  in the code are not to be removed. If this package is used in a
//  product, RIT Research Labs should be given attribution as the RIT Research
//  Labs of the parts of the library used. This can be in the form of a textual
//  message at program startup or in documentation (online or textual)
//  provided with the package.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//
//  1. Redistributions of source code must retain the copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. All advertising materials mentioning features or use of this software
//     must display the following acknowledgement:
//     "Based on IGATOR by RIT Research Labs."
//
//  THIS SOFTWARE IS PROVIDED BY RIT RESEARCH LABS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//  DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
//  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
//  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
//  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
//  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
//  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//  The licence and distribution terms for any publically available
//  version or derivative of this code cannot be changed. i.e. this code
//  cannot simply be copied and put under another distribution licence
//  (including the GNU Public Licence).
//
//////////////////////////////////////////////////////////////////////////

{$V-}
unit _UUE;

interface

const
      MMaxChars = 120;


type
    Str255 = String[255];
    TByteTable = Array[Char] of Byte;
    TBase64Table = (bsBase64, bsUUE, bsXXE);
    TUUStr = String[MMaxChars];

    TMimeCoder = object
      Table: string;
      MaxChars: Byte;
      Pad: Char;
      XChars: TByteTable;
      constructor Create(AType: TBase64Table);
      procedure   InitTable;
      function    Encode(var Buf; N: byte) : string;
      function    Decode(const S : String; var Buf): Integer;
    end;


function DecodeKludge(const AKludge: String): String;
function FromHex(C1, C2: Char): Char;

implementation
uses Config, SysUtils;

procedure AddStr(var S: Str255; C: Char);
begin
  Inc(S[0]);
  S[Length(S)] := C;
end;

constructor TMimeCoder.Create;
begin
  case AType of
    bsBase64: begin
                Table:='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                MaxChars := 57;
                Pad := '=';
              end;
    bsUUE: begin
             Table := ' !"#$%&''()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_'#0;
             Pad := '`';
             MaxChars := 45;
           end;
    bsXXE: begin
             Table := '+-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'#0;
             Pad := '+';
             MaxChars := 45;
           end;
  end;
  InitTable;
end;

procedure TMimeCoder.InitTable;
  var I: Integer;
begin
  FillChar(XChars, SizeOf(XChars), 65);
  for I := 1 to Length(Table) do XChars[Table[I]] := I-1;
  XChars[Pad] := 0;
end;

function TMimeCoder.Encode;
var
  B: Array[0..MMaxChars] of Byte;
  I,J,K,L: Word;
  S: Str255;
begin
  FillChar(B, SizeOf(B), 0);
  Move(Buf, B, N);
  L := N;
  if L mod 3 <> 0 then Inc(L, 3);
  S[0] := Char((L div 3) * 4);
  FillChar(S[1], Length(S), Pad);
  I := 0; J := 0; K := 1;
  while I < N do
    begin
      S[K]   := Table[1+(B[I] shr 2)];
      S[K+1] := Table[1+(((B[I] and $03) shl 4) or (B[I+1] shr 4))];
      if I+1 >= N then Break;
      S[K+2] := Table[1+(((B[I+1] and $0F) shl 2) or (B[I+2] shr 6))];
      if I+2 >= N then Break;
      S[K+3] := Table[1+(B[I+2] and $3F)];
      Inc(I, 3); Inc(K, 4);
    end;
  Result := S;
end;

function TMimeCoder.Decode;
  var B: array [0..MMaxChars] of Byte absolute Buf;
      A: array [0..MMaxChars] of Byte;
      I,J,K: Integer;
begin
  if S = '' then begin Result := 0; Exit end;
  Result := -1;
  FillChar(A, SizeOf(A), 0);
  for I := 0 to Length(S)-1 do
    begin
      A[I] := XChars[S[I+1]];
      if A[I] > 64 then Exit;
    end;
  J := Length(S);
  if (Pad <> '`') and (Pad <> '+') then
    while S[J] = Pad do Dec(J);
  Result := (J div 4) * 3 + (J mod 4);
  I := 0; K := 0;
  while I < J do
    begin
      B[K] := (A[I] shl 2) or (A[I+1] shr 4);
      B[K+1] := (A[I+1] shl 4) or (A[I+2] shr 2);
      B[K+2] := (A[I+2] shl 6) or (A[I+3]);
      Inc(I, 4); Inc(K, 3);
    end;
end;


function FromHex(C1, C2: Char): Char;
  var I1, I2: Byte;
begin
  case C1 of
    '0'..'9': I1 := Byte(C1)-48;
    'A'..'F': I1 := Byte(C1)-55;
    'a'..'f': I1 := Byte(C1)-87;
      else I1 := 0;
  end;
  case C2 of
    '0'..'9': I2 := Byte(C2)-48;
    'A'..'F': I2 := Byte(C2)-55;
    'a'..'f': I2 := Byte(C2)-87;
      else I2 := 0;
  end;
  Result := Char(I1 shl 4 + I2);
end;


function DecodeKludge(const AKludge: String): String;
  var S,A: String[255];
      CS: String[100];
      I,J,K,C: Integer;
      CC: Char;
      U: TMimeCoder;
      X: TXLT;

  procedure CvtQuotes;
    var I: Integer;
  begin
    I := 1;
    while I <= Length(A) do
      begin
        if A[I] = '=' then
        begin
          A[I] := FromHex(A[I+1], A[I+2]);
          Delete(A, I+1, 2);
        end;
        Inc(I);
      end;
  end;

  procedure Cvt64;
    var S: String;
        I,J: Integer;
  begin
    S := A;
    J := U.Decode(A, S[1]);
    if J > 0 then
      begin
        I := 1;
        while (I <= J) and (S[I] <> #0) do Inc(I);
        if I > J then I := J else Dec(I);
        A := Copy(S, 1, I);
      end else A := '';
    S := '';
  end;

begin
  U.Create(bsBase64);
  S := AKludge;
  repeat
    I := Pos('=?', S);
    if I > 0 then
      begin
        J := I; C := 0;
        while J < Length(S) do
          begin
            if S[J] = '?' then
              begin
                Inc(C);
                if (C = 4) then
                  begin
                   if (S[J+1] <> '=') then C := 3;
                   Break;
                  end;
              end;
            Inc(J);
          end;
        if C = 4 then
          begin
            A := Copy(S, I+2, J-I-2);
            Delete(S, I, J-I+2);
            J := Pos('?', A);
            {!!!}
            CS := Trim(Copy(A, 1, J-1));
            Inc(J);
            CC := UpCase(A[J]);
            while (J < Length(A)) and (A[J] <> '?') do Inc(J);
            Delete(A, 1, J);
            if CC = 'Q' then CvtQuotes
                        else Cvt64;
            X := FindXlat(CS, True);
            if X <> nil then A := X.XString(A);
            Insert(A, S, I);
            A := '';
          end else S[I] := #1;
      end;
  until I = 0;
  repeat
    I := Pos(#1'?', S);
    if I > 0 then S[I] := '=';
  until I = 0;
  Result := S;
end;




end.
