//////////////////////////////////////////////////////////////////////////
//
//  IGATOR Copyright (C) 1997-98 RIT Research Labs
//
//  This programs is free for commercial and non-commercial use as long as
//  the following conditions are aheared to.
//
//  Copyright remains RIT Research Labs, and as such any Copyright notices
//  in the code are not to be removed. If this package is used in a
//  product, RIT Research Labs should be given attribution as the RIT Research
//  Labs of the parts of the library used. This can be in the form of a textual
//  message at program startup or in documentation (online or textual)
//  provided with the package.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//
//  1. Redistributions of source code must retain the copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. All advertising materials mentioning features or use of this software
//     must display the following acknowledgement:
//     "Based on IGATOR by RIT Research Labs."
//
//  THIS SOFTWARE IS PROVIDED BY RIT RESEARCH LABS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//  DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
//  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
//  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
//  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
//  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
//  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//  The licence and distribution terms for any publically available
//  version or derivative of this code cannot be changed. i.e. this code
//  cannot simply be copied and put under another distribution licence
//  (including the GNU Public Licence).
//
//////////////////////////////////////////////////////////////////////////

unit XReader;

interface
uses Windows, Classes;


const
  TextReaderBufSize = $4000;

type
  TTextReaderBuf = array[0..TextReaderBufSize-1] of Char;

  TTextReader = class;

  TTextReader = class
    Eof: Boolean;
    FileSz,
    StartPos,
    SPosition,
    FilePos: Integer;
    _XC: Byte;
    function GetStr: string;
    function GetBuf(var ABuf; Size: Integer): Integer;
    destructor Destroy; override;
  private
    OwnsStream: Boolean;
    Stream: TStream;
    BufSz: Integer;
    BufPos: Integer;
    Buf: TTextReaderBuf;
    Skip1: Boolean;
  end;

function CreateTextReaderByStream(Stream: TStream): TTextReader;
function CreateTextReaderByStreamSz(Stream: TStream; Sz: Integer): TTextReader;
function CreateTextReaderByStreamXor(Stream: TStream; AXor: Byte): TTextReader;
function CreateTextReaderByStreamSzXor(Stream: TStream; Sz: Integer; AXOR: Byte): TTextReader;

implementation uses Utils, SysUtils;

function Min(A,B: Integer): Integer;
begin
  if A < B then Result := A else Result := B;
end;

procedure XorMem(var B; X: Byte; Len: Integer);
  var I: Integer;
      A: Array [0..10000] of Byte absolute B;
begin
  if X <> 0 then for I := 0 to Len-1 do A[I] := A[I] xor X;
end;


function CreateTextReaderByStreamSzXor;
var
  FileSz: Integer;
begin
  Result := nil;
  if Stream = nil then Exit;
  Result := TTextReader.Create;
  Result._XC := AXor;
  Result.StartPos := Stream.Position;
  Result.SPosition := Result.StartPos;
  if Sz >= 0 then FileSz := Sz else
  begin
    FileSz := Stream.Size-Result.StartPos;
  end;
  Result.FileSz := FileSz;
  Result.Stream := Stream;
  if FileSz = 0 then Result.Eof := True else
  begin
    Result.BufSz := Stream.Read(Result.Buf, Min(FileSz, TextReaderBufSize));
    if Result.BufSz <= 0 then begin Result.Free; Result := nil end else
    begin
      Inc(Result.SPosition, Result.BufSz);
      if Result._XC <> 0 then XorMem(Result.Buf, Result._XC, Result.BufSz);
    end;
  end;
end;

function CreateTextReaderByStreamSz;
begin
  Result := CreateTextReaderByStreamSzXor(Stream, Sz, 0);
end;


function CreateTextReaderByStream;
begin
  Result := CreateTextReaderByStreamXor(Stream, 0);
end;

function CreateTextReaderByStreamXor;
begin
  Result := CreateTextReaderByStreamSzXor(Stream, -1, AXor);
end;

function TTextReader.GetBuf(var ABuf; Size: Integer): Integer;
var
  BufBeg: Integer;
  XX: Integer;
  Was: Boolean;

procedure AddBuf(D: Integer);
var
  Grow: Integer;
  p: PByteArray;
begin
  Grow := Min((BufPos - BufBeg) - D - Byte(Was), Size - Result);
  if Grow = 0 then Exit;
  p := @ABuf;
  Move(Buf[BufBeg], p^[Result], Grow);
  Inc(Result, Grow);
end;

var
  PrevC, C: Char;

begin
  Result := 0; if Eof then Exit; PrevC := #0;
  BufBeg := BufPos; Was := False;
  repeat
    if BufPos = BufSz then
    begin
      AddBuf(0);
      XX := StartPos+FileSz-SPosition;
      if XX > 0 then
      begin
        if XX > TextReaderBufSize then XX := TextReaderBufSize;
        BufSz := Stream.Read(Buf, XX);
        Inc(SPosition, BufSz);
        if _XC <> 0 then XorMem(Buf, _XC, XX);
      end;
      if (BufSz <= 0) or (XX <= 0) then
      begin
        Eof := True;
        Break;
      end;
      BufPos := 0;
      BufBeg := 0;
      if Was then begin Skip1 := True; Break end;
    end;
    C := Buf[BufPos]; Inc(BufPos); Inc(FilePos);
    case C of
      #10, #13 :
        begin
          if Skip1 then
          begin
            BufBeg := BufPos;
            Skip1 := False; Continue;
          end;
          if Was then
          begin
            AddBuf(1);
            Dec(BufPos,Integer(PrevC=C));
            Dec(FilePos,Integer(PrevC=C));
            Break;
          end else Was := True;
          PrevC := C;
        end;
      else
      begin
        if Was then
        begin
          AddBuf(1);
          Dec(BufPos);
          Dec(FilePos);
          Break;
        end;
        Skip1 := False
      end;
    end;
  until False;
end;



function TTextReader.GetStr: string;
var
  BufBeg: Integer;
  XX: Integer;
  Was: Boolean;

procedure AddStr(var s: string; D: Integer);
var
  Grow: Integer;
  z: string;
  p: Pointer;
  pc: PChar absolute p;
  ss: shortstring;
begin
  Grow := (BufPos - BufBeg) - D - Byte(Was);
  if Grow > 0 then
  begin
    if s = '' then
    begin
      p := @Buf[BufBeg];
      SetString(s, pc, Grow);
    end else
    begin
      if Grow < 255 then
      begin
        ss[0] := Char(Grow);
        Move(Buf[BufBeg], ss[1], Grow);
        s := s + ss;
      end else
      begin
        p := @Buf[BufBeg];
        SetString(z, pc, Grow);
        s := s + z;
      end;
    end;
  end;
end;

var
  PrevC, C: Char;

begin
  Result := ''; if Eof then Exit; PrevC := #0;
  BufBeg := BufPos; Was := False;
  repeat
    if BufPos = BufSz then
    begin
      AddStr(Result, 0);
      XX := StartPos+FileSz-SPosition;
      if XX > 0 then
      begin
        if XX > TextReaderBufSize then XX := TextReaderBufSize;
        BufSz := Stream.Read(Buf, XX);
        Inc(SPosition, BufSz);
        if _XC <> 0 then XorMem(Buf, _XC, XX);
      end;
      if (BufSz <= 0) or (XX <= 0) then
      begin
        Eof := True;
        Break;
      end;
      BufPos := 0;
      BufBeg := 0;
      if Was then begin Skip1 := True; Break end;
    end;
    C := Buf[BufPos]; Inc(BufPos); Inc(FilePos);
    case C of
      #10, #13 :
        begin
          if Skip1 then
          begin
            BufBeg := BufPos;
            Skip1 := False; Continue;
          end;
          if Was then
          begin
            AddStr(Result, 1);
            Dec(BufPos,Integer(PrevC=C));
            Dec(FilePos,Integer(PrevC=C));
            Break;
          end else Was := True;
          PrevC := C;
        end;
      else
      begin
        if Was then
        begin
          AddStr(Result, 1);
          Dec(BufPos);
          Dec(FilePos);
          Break;
        end;
        Skip1 := False
      end;
    end;
  until False;
end;

destructor TTextReader.Destroy;
begin
  if OwnsStream then Stream.Free;
  inherited Destroy;
end;



end.