/*
 *  srif.c -- Create flags or run external programs on mail events
 *
 *  srif.c is a part of binkd project
 *
 *  Copyright (C) 1996-1997  Dima Maloff, 5047/13
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. See COPYING.
 */

/*
 * $Id: srif.c,v 1.4 1997/06/16 05:40:33 mff Exp mff $
 *
 * $Log: srif.c,v $
 * Revision 1.4  1997/06/16  05:40:33  mff
 * Binkd will not complain about missing .rsp files when running
 * programms with "exec" statement without using of *S macro.
 *
 * Revision 1.3  1997/03/28  06:12:48  mff
 * Changes to support SRIF: + evt_run(), etc.
 *
 * Revision 1.2  1997/02/09  04:17:30  mff
 * Removed error msgs
 *
 * Revision 1.1  1997/01/08  03:57:54  mff
 * Initial revision
 *
 */

#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>

#include "Config.h"
#include "ftnaddr.h"
#include "ftnq.h"
#include "tools.h"
#include "srif.h"
#include "run.h"
#include "tools.h"

EVT_FLAG *evt_flags = 0;

/*
 * Tests if filename matches any of EVT_FLAG's patterns.
 */
void evt_test (char *filename0)
{
  EVT_FLAG *curr;
  char filename[MAXPATHLEN + 1];

  strnzcpy (filename, filename0, MAXPATHLEN);
  strlower (filename);
  for (curr = evt_flags; curr; curr = curr->next)
  {
    if (curr->path && pmatch (curr->pattern, filename))
    {
      if (curr->imm)
      {
	Log (4, "got %s, creating %s", curr->pattern, curr->path);
	create_empty_sem_file (curr->path);
      }
      else
      {
	++curr->flag;
	break;
      }
    }
  }
}

/*
 * Sets flags for all matched with evt_test events
 */
void evt_set (void)
{
  EVT_FLAG *curr;

  for (curr = evt_flags; curr; curr = curr->next)
  {
    if (curr->flag > 0)
    {
      Log (4, "got %s (%i), creating %s",
	   curr->pattern, curr->flag, curr->path);
      curr->flag = 0;
      create_empty_sem_file (curr->path);
    }
  }
}

/* Makes SRIF request and SRIF response names from FTN address of a node */
static int mksrifpaths (FTN_ADDR *fa, char *srf, char *rsp)
{
  ftnaddress_to_filename (srf, fa);
  if (*srf)
  {
    strnzcpy (rsp, srf, MAXPATHLEN);
    strnzcat (srf, ".srf", MAXPATHLEN);
    strnzcat (rsp, ".rsp", MAXPATHLEN);
    return 1;
  }
  else
    return 0;
}

static int srif_fill (char *path, FTN_ADDR *fa, int nfa,
		       char *req, char *rsp,
		       int prot, int listed, char *peer_name)
{
  FILE *out;
  int i;

  if ((out = fopen (path, "w")) != 0)
  {
    fprintf (out, "Sysop sysop\n");
    for (i = 0; i < nfa; ++i)
    {
      char adr[FTN_ADDR_SZ + 1];

      ftnaddress_to_str (adr, fa + i);
      fprintf (out, "AKA %s\n", adr);
    }
    fprintf (out, "Baud 115200\n");
    fprintf (out, "Time -1\n");
    fprintf (out, "RequestList %s\n", req);
    fprintf (out, "ResponseList %s\n", rsp);
    fprintf (out, "RemoteStatus %s\n", prot ? "PROTECTED" : "UNPROTECTED");
    fprintf (out, "SystemStatus %s\n", listed ? "LISTED" : "UNLISTED");
    fprintf (out, "CallerID %s\n", peer_name);
    fprintf (out, "SessionType OTHER\n");
    fclose (out);
    return 1;
  }
  return 0;
}

static FTNQ *parse_response (FTNQ *q, char *rsp, FTN_ADDR *fa)
{
  FILE *in = fopen (rsp, "r");

  if (in)
  {
    char buf[MAXPATHLEN + 1];
    int i;

    while (!feof (in))
    {
      if (!fgets (buf, MAXPATHLEN, in))
	break;
      for (i = 0; i < sizeof (buf) - 1 && !isspace (buf[i]); ++i);
      buf[i] = 0;
      switch (*buf)
	{
	  case '=':
	    q = q_add_file (q, buf + 1, fa, 'h', 'd', 0);
	    break;
	  case '+':
	    q = q_add_file (q, buf + 1, fa, 'h', 0, 0);
	    break;
	  case '-':
	    q = q_add_file (q, buf + 1, fa, 'h', 'a', 0);
	    break;
	  default:
	    break;
	}
    }
    fclose (in);
  }
  else
    Log (1, "parse_response: %s: %s", rsp, strerror (errno));
  return q;
}

/*
 * Runs external programs using S.R.I.F. interface
 * if the name matches one of our "exec"'s
 */
FTNQ *evt_run (FTNQ *q, char *filename0,
	        FTN_ADDR *fa, int nfa,
	        int prot, int listed, char *peer_name)
{
  EVT_FLAG *curr;
  char filename[MAXPATHLEN + 1];

  strnzcpy (filename, filename0, MAXPATHLEN);
  strlower (filename);
  for (curr = evt_flags; curr; curr = curr->next)
  {
    if (curr->command && pmatch (curr->pattern, filename))
    {
      char srf[MAXPATHLEN + 1], rsp[MAXPATHLEN + 1];

      if (strstr (curr->command, "*S") || strstr (curr->command, "*s"))
      {
	if (mksrifpaths (fa, srf, rsp))
	{
	  char *w = ed (curr->command, "*S", srf);

	  if (srif_fill (srf, fa, nfa, filename0, rsp, prot, listed, peer_name))
	  {
	    run (w);
	  }
	  else
	    Log (1, "srif_fill: error");
	  free (w);
	  q = parse_response (q, rsp, fa);
	  delete (srf);
	  delete (rsp);
	}
	else
	  Log (1, "mksrifpaths: error");
      }
      else
	run (curr->command);
    }
  }
  return q;
}
