#include "alarm_applet.h"





void create_props_window(Alarm* a)
{
   GtkWidget* window;
   GtkWidget* box;
   GtkWidget* hbox;
   GtkWidget* frame;
   gchar* text;
   
  
   window = gnome_dialog_new("Alarm Properties",
							 GNOME_STOCK_BUTTON_OK,
							 NULL);
   gnome_dialog_button_connect_object(GNOME_DIALOG(window),
									  0, GTK_SIGNAL_FUNC(gtk_widget_destroy),
									  GTK_OBJECT(window));
   box = gtk_vbox_new(FALSE, FALSE);
   
   gtk_container_set_border_width(GTK_CONTAINER(box), 
								  GNOME_PAD_SMALL);
   gtk_window_set_title(GTK_WINDOW(window), "Alarm Properties");
   gtk_signal_connect_object(GTK_OBJECT(window), "delete_event",
							 GTK_SIGNAL_FUNC(gtk_widget_destroy),
							 GTK_OBJECT(window));
   
   hbox = gtk_hbox_new(FALSE, FALSE);
   gtk_container_set_border_width(GTK_CONTAINER(hbox), GNOME_PAD_SMALL);
   gtk_box_pack_start_defaults(GTK_BOX(hbox), gtk_label_new("Alarm Time: "));
   text = g_strdup_printf("%.2d:%.2d hrs", a->hour, a->min);
   gtk_box_pack_start_defaults(GTK_BOX(hbox), gtk_label_new(text));
   g_free(text);
   gtk_box_pack_start_defaults(GTK_BOX(box), hbox);
   
   hbox = gtk_hbox_new(FALSE, FALSE);
   gtk_container_set_border_width(GTK_CONTAINER(hbox), GNOME_PAD_SMALL);
   gtk_box_pack_start_defaults(GTK_BOX(hbox), gtk_label_new("Alarm Type: "));
   switch(a->alarm_type)
   {
	  case ALARM_VISUAL:
	  {
		 gtk_box_pack_start_defaults(GTK_BOX(hbox), gtk_label_new("Visual Alarm"));
		 gtk_box_pack_start_defaults(GTK_BOX(box), hbox);
	  }
	  break;
	  case ALARM_SOUND:
	  {
		 gtk_box_pack_start_defaults(GTK_BOX(hbox), gtk_label_new("Sound Alarm"));
		 gtk_box_pack_start_defaults(GTK_BOX(box), hbox);
	  }
	  break;
	  case ALARM_DIALOG:
	  {
		 gtk_box_pack_start_defaults(GTK_BOX(hbox), gtk_label_new("Dialog Alarm"));
		 gtk_box_pack_start_defaults(GTK_BOX(box), hbox);
		 if(a->msg_set)
		 {
			GdkColor white;
			GdkColor black;
			GtkWidget* text_wid;
			GtkWidget* frame;
			
			
			frame = gtk_frame_new("Message");
			gtk_frame_set_label_align(GTK_FRAME(frame), 0.5, 0);
			gtk_container_set_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
			gdk_color_black(gdk_colormap_get_system(), &black);
			gdk_color_white(gdk_colormap_get_system(), &white);
			text_wid = gtk_text_new(NULL, NULL);
			gtk_text_set_editable(GTK_TEXT(text_wid), FALSE);
			gtk_text_insert(GTK_TEXT(text_wid), NULL, &black,
							&white,
							a->msg_txt->str,
							strlen(a->msg_txt->str));
			gtk_container_add(GTK_CONTAINER(frame), text_wid);
			gtk_box_pack_start_defaults(GTK_BOX(box), frame);
		 }
	  }
	  break;
	  case ALARM_COMMAND:
	  {
		 gtk_box_pack_start_defaults(GTK_BOX(hbox), gtk_label_new("Command Alarm"));
		 gtk_box_pack_start_defaults(GTK_BOX(box), hbox);
		 if(a->command_set)
		 {
			GtkWidget* frame;
			GtkWidget* entry = gtk_entry_new();
			
			frame = gtk_frame_new("Command");
			gtk_container_set_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
			gtk_frame_set_label_align(GTK_FRAME(frame), 0.5, 0);
			gtk_entry_set_editable(GTK_ENTRY(entry), FALSE);
			gtk_entry_set_text(GTK_ENTRY(entry), a->command->str);
			gtk_container_add(GTK_CONTAINER(frame), entry);
			gtk_box_pack_start_defaults(GTK_BOX(box), frame);
		 }
	  }
	  break;
   }
  
   if(a->persistant)
   {
	  hbox = gtk_hbox_new(FALSE, FALSE);
	  gtk_container_set_border_width(GTK_CONTAINER(hbox), GNOME_PAD_SMALL);
	  gtk_box_pack_start_defaults(GTK_BOX(hbox), gtk_label_new("Alarm is persistant"));
	  gtk_box_pack_start_defaults(GTK_BOX(box), hbox);
   }
   
   gtk_container_add(GTK_CONTAINER(GNOME_DIALOG(window)->vbox), box);
   gtk_widget_show_all(window);
}


   
void show_alarm_properties(gint id)
{
   if(id < 0)
   {
	  GtkWidget* mess_box;
	  gchar* msg = g_strdup_printf(_("Invalid ID %d\n"), id);
	  show_msg_dialog(msg, FALSE);
	  g_free(msg);
   }
   else
   {
	  Alarm* a;
	  ddebug("Finding alarm id %d\n", id);
	  a = (Alarm*)find_alarm_with_id(id);
	  bdebug(a == NULL, "Couldn't find alarm with id %d\n", id);
	  dump_alarm("show_alarm_properties", a);
	  create_props_window(a);
   }   
}
