#include "alarm_applet.h"


typedef struct _alarm_dialog AlarmDialog;
typedef struct _time Time;

struct _alarm_dialog
{
   GtkWidget* window;
   GtkWidget* add;
   GtkWidget* cancel;
   GtkWidget* msg_box;
   GtkWidget* msg_frame;
   GtkWidget* command_box;
   GtkWidget* sound_select;
   GtkWidget* visual_select;
   GtkWidget* dialog_select;
   GtkWidget* command_select;
   GtkWidget* command_frame;
   GtkWidget* day_select;
   GtkWidget* min_select;
   GtkWidget* hour_select;
   GtkWidget* modal_select;
   GtkWidget* persistant_select;
};

struct _time
{
   int hour;
   int min;
   int day;
};


static AlarmDialog* dialog = NULL;
extern AlarmApplet* alarm_applet;


/* Clean up the dialog */
void destroy_dialog(void)
{
   if(dialog == NULL)
	 return;
   
   gtk_widget_hide(dialog->window);
   gtk_container_foreach(GTK_CONTAINER(dialog->window), 
						 (GtkCallback) gtk_widget_destroy,
						 NULL);
   gtk_widget_destroy(dialog->window);
   g_free(dialog);
   dialog = NULL;
}

   

static void cancel_button_clicked(GtkWidget* w, gpointer cbdata)
{
   destroy_dialog();
}


static Time* get_time_now(void)
{
   time_t now;
   struct tm* local;
   Time* tm;
   
   now = time(0);
   local = localtime(&now);
   
   tm = g_new(Time, 1);
   tm->hour = local->tm_hour;
   tm->min = local->tm_min;
   tm->day = local->tm_mday;
   
   return tm;
}


static void add_button_clicked(GtkWidget* w, gpointer cbdata)
{
   gchar* msg_txt;
   gboolean modal, persistant;
   gint hour, min, day;
   Alarm* alarm;
   
   modal = GTK_TOGGLE_BUTTON(dialog->modal_select)->active;
   persistant = GTK_TOGGLE_BUTTON(dialog->persistant_select)->active;
   hour = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->hour_select));
   min = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dialog->min_select));
   
   /* DEBUG && FIXME */
   day = 1;
   alarm = new_alarm();
   
   alarm->hour = hour;
   alarm->min = min;
   alarm->modal_dialog = modal;
   alarm->persistant = persistant;
   if(GTK_TOGGLE_BUTTON(dialog->dialog_select)->active)
   {
	  alarm->alarm_type = ALARM_DIALOG;
	  msg_txt = gtk_editable_get_chars(GTK_EDITABLE(dialog->msg_box), 0, -1);
	  if(msg_txt)
	  {
		 alarm_set_msg(alarm, msg_txt);
		 g_free(msg_txt);
	  }
   }
   else if(GTK_TOGGLE_BUTTON(dialog->command_select)->active)
   {
	  alarm->alarm_type = ALARM_COMMAND;
	  msg_txt = gtk_editable_get_chars(GTK_EDITABLE(dialog->command_box), 0, -1);
	  if(msg_txt)
	  {
		 fprintf(stderr, "\"%s\"", msg_txt);
		 alarm_set_command(alarm, msg_txt);
		 g_free(msg_txt);
	  }
   }
   else if(GTK_TOGGLE_BUTTON(dialog->sound_select)->active)
	 alarm->alarm_type = ALARM_SOUND;
   else if(GTK_TOGGLE_BUTTON(dialog->visual_select)->active)
	 alarm->alarm_type = ALARM_VISUAL;
   else
	 alarm->alarm_type = ALARM_DIALOG;
      
   add_alarm(alarm);
   destroy_dialog();
}


static void sound_alarm_selected(GtkWidget* w, gpointer cbdata)
{
   if(GTK_TOGGLE_BUTTON(w)->active)
   {
	  if(GTK_WIDGET_VISIBLE(dialog->msg_frame))
		gtk_widget_hide(dialog->msg_frame);
	  if(GTK_WIDGET_VISIBLE(dialog->command_frame))
		gtk_widget_hide(dialog->command_frame);
	  gtk_widget_set_sensitive(dialog->modal_select, FALSE);
   }
}


static void visual_alarm_selected(GtkWidget* w, gpointer cbdata)
{
   if(GTK_TOGGLE_BUTTON(w)->active)
   {
	  if(GTK_WIDGET_VISIBLE(dialog->msg_frame))
		gtk_widget_hide(dialog->msg_frame);
	  if(GTK_WIDGET_VISIBLE(dialog->command_frame))
		gtk_widget_hide(dialog->command_frame);
	  gtk_widget_set_sensitive(dialog->modal_select, FALSE);
   }
}



static void dialog_alarm_selected(GtkWidget* w, gpointer cbdata)
{
   if(GTK_TOGGLE_BUTTON(w)->active)
   {
	  if(!GTK_WIDGET_VISIBLE(dialog->msg_frame))
		 gtk_widget_show(dialog->msg_frame);
	  if(GTK_WIDGET_VISIBLE(dialog->command_frame))
		gtk_widget_hide(dialog->command_frame);
	  gtk_widget_set_sensitive(dialog->modal_select, TRUE);
   }
}



static void command_alarm_selected(GtkWidget* w, gpointer cbdata)
{
   if(GTK_TOGGLE_BUTTON(w)->active)
   {
	  if(!GTK_WIDGET_VISIBLE(dialog->command_frame))
		gtk_widget_show(dialog->command_frame);
	  if(GTK_WIDGET_VISIBLE(dialog->msg_frame))
		gtk_widget_hide(dialog->msg_frame);
	  gtk_widget_set_sensitive(dialog->modal_select, FALSE);
   } 
}


void show_add_alarm_dialog(void)
{
   GtkWidget* vbox;
   GtkWidget* hbox1;
   GtkWidget* frame1;
   GtkWidget* hbox4;
   GtkWidget* frame4;
   GtkWidget* hbox2;
   GtkWidget* frame2;
   GtkWidget* hbox3;
   GtkWidget* frame3;

   
   
   if(dialog != NULL)
	 return;
   
   dialog = g_new(AlarmDialog, 1);
   
   dialog->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   
   gtk_window_set_title(GTK_WINDOW(dialog->window), _("Add an Alarm"));
   gtk_window_set_policy(GTK_WINDOW(dialog->window), TRUE, TRUE, TRUE);
   gtk_signal_connect(GTK_OBJECT(dialog->window), "delete_event",
					  GTK_SIGNAL_FUNC(cancel_button_clicked), NULL);
   
   vbox = gtk_vbox_new(FALSE, FALSE);
   gtk_container_add(GTK_CONTAINER(dialog->window), vbox);
   
   /* Alarm type */
   hbox1 = gtk_hbox_new(FALSE, FALSE);
   frame1 = gtk_frame_new(_("Alarm Type"));
   gtk_container_set_border_width(GTK_CONTAINER(frame1), GNOME_PAD_SMALL);
   gtk_frame_set_label_align(GTK_FRAME(frame1), 0.5, 0);
   gtk_container_add(GTK_CONTAINER(frame1), hbox1);
   
   dialog->persistant_select = gtk_check_button_new_with_label(_("Persistant Alarm"));
   dialog->modal_select = gtk_check_button_new_with_label(_("Modal Dialog Window"));
   dialog->dialog_select = gtk_radio_button_new_with_label(NULL, _("Dialog Alarm"));
   gtk_signal_connect(GTK_OBJECT(dialog->dialog_select), "toggled",
					  GTK_SIGNAL_FUNC(dialog_alarm_selected), NULL);
   dialog->visual_select = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(dialog->dialog_select)),
														  _("Visual Alarm"));
   /* If you haven't got the image, no point in having visual alarms */
   if(!alarm_applet->draw_image)
	 gtk_widget_set_sensitive(dialog->visual_select, FALSE);
   gtk_signal_connect(GTK_OBJECT(dialog->visual_select), "toggled",
					  GTK_SIGNAL_FUNC(visual_alarm_selected), NULL);
   dialog->sound_select = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(dialog->dialog_select)),
														 _("Sound Alarm"));
   if(!alarm_applet->with_sound)
	 gtk_widget_set_sensitive(dialog->sound_select, FALSE);
   gtk_signal_connect(GTK_OBJECT(dialog->sound_select), "toggled",
					  GTK_SIGNAL_FUNC(sound_alarm_selected), NULL);
   dialog->command_select = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(dialog->dialog_select)),
															_("Command Alarm"));
   gtk_signal_connect(GTK_OBJECT(dialog->command_select), "toggled",
					  GTK_SIGNAL_FUNC(command_alarm_selected), NULL);
   
   {
	  GtkWidget* but_box;
	  GtkWidget* sel_box;
	  
	  
	  sel_box = gtk_vbox_new(FALSE, FALSE);
	  but_box = gtk_vbox_new(FALSE, FALSE);
	  gtk_box_pack_start_defaults(GTK_BOX(but_box), dialog->dialog_select);
	  gtk_box_pack_start_defaults(GTK_BOX(but_box), dialog->visual_select);
	  gtk_box_pack_start_defaults(GTK_BOX(but_box), dialog->sound_select);
	  gtk_box_pack_start_defaults(GTK_BOX(but_box), dialog->command_select);
	  gtk_box_pack_start_defaults(GTK_BOX(hbox1), but_box);
   
	  
	  gtk_box_pack_start_defaults(GTK_BOX(sel_box), dialog->modal_select);
	  gtk_box_pack_start_defaults(GTK_BOX(sel_box), dialog->persistant_select);
	  gtk_box_pack_start_defaults(GTK_BOX(hbox1), sel_box);
  
   }
   
   /* Day and time settings */
   {
	  GtkAdjustment* hour_adj;
	  GtkAdjustment* min_adj;
	  GtkWidget* vbox_hour;
	  GtkWidget* vbox_min;
	  GtkWidget* hour_label;
	  GtkWidget* min_label;
	  
	  hbox4 = gtk_hbox_new(FALSE, 5);
	  frame4 = gtk_frame_new(_("Time Settings"));
	  gtk_container_set_border_width(GTK_CONTAINER(frame4), GNOME_PAD_SMALL);
	  gtk_frame_set_label_align(GTK_FRAME(frame4), 0.5, 0);
	  gtk_container_add(GTK_CONTAINER(frame4), hbox4);
	  
	  vbox_hour = gtk_vbox_new(FALSE, 0);
	  hour_label = gtk_label_new(_("Hour :"));
	  gtk_box_pack_start_defaults(GTK_BOX(vbox_hour), hour_label);
	  hour_adj = (GtkAdjustment*)gtk_adjustment_new(1, 0, 23, 1, 3, 3);
	  dialog->hour_select = gtk_spin_button_new(hour_adj, 0, 0);
	  gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(dialog->hour_select),
									  GTK_SHADOW_OUT);
	  gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(dialog->hour_select), TRUE);
	  gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(dialog->hour_select),
										GTK_UPDATE_IF_VALID);
	  gtk_box_pack_start_defaults(GTK_BOX(vbox_hour), dialog->hour_select);
	  gtk_widget_show(vbox_hour);
	  
	  vbox_min = gtk_vbox_new(FALSE, FALSE);
	  min_label = gtk_label_new(_("Min :"));
	  gtk_box_pack_start_defaults(GTK_BOX(vbox_min), min_label);
	  min_adj = (GtkAdjustment*)gtk_adjustment_new(1, 0, 59, 1, 3, 3);
	  dialog->min_select = gtk_spin_button_new(min_adj, 0, 0);
	  gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(dialog->min_select),
									  GTK_SHADOW_OUT);
	  gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(dialog->min_select), TRUE);
	  gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(dialog->min_select),
										GTK_UPDATE_IF_VALID);
	  gtk_widget_show(dialog->min_select);
	  gtk_box_pack_start_defaults(GTK_BOX(vbox_min), dialog->min_select);

	  
	  gtk_box_pack_start_defaults(GTK_BOX(hbox4), vbox_hour);
	  gtk_box_pack_start_defaults(GTK_BOX(hbox4), vbox_min);

	  {
		 Time* tm = get_time_now();
		 gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->hour_select), tm->hour);
		 gtk_spin_button_set_value(GTK_SPIN_BUTTON(dialog->min_select), tm->min);
		 
		 g_free(tm);
	  }
   }
   
   
   /* Msg text */
   hbox2 = gtk_hbox_new(FALSE, FALSE);
   frame2 = gtk_frame_new(_("Message text"));
   gtk_container_set_border_width(GTK_CONTAINER(frame2), GNOME_PAD_SMALL);
   dialog->msg_frame = frame2;
   gtk_frame_set_label_align(GTK_FRAME(frame2), 0.5, 0);
   gtk_container_add(GTK_CONTAINER(frame2), hbox2);
   dialog->msg_box = gtk_text_new(NULL, NULL);
   gtk_text_set_editable(GTK_TEXT(dialog->msg_box), TRUE);
   gtk_widget_set_usize(dialog->msg_box, 250, 100);
   gtk_box_pack_start_defaults(GTK_BOX(hbox2), dialog->msg_box);

   
   
   /* Command box */
   {
      GtkWidget* box;
      GtkWidget* frame;
      
      box = gtk_hbox_new(FALSE, FALSE);
      frame = gtk_frame_new(_("Run Command"));
      gtk_container_set_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
      dialog->command_frame = frame;
      gtk_frame_set_label_align(GTK_FRAME(dialog->command_frame), 0.5, 0);	  
      gtk_container_add(GTK_CONTAINER(dialog->command_frame), box);
      dialog->command_box = gtk_entry_new();
      gtk_box_pack_start_defaults(GTK_BOX(box), dialog->command_box);
   }
   
   
   
   /* Buttons */
   hbox3 = gtk_hbox_new(TRUE, FALSE);
   frame3 = gtk_frame_new(NULL);
   gtk_container_set_border_width(GTK_CONTAINER(frame3), GNOME_PAD_SMALL);
   gtk_widget_set_usize(hbox3, 255, 20);
   gtk_container_set_border_width(GTK_CONTAINER(frame3), 4);
   gtk_container_add(GTK_CONTAINER(frame3), hbox3);
   dialog->add = gtk_button_new_with_label(_("Add"));
   gtk_signal_connect(GTK_OBJECT(dialog->add), "clicked",
					  GTK_SIGNAL_FUNC(add_button_clicked), NULL);
   gtk_box_pack_start_defaults(GTK_BOX(hbox3), dialog->add);
   
   dialog->cancel = gtk_button_new_with_label(_("Cancel"));
   gtk_signal_connect(GTK_OBJECT(dialog->cancel), "clicked",
					  GTK_SIGNAL_FUNC(cancel_button_clicked), NULL);
   gtk_box_pack_start_defaults(GTK_BOX(hbox3), dialog->cancel);

   gtk_box_pack_start_defaults(GTK_BOX(vbox), frame1);
   gtk_box_pack_start_defaults(GTK_BOX(vbox), frame4);
   gtk_box_pack_start_defaults(GTK_BOX(vbox), dialog->msg_frame);
   gtk_box_pack_start_defaults(GTK_BOX(vbox), dialog->command_frame);
   gtk_box_pack_start_defaults(GTK_BOX(vbox), frame3);
 
   gtk_widget_show_all(vbox);
   gtk_widget_hide(dialog->command_frame);
   gtk_widget_show(dialog->window);
}
