#ifndef _ALARM_APPLET_H_
#define _ALARM_APPLET_H_


#include <stdio.h>
#include <gnome.h>
#include <applet-widget.h>
#include <time.h>
#include <unistd.h>
#include "alarm.xpm"
#include "alarm2.xpm"


#define VERSION     "0.8.7"
#define MAX_ALARMS   25

#ifndef PACKAGE 
#define PACKAGE "gnome-applets"
#endif
#ifndef GNOMELOCALEDIR
#define GNOMELOCALEDIR "/usr/share/locale"
#endif

#ifdef MY_DEBUG
#define ddebug(fmt, args...)  \
	 fprintf(stderr, "%s %d: ", __FILE__, __LINE__); \
	 fprintf(stderr, fmt, ## args);
#define bdebug(boolean, fmt, args...) \
	 if(boolean)\
	 {\
			 fprintf(stderr, "%s %d: ", __FILE__, __LINE__);\
			 fprintf(stderr, fmt, ## args);\
	 }
#define dump_alarm(func, alarm) \
	 ddebug("Function name = %s\n", (func));\
	 ddebug("Alarm ref count = %d\n", (alarm)->ref_count);\
	 ddebug("Alarm hour = %d\n", (alarm)->hour);\
	 ddebug("Alarm min = %d\n", (alarm)->min);\
	 ddebug("Alarm type = %d\n", (alarm)->alarm_type);\
	 ddebug("Alarm persistant = %s\n", (alarm)->persistant ? "yes" : "no");\
	 bdebug((alarm)->msg_set, "Alarm msg = %s\n", (alarm)->msg_txt->str);\
	 bdebug((alarm)->command_set, "Alarm cmd = %s\n", (alarm)->command->str);
#else
#define ddebug(fmt, args...)
#define dump_alarm(func, alarm) 
#define bdebug(boolean, fmt, args) 
#endif



typedef struct _alarm_applet AlarmApplet;
typedef struct _alarm Alarm;
typedef enum
{
   ALARM_SOUND = 0,
   ALARM_VISUAL = 1,
   ALARM_DIALOG = 2,
   ALARM_COMMAND = 3

} AlarmType;


typedef enum
{
   ALARM_STATE_NORMAL = 0,
   ALARM_STATE_VISUAL_RING = 1,
   ALARM_STATE_SOUND_RING = 2
   
} AlarmState;



struct _alarm_applet
{
   GtkWidget* applet;
   GtkWidget* drawing_area;
   GtkWidget* box;
   GtkWidget* hbox;
   GtkWidget* img_frame;
   GtkWidget* button_frame;
   GtkWidget* list_button;
   GdkPixmap* alarm_pm;
   GdkPixmap* alarm_pm2;
   GdkBitmap* mask;
   AlarmState alarm_state;

   /* Config stuff : private */
   gint timeout_tag;
   gint redraw_tag;
   GString* sound_file;
   GString* anim_file;
   gint vol_level;
   gint timeout_delay;
   gint redraw_delay;
   gboolean draw_image;
   gboolean with_sound;
   PanelOrientType orient;
};


struct _alarm
{
   AlarmType alarm_type;
   int hour;
   int min;
   GString* msg_txt;
   GString* command;
   gboolean msg_set;
   gboolean command_set;
   gboolean modal_dialog;
   
   /* private */
   gint ref_count;
   gboolean persistant;
};


/* Dialog stuff */
void show_add_alarm_dialog(void);
void destroy_dialog(void);

/* Alarm stuff */
void add_alarm(Alarm* a);
void activate_alarm(Alarm* a);
void delete_alarm(Alarm* a);
void alarm_set_msg(Alarm* a, gchar* msg);
void alarm_set_command(Alarm* a, gchar* msg);
void init_alarm_store(void);
void destroy_alarms(void);
Alarm* new_alarm(void);
GList* get_alarm_list(void);
void delete_alarm_with_id(gint id);
Alarm* find_alarm_with_id(gint id);
void save_persistant_alarms(gchar* cfgpath);
void load_persistant_alarms(gchar* cfgpath);


/* Applet stuff */
gint redraw_timeout(gpointer data);
gint timeout_func(gpointer data);
void set_alarm_state(AlarmState state);
gchar* get_sound_file_name(void);
void set_sound_file_name(gchar* file);
gchar* get_anim_file_name(void);
void set_anim_file_name(gchar* file);


/* Alarm list stuff */
void show_popup_dialog(void);
void destroy_popup(void);


/* Alarm sound stuff */
void destroy_sound(void);
void init_sound(void);
void play_sound_alarm(void);
void stop_sound_alarm(void);
gint get_sound_vol_level(void);
void change_volume(gint vol);
void load_new_sound_file(gchar* filename);
void preview_sound_file(gchar* filename);


/* DND stuff */
void drag_data_received(GtkWidget* w, GdkDragContext* con,
						gint x, gint y, GtkSelectionData* sel_data,
						guint info, guint time);
void dnd_add_alarm_file(gchar* file);

#endif

