package shell32;

use strict;

require Exporter;

use wine;
use vars qw(@ISA @EXPORT @EXPORT_OK);

@ISA = qw(Exporter);
@EXPORT = qw();
@EXPORT_OK = qw();

my $module_declarations = {
    "SHRegDeleteKeyA" => ["long",  ["long", "str"]],
    "SHChangeNotifyRegister" => ["long",  ["long", "long", "long", "long", "long", "ptr"]],
    "SHChangeNotifyDeregister" => ["long",  ["long"]],
    "SHChangeNotifyUpdateEntryList" => ["long",  ["long", "long", "long", "long"]],
    "ILGetDisplayName" => ["long",  ["ptr", "str"]],
    "ILFindLastID" => ["ptr",  ["ptr"]],
    "ILRemoveLastID" => ["long",  ["ptr"]],
    "ILClone" => ["ptr",  ["ptr"]],
    "ILCloneFirst" => ["ptr",  ["ptr"]],
    "ILGlobalClone" => ["ptr",  ["ptr"]],
    "ILIsEqual" => ["long",  ["ptr", "ptr"]],
    "ILIsParent" => ["long",  ["ptr", "ptr", "long"]],
    "ILFindChild" => ["ptr",  ["ptr", "ptr"]],
    "ILCombine" => ["ptr",  ["ptr", "ptr"]],
    "ILLoadFromStream" => ["long",  ["ptr", "ptr"]],
    "ILSaveToStream" => ["long",  ["ptr", "ptr"]],
    "SHILCreateFromPath" => ["long",  ["ptr", "ptr", "ptr"]],
    "PathIsRoot" => ["long",  ["ptr"]],
    "PathBuildRoot" => ["ptr",  ["ptr", "long"]],
    "PathFindExtension" => ["ptr",  ["ptr"]],
    "PathAddBackslash" => ["ptr",  ["ptr"]],
    "PathRemoveBlanks" => ["void",  ["ptr"]],
    "PathFindFileName" => ["ptr",  ["ptr"]],
    "PathRemoveFileSpec" => ["long",  ["ptr"]],
    "PathAppend" => ["long",  ["ptr", "ptr"]],
    "PathCombine" => ["ptr",  ["ptr", "ptr", "ptr"]],
    "PathStripPath" => ["void",  ["ptr"]],
    "PathIsUNC" => ["long",  ["ptr"]],
    "PathIsRelative" => ["long",  ["ptr"]],
    "PathIsExe" => ["long",  ["ptr"]],
    "PathFileExists" => ["long",  ["ptr"]],
    "PathMatchSpec" => ["long",  ["ptr", "ptr"]],
    "PathMakeUniqueName" => ["long",  ["ptr", "long", "ptr", "ptr", "ptr"]],
    "PathSetDlgItemPath" => ["void",  ["long", "long", "ptr"]],
    "PathQualify" => ["long",  ["ptr"]],
    "PathStripToRoot" => ["long",  ["ptr"]],
    "PathResolve" => ["long",  ["ptr", "ptr", "long"]],
    "PathGetArgs" => ["ptr",  ["ptr"]],
    "DoEnvironmentSubst" => ["long",  ["ptr", "ptr"]],
    "DragAcceptFiles" => ["void",  ["long", "long"]],
    "PathQuoteSpaces" => ["void",  ["ptr"]],
    "PathUnquoteSpaces" => ["void",  ["ptr"]],
    "PathGetDriveNumber" => ["long",  ["ptr"]],
    "ParseField" => ["long",  ["ptr", "long", "ptr", "long"]],
    "ExitWindowsDialog" => ["void",  ["long"]],
    "PickIconDlg" => ["long",  ["long", "str", "long", "ptr"]],
    "GetFileNameFromBrowse" => ["long",  ["long", "str", "long", "str", "str", "str", "str"]],
    "DriveType" => ["long",  ["long"]],
    "IsNetDrive" => ["long",  ["long"]],
    "Shell_MergeMenus" => ["long",  ["long", "long", "long", "long", "long", "long"]],
    "SHGetSetSettings" => ["void",  ["long", "long", "long"]],
    "SHCreateDefClassObject" => ["long",  ["ptr", "ptr", "ptr", "ptr", "ptr"]],
    "Shell_GetImageList" => ["long",  ["ptr", "ptr"]],
    "Shell_GetCachedImageIndex" => ["long",  ["ptr", "long", "long"]],
    "SHShellFolderView_Message" => ["long",  ["long", "long", "long"]],
    "PathYetAnotherMakeUniqueName" => ["long",  ["str", "str", "str", "str"]],
    "SHMapPIDLToSystemImageListIndex" => ["long",  ["ptr", "ptr", "ptr"]],
    "OleStrToStrN" => ["long",  ["ptr", "long", "ptr", "long"]],
    "StrToOleStrN" => ["long",  ["wstr", "long", "ptr", "long"]],
    "DragFinish" => ["void",  ["long"]],
    "DragQueryFile" => ["long",  ["long", "long", "str", "long"]],
    "DragQueryFileA" => ["long",  ["long", "long", "str", "long"]],
    "CIDLData_CreateFromIDArray" => ["long",  ["ptr", "long", "ptr", "ptr"]],
    "SHRegisterDragDrop" => ["long",  ["long", "ptr"]],
    "SHRevokeDragDrop" => ["long",  ["long"]],
    "SHDoDragDrop" => ["long",  ["long", "ptr", "ptr", "long", "ptr"]],
    "SHCloneSpecialIDList" => ["ptr",  ["long", "long", "long"]],
    "PathGetShortPath" => ["ptr",  ["ptr"]],
    "SHLogILFromFSIL" => ["ptr",  ["ptr"]],
    "StrRetToStrN" => ["long",  ["ptr", "long", "ptr", "ptr"]],
    "SHWaitForFileToOpen" => ["long",  ["ptr", "long", "long"]],
    "SHGetRealIDL" => ["ptr",  ["ptr", "ptr", "long"]],
    "SetAppStartingCursor" => ["long",  ["long", "long"]],
    "SHRestricted" => ["long",  ["long"]],
    "SHCoCreateInstance" => ["long",  ["str", "ptr", "ptr", "ptr", "ptr"]],
    "SignalFileOpen" => ["long",  ["long"]],
    "FileMenu_DeleteAllItems" => ["long",  ["long"]],
    "FileMenu_DrawItem" => ["long",  ["long", "ptr"]],
    "FileMenu_FindSubMenuByPidl" => ["long",  ["long", "ptr"]],
    "FileMenu_GetLastSelectedItemPidls" => ["long",  ["long", "ptr", "ptr"]],
    "FileMenu_HandleMenuChar" => ["long",  ["long", "long"]],
    "FileMenu_InitMenuPopup" => ["long",  ["long"]],
    "FileMenu_InsertUsingPidl" => ["long",  ["long", "long", "ptr", "long", "long", "ptr"]],
    "FileMenu_Invalidate" => ["void",  ["long"]],
    "FileMenu_MeasureItem" => ["long",  ["long", "ptr"]],
    "FileMenu_ReplaceUsingPidl" => ["long",  ["long", "long", "ptr", "long", "ptr"]],
    "FileMenu_Create" => ["long",  ["long", "long", "long", "long", "long"]],
    "FileMenu_AppendItem" => ["long",  ["long", "ptr", "long", "long", "long", "long"]],
    "FileMenu_TrackPopupMenuEx" => ["long",  ["long", "long", "long", "long", "long", "ptr"]],
    "FileMenu_DeleteItemByCmd" => ["long",  ["long", "long"]],
    "FileMenu_Destroy" => ["void",  ["long"]],
    "IsLFNDrive" => ["long",  ["str"]],
    "FileMenu_AbortInitMenu" => ["void",  []],
    "SHFlushClipboard" => ["long",  []],
    "RunDLL_CallEntry16" => ["long",  ["long", "long", "long", "long", "long"]],
    "SHFreeUnusedLibraries" => ["void",  []],
    "FileMenu_AppendFilesForPidl" => ["long",  ["long", "ptr", "long"]],
    "FileMenu_AddFilesForPidl" => ["long",  ["long", "long", "long", "ptr", "long", "long", "ptr"]],
    "SHOutOfMemoryMessageBox" => ["long",  ["long", "str", "long"]],
    "SHWinHelp" => ["long",  ["long", "long", "long", "long"]],
    "DllGetClassObject" => ["long",  ["ptr", "ptr", "ptr"]],
    "DAD_AutoScroll" => ["long",  ["long", "ptr", "ptr"]],
    "DAD_DragEnter" => ["long",  ["long"]],
    "DAD_DragEnterEx" => ["long",  ["long", "long", "long"]],
    "DAD_DragLeave" => ["long",  []],
    "DragQueryFileW" => ["long",  ["long", "long", "wstr", "long"]],
    "DAD_DragMove" => ["long",  ["long", "long"]],
    "DragQueryPoint" => ["long",  ["long", "ptr"]],
    "DAD_SetDragImage" => ["long",  ["long", "ptr"]],
    "DAD_ShowDragImage" => ["long",  ["long"]],
    "FileMenu_DeleteItemByIndex" => ["long",  ["long", "long"]],
    "FileMenu_DeleteItemByFirstID" => ["long",  ["long", "long"]],
    "FileMenu_DeleteSeparator" => ["long",  ["long"]],
    "FileMenu_EnableItemByCmd" => ["long",  ["long", "long", "long"]],
    "FileMenu_GetItemExtent" => ["long",  ["long", "long"]],
    "PathFindOnPath" => ["long",  ["ptr", "ptr"]],
    "RLBuildListOfPaths" => ["long",  []],
    "SHCLSIDFromString" => ["long",  ["ptr", "ptr"]],
    "SHFind_InitMenuPopup" => ["ptr",  ["long", "long", "long", "long"]],
    "SHLoadOLE" => ["long",  ["long"]],
    "ILGetSize" => ["long",  ["ptr"]],
    "ILGetNext" => ["ptr",  ["ptr"]],
    "ILAppend" => ["ptr",  ["ptr", "ptr", "long"]],
    "ILFree" => ["long",  ["ptr"]],
    "ILGlobalFree" => ["void",  ["ptr"]],
    "ILCreateFromPath" => ["ptr",  ["ptr"]],
    "PathGetExtension" => ["ptr",  ["ptr", "long", "long"]],
    "PathIsDirectory" => ["long",  ["ptr"]],
    "SHRunControlPanel" => ["long",  ["long", "long"]],
    "SHSimpleIDListFromPath" => ["ptr",  ["ptr"]],
    "StrToOleStr" => ["long",  ["wstr", "ptr"]],
    "Win32DeleteFile" => ["long",  ["str"]],
    "SHCreateDirectory" => ["long",  ["ptr", "str"]],
    "CallCPLEntry16" => ["long",  ["long", "ptr", "long", "long", "long", "long"]],
    "SHAddFromPropSheetExtArray" => ["long",  ["long", "long", "long"]],
    "SHCreatePropSheetExtArray" => ["long",  ["long", "str", "long"]],
    "SHDestroyPropSheetExtArray" => ["long",  ["long"]],
    "SHReplaceFromPropSheetExtArray" => ["long",  ["long", "long", "long", "long"]],
    "PathCleanupSpec" => ["long",  ["ptr", "ptr"]],
    "SHValidateUNC" => ["long",  ["long", "long", "long"]],
    "SHCreateShellFolderViewEx" => ["long",  ["ptr", "ptr"]],
    "SHGetSpecialFolderPath" => ["long",  ["long", "ptr", "long", "long"]],
    "SHSetInstanceExplorer" => ["long",  ["ptr"]],
    "RegisterShellHook" => ["long",  ["long", "long"]],
    "ArrangeWindows" => ["long",  ["long", "long", "ptr", "long", "ptr"]],
    "SHFree" => ["void",  ["ptr"]],
    "SHAlloc" => ["ptr",  ["long"]],
    "SHAbortInvokeCommand" => ["long",  []],
    "SHInitRestricted" => ["long",  ["str", "str"]],
    "SHGetDataFromIDListA" => ["long",  ["ptr", "ptr", "long", "ptr", "long"]],
    "SHGetDataFromIDListW" => ["long",  ["ptr", "ptr", "long", "ptr", "long"]],
    "PathParseIconLocation" => ["long",  ["ptr"]],
    "PathRemoveExtension" => ["void",  ["ptr"]],
    "PathRemoveArgs" => ["void",  ["ptr"]],
    "SheChangeDirW" => ["long",  ["wstr"]],
    "SheGetDirW" => ["long",  ["wstr", "wstr"]],
    "ShellAboutA" => ["long",  ["long", "str", "str", "long"]],
    "ShellAboutW" => ["long",  ["long", "wstr", "wstr", "long"]],
    "ShellExecuteA" => ["long",  ["long", "str", "str", "str", "str", "long"]],
    "ShellExecuteEx" => ["long",  ["ptr"]],
    "ShellExecuteExA" => ["long",  ["ptr"]],
    "ShellExecuteExW" => ["long",  ["ptr"]],
    "ShellExecuteW" => ["long",  ["long", "wstr", "wstr", "wstr", "wstr", "long"]],
    "Shell_NotifyIcon" => ["long",  ["long", "ptr"]],
    "Shell_NotifyIconA" => ["long",  ["long", "ptr"]],
    "Shell_NotifyIconW" => ["long",  ["long", "ptr"]],
    "SHRegOpenKeyA" => ["long",  ["long", "str", "ptr"]],
    "SHRegOpenKeyW" => ["long",  ["long", "wstr", "ptr"]],
    "SHRegQueryValueExA" => ["long",  ["long", "str", "ptr", "ptr", "ptr", "ptr"]],
    "SHRegQueryValueW" => ["long",  ["long", "wstr", "wstr", "ptr"]],
    "SHRegQueryValueExW" => ["long",  ["long", "wstr", "ptr", "ptr", "ptr", "ptr"]],
    "SHRegDeleteKeyW" => ["long",  ["long", "wstr"]],
    "SHAllocShared" => ["long",  ["ptr", "long", "long"]],
    "SHLockShared" => ["ptr",  ["long", "long"]],
    "SHUnlockShared" => ["long",  ["ptr"]],
    "SHFreeShared" => ["long",  ["long", "long"]],
    "NTSHChangeNotifyRegister" => ["long",  ["long", "long", "long", "long", "long", "ptr"]],
    "NTSHChangeNotifyDeregister" => ["long",  ["long"]],
    "SHChangeNotification_Lock" => ["long",  ["long", "long", "undef", "ptr"]],
    "SHChangeNotification_Unlock" => ["long",  ["long"]],
    "PathIsSameRoot" => ["long",  ["ptr", "ptr"]],
    "ReadCabinetState" => ["long",  ["long", "long"]],
    "WriteCabinetState" => ["long",  ["long"]],
    "PathProcessCommand" => ["long",  ["ptr", "ptr", "long", "long"]],
    "FileIconInit" => ["long",  ["long"]],
    "IsUserAdmin" => ["long",  []],
    "CommandLineToArgvW" => ["ptr",  ["wstr", "ptr"]],
    "Control_FillCache_RunDLL" => ["long",  ["long", "long", "long", "long"]],
    "Control_RunDLL" => ["void",  ["long", "long", "str", "long"]],
    "DllCanUnloadNow" => ["long",  []],
    "DllGetVersion" => ["long",  ["ptr"]],
    "DllInstall" => ["long",  ["long", "wstr"]],
    "DoEnvironmentSubstA" => ["long",  ["str", "str"]],
    "DoEnvironmentSubstW" => ["long",  ["wstr", "wstr"]],
    "DuplicateIcon" => ["long",  ["long", "long"]],
    "ExtractAssociatedIconA" => ["long",  ["long", "str", "ptr"]],
    "ExtractAssociatedIconExA" => ["long",  ["long", "long", "long", "long"]],
    "ExtractAssociatedIconExW" => ["long",  ["long", "long", "long", "long"]],
    "ExtractIconA" => ["long",  ["long", "str", "long"]],
    "ExtractIconEx" => ["long",  ["ptr", "long", "ptr", "ptr", "long"]],
    "ExtractIconExA" => ["long",  ["str", "long", "ptr", "ptr", "long"]],
    "ExtractIconExW" => ["long",  ["wstr", "long", "ptr", "ptr", "long"]],
    "ExtractIconW" => ["long",  ["long", "wstr", "long"]],
    "FindExecutableA" => ["long",  ["str", "str", "str"]],
    "FindExecutableW" => ["long",  ["wstr", "wstr", "wstr"]],
    "FreeIconList" => ["void",  ["long"]],
    "SHAddToRecentDocs" => ["long",  ["long", "ptr"]],
    "SHAppBarMessage" => ["long",  ["long", "ptr"]],
    "SHBrowseForFolder" => ["ptr",  ["ptr"]],
    "SHBrowseForFolderA" => ["ptr",  ["ptr"]],
    "SHBrowseForFolderW" => ["ptr",  ["ptr"]],
    "SHChangeNotify" => ["void",  ["long", "long", "ptr", "ptr"]],
    "SHFileOperation" => ["long",  ["ptr"]],
    "SHFileOperationA" => ["long",  ["ptr"]],
    "SHFileOperationW" => ["long",  ["ptr"]],
    "SHGetDesktopFolder" => ["long",  ["ptr"]],
    "SHGetFileInfo" => ["long",  ["ptr", "long", "ptr", "long", "long"]],
    "SHGetFileInfoA" => ["long",  ["str", "long", "ptr", "long", "long"]],
    "SHGetFileInfoW" => ["long",  ["wstr", "long", "ptr", "long", "long"]],
    "SHGetFolderLocation" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "SHGetFolderPathA" => ["long",  ["long", "long", "long", "long", "str"]],
    "SHGetFolderPathW" => ["long",  ["long", "long", "long", "long", "wstr"]],
    "SHGetInstanceExplorer" => ["long",  ["ptr"]],
    "SHGetMalloc" => ["long",  ["ptr"]],
    "SHGetPathFromIDList" => ["long",  ["ptr", "ptr"]],
    "SHGetPathFromIDListA" => ["long",  ["ptr", "str"]],
    "SHGetPathFromIDListW" => ["long",  ["ptr", "wstr"]],
    "SHGetSettings" => ["void",  ["ptr", "long"]],
    "SHGetSpecialFolderLocation" => ["long",  ["long", "long", "ptr"]],
    "SHGetSpecialFolderPathA" => ["long",  ["long", "str", "long", "long"]],
    "SHHelpShortcuts_RunDLL" => ["long",  ["long", "long", "long", "long"]],
    "SHLoadInProc" => ["long",  ["ptr"]]
};

&wine::declare("shell32",%$module_declarations);
push @EXPORT, map { "&" . $_; } sort(keys(%$module_declarations));
1;
