#!/usr/bin/perl -w
#############################################################################
# This spaghetti code is free software ;-)                                  #
#############################################################################
#																		   #
# This program is free software; you can redistribute it and/or modify      #
# it under the terms of the GNU General Public License as published by      #
# the Free Software Foundation; either version 2 of the License, or         #
# (at your option) any later version.                                       #
#																		   #
# This program is distributed in the hope that it will be useful,           #
# but WITHOUT ANY WARRANTY; without even the implied warranty of            #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
# GNU Library General Public License for more details.                      #
#															               #
# You should have received a copy of the GNU General Public License         #
# along with this program; if not, write to the Free Software               #
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.#
#																		   #
# written by Olaf Schubert, olafs@web.de             					   #
#############################################################################

### configuration ###########################################################
@conf_file = (1,1);
open (CONF, '<./squid-log-analyzer.conf') or die('could NOT open file');;
@conf_file = <CONF>;
close (CONF);
$nr_lines=0;$log_file=0;
foreach $line (@conf_file)
{
	if (!($line =~ m/\#/))
	{
		@line_split = split / /, $line;
		if ($line_split[0] eq 'nr_lines') { $nr_lines = $line_split[1]; }
		if ($line_split[0] eq 'log_file') { $log_file = $line_split[1]; }
	}
}

if (($log_file eq '') or ($nr_lines eq '')) { die("Error in Configuration-file!"); }

#cut the break-line off
chop ($nr_lines);

#if you like to override the settings in the conf-file uncomment this:
#where the Log-file is (on RedHat 7.0 it's /var/log/squid/access.log)
#$log_file = '/var/log/squid/access.log';

#number of lines to be displayed, if 0 all lines are displayed.
#$nr_lines = 10;


###########################################################################
### program begins here, don't edit unless you know what you're doing! ####

#if all lines should be displayed:
if ($nr_lines eq '0')
{ 
	@logdata = `cat $log_file`;  #read file into an array (with the 'CAT'-Command)
}
else
{ 
	@logdata = `tail -n $nr_lines $log_file`; # read nr_lines of logfile
}

#read current time...
($null,$minute,$hour,$day,$month,$year,$null,$null,$null)=localtime(time); #lese aktuelle Zeitho
$year = $year + 1900;
$month=$month + 1;

$www_anz = 0; #init of some vars
$cache_anz = 0;

#print html-header
print "<HTML><HEAD><TITLE>Squid-Log-Datei until $day\.$month\.$year<\/TITLE>";
print "</HEAD><BODY><h2>Surf-Statistik<h2/><h3>Stand\:$day\.$month\.$year um $hour\:$minute Uhr</h3>";
print "Loading data\.\.\.<br>max.$nr_lines lines<br><br><table border=\"1\">";
print '<tr><td>Date</td><td>PC</td><td>Internet/<br>Cache?</td><td>loaded file</td><td>kind of doc</td></tr>';

#parse logfile:
foreach $logfile_line (@logdata)
{
$dok_erledigt=0;
$logfile_line =~ s/ /\+/g;
@line = split /\+/, $logfile_line; #split line

if (!($logfile_line eq " ")) { print '<tr>'; }
$datum_bearbeitet='0';
foreach $tempvar (@line)
{
	$bearbeitet='0';
#Date:
	if (($tempvar =~ m/\d+\.\d+/) and  ( $datum_bearbeitet eq 0))
	{
		#convert UTC-Date into human-readable format:
		($null, $minute, $hour, $day, $month, $year, $null, $null, $null )= localtime($tempvar);
		$year=$year+1900;
		if ($minute < 10) { $minute = '0'.$minute;} #add a 0 if minute <10
		print "<td>$day\.$month\.$year, $hour:$minute</td>";
		$datum_bearbeitet = '1';
	}

# print who (IP) requested the document
	if (($tempvar =~ m/192\.168\./) and ($bearbeitet eq 0))
	{
		$ip = $tempvar;
		$ip =~ s/192\.168//;
		$ip = '192.168'.$ip;
#if you don't like to have some pictures comment the following line: (and uncomment the following line)
		print "<td><img src='pc.jpg'>&nbsp;&nbsp;$ip</td> ";
#		print "<td>$ip</td> ";
		$bearbeitet = '1';
	}

#requested URL:
	if (($tempvar =~ m/http:\/\//) and ($bearbeitet eq '0'))
	{
		$doku = $tempvar;
		if ($dok_erledigt==0) { print "<td>$doku</td>"; }
		$dok_erledigt=1;
		$bearbeitet = '1';
	}

#Cache/WWW?
	if (($tempvar =~ m/TCP/) and ($bearbeitet eq '0'))
	{
		$cache_text = "";
		$cache = $tempvar;
		if ($cache =~ m/HIT/) #if the file was in the cache show a nice picture :-)
		{
			$cache_text = '<img src="disk.gif" alt="cache">';
			$cache_anz++;
		}
		if ($cache =~ m/MISS/) #if the file had to be downloaded show another picture :-)
		{
			$cache_text = '<img src="www.gif" alt="www">';
			$www_anz++;
		}
		print "<td><center>$cache_text</center></td>";
	}

#Format:
	$format = ""; #init var
	if ( $bearbeitet eq '0')
	{

	if ($tempvar=~ m/image\//) #if requested document was a picture print it out
	{
		$format = 'image';
	}	
	if ($tempvar =~ m/text\//) #if it was a text print it out
	{
		$format = 'text';
	}
	if ($tempvar =~ m/application\//)
	{
		$format = 'application' #if it was an application (binary file) ...
	}
	}
	if (!($format eq "")) { print "<td>$format</td>"; }
	}
	print "</tr>";
	}
#calculate some numbers:

$gesamt_anz = $www_anz + $cache_anz;
if (!($gesamt_anz<=0))
{
	$www_prozent = $www_anz / $gesamt_anz * 100;
	$cache_prozent = $cache_anz / $gesamt_anz * 100;
}

print "</table>Total: $gesamt_anz files.<br>$cache_anz ( $cache_prozent% ) files cached.<br>$www_anz ( $www_prozent% ) files downloaded";
print "<br><br><hr><br></b><h5>parsed by Squid-Log-analyzer 0.6 (c) by Olaf Schubert, 2000</h5></BODY></HTML>";
