#include "sophie.h"
#include "sophie_core.h"

static void sophie_syslog(char *syslogMessage, ...);
static void sophie_log_virus(char *infected_file, CIEnumSweepResults *scan_results);

int sophie_getline(char *b, int bsize, int bsock)
{
	char c = 0;
	int rc;
	int current_len = 0;

	memset(b, 0, bsize);

	/* I hope I won't find out that there is a chance for infinite loop here :) */
	for(;;)
	{
		rc = read(bsock, &c, 1);

		if (rc == 1)
		{
			if (c == '\n')
				break;
			
			if (current_len >= (bsize - 1))
				continue;

			current_len++;
			*b = c;
			b++;
		}
		else if (rc == 0)
		{
				break; /* EOF */
		}
		else if (rc == -1)
		{
			if (errno == EINTR)
			{
				sophie_print(1, "%s EINTR caught - read() continuing", NOTESTR);
			}
			else
			{
				sophie_print(0, "%s An error occured during read from socket (%s)", WARNSTR, strerror(errno));
				return(-1);
			}
		}
		else
		{
			sophie_print(0, "%s Yay! rc = '%d' - how did this happen?", WARNSTR, rc);
			return(-1);
		}
	}

	return(current_len);
}

/* Checks if the file exists */
int file_exists(char *check_if_exists)
{
	if (access(check_if_exists, F_OK) == -1)
		return(0);

	return(1);
	
}

#ifdef SOPHIE_NET
int sophie_net_scan(int s)
{
	FILE *msgfp;
	char buf[512];
	char readbuf[4096];
	char filename[512];
	char tempdir[256];
	char sock_response[256];
	char sock_response_nl[256];
	char *tmpfilesize;
	long filesize;
	long read_bytes;
	long write_bytes;
	int sophos_result;
	int r;
	int w;
	int outfile;

	struct stat filestat;

	for(;;)
	{
LOOP:
		alarm(config.timeout);

		memset(buf, 0, sizeof(buf));
		memset(filename, 0, sizeof(filename));

		read_bytes = 0;
		write_bytes = 0;
		r = 0;
		w = 0;
		sophos_result = 0;
		filesize = 9;

		msgfp = fdopen(s, "r");

		if (!(fgets(buf, sizeof(buf)-1, msgfp)))
		{
			if (ferror(msgfp))
			{
				if (errno == EAGAIN)
				{
					goto LOOP;
				}
				else
				{
					sophie_print(0, "%s Error reading from network socket [%s]", WARNSTR, strerror(errno));
					write(s, "ERR\n", 4);
				}
			}

			/* If ferror() doesn't return error, it means client has just disconnected */
			return(-1);
		}

		sophie_print(1, "%s Read %d bytes from network socket", NOTESTR, strlen(buf));
					
		/* Strip the newline */
		if (strchr(buf, '\n'))
			*strchr(buf, '\n') = '\0';
		if (strchr(buf, '\r'))
			*strchr(buf, '\r') = '\0';

		if (!(strncasecmp("QUIT", buf, 4)))
		{
			sophie_print(1, "%s Closing connection", NOTESTR);
			write(s, "BYE\n", 4);
			return(-1);
		}

		/* Check if / delimiter is in the buffer */
		if (!strrchr(buf, '/'))
		{
			sophie_print(0, "%s Delimiter '/' not found", WARNSTR);
			write(s, "AGAIN\n", 6);
			goto LOOP;
		}
		else
		{
			tmpfilesize = strrchr(buf, '/')+1;
			*strrchr(buf, '/') = '\0';
		}

		/* Convert the string into long integer */
		/* If it is not a number, result will be 0 */
		filesize = atol(tmpfilesize);
	
		if (filesize == 0)
		{
			sophie_print(0, "%s Filesize is 0 - probably incorrectly formatted input was supplied", WARNSTR);
			write(s, "AGAIN\n", 6);
			goto LOOP;
		}

		if (strpbrk(buf, "/\\"))
		{
			sophie_print(0, "%s Filename contains characters which I really don't like", WARNSTR);
			write(s, "AGAIN\n", 6);
			goto LOOP;
		}

		/* Clear the virus name */
		memset(VIR_NAME, 0, sizeof(VIR_NAME));

		/* Clear the sock response */
		memset(sock_response, 0, sizeof(sock_response));
		memset(sock_response_nl, 0, sizeof(sock_response_nl));

		/* Create temp dir first */
		snprintf(tempdir, sizeof(tempdir)-1, "%s/sophie.%lu", config.net_tempdir, (unsigned long) getpid() * getppid());
		if (file_exists(tempdir))
		{
			sophie_print(0, "%s Directory '%s' already exist - could not create. Aborting.", WARNSTR, tempdir);
			write(s, "ERR\n", 4);
			return(-1);
		}

		if ((mkdir(tempdir, 0700)) == -1)
		{
			sophie_print(0, "%s Error while creating temporary directory '%s'. Aborting.", WARNSTR, tempdir);
			write(s, "ERR\n", 4);
			return(-1);
		}

		sophie_print(1, "%s Temporary directory '%s' created.", NOTESTR, tempdir);

		/* Open output file */
		snprintf(filename, sizeof(filename)-1, "%s/%s", tempdir, buf);

		if ((outfile = open(filename, O_CREAT | O_RDWR, 0600)) == -1)
		{
			sophie_print(0, "%s Error opening output file '%s'. Aborting.", WARNSTR, filename);
			write(s, "ERR\n", 4);
			return(-1);
		}

		/*
			We write OK string back to the socket - remote side can start
			sending file
		*/
		write(s, "OK\n", 3);

		/* Write the file */
		while(read_bytes < filesize)
		{
LOOP2:
			r = read(s, readbuf, sizeof(readbuf));

			if (r == -1)
			{	
				if (errno == EAGAIN)
				{
					goto LOOP2;
				}
				else
				{
					sophie_print(0, "%s Error while reading file data from socket [%s].", WARNSTR, strerror(errno));
					close(outfile);
					unlink(filename);
					rmdir(tempdir);
					goto LOOP;
				}
			}

			/* eof */
			if (r == 0)
				break;

			/*
			  This is in case someone says that file is 100 bytes, but sends 130
			  we'll just write as much as he said initially
			*/
			if ((read_bytes + r) > filesize)
				w = write(outfile, readbuf, filesize - read_bytes);
			else
				w = write(outfile, readbuf, r);

			read_bytes += r;
			write_bytes += w;

			if (w == -1)
			{
				write(s, "ERR\n", 4);
				sophie_print(0, "%s write() error [%s]", WARNSTR, strerror(errno));
			}

		}
	
		close(outfile);

		/* Now, let's decide if we'll scan file or a dir... */
		if ((stat(filename, &filestat)) == -1)
		{
			write(s, "ERR\n", 4);
			sophie_print(0, "%s stat() on '%s' failed [%s]", WARNSTR, filename, strerror(errno));
			unlink(filename);
			rmdir(tempdir);
			goto LOOP;
		}

		if (!(S_ISREG(filestat.st_mode)))
		{
			write(s, "ERR\n", 4);
			sophie_print(0, "%s Error - target for scanning is not a file. How could that happen!?", WARNSTR);
			unlink(filename);
			rmdir(tempdir);
			goto LOOP;
		}

		sophos_result = sophie_scanfile(filename);

		unlink(filename);
		rmdir(tempdir);

		/* Clear the response buffer */
		memset(sock_response, 0, sizeof(sock_response));

		/* "Craft" the response (this is so lame) - FIXME */
		if ( (VIR_NAME[0] != '\0') && (config.show_virusname == 1) )
			snprintf(sock_response, sizeof(sock_response)-1, "%d:%s", sophos_result, VIR_NAME);
		else
			snprintf(sock_response, sizeof(sock_response)-1, "%d", sophos_result);

		sophie_print(1, "%s Response = '%s'", NOTESTR, sock_response);

		snprintf(sock_response_nl, sizeof(sock_response_nl)-1, "%s\n", sock_response);
		/* Complain on errors - do nothing if everything is okay */
		if (write(s, sock_response_nl, strlen(sock_response_nl)) > 0)
			sophie_print(1, "%s Response '%s' sent", NOTESTR, sock_response);
		else
			sophie_print(0, "%s write() to remote socket failed [%s]", WARNSTR, strerror(errno));
		
		alarm(0);
	}

	return 1;
}
#endif

/*
  If called with 'debug = 0', message will be printed always (used for errors)
  If called with 'debug = 1', message will be printed only if SOPHIE_DEBUG == 1
*/
void sophie_print(int debug, char *printMessage, ...)
{
	char printMsg[512];

	/* Timestamps... */
	struct tm *timestamp;
	time_t tt;
	char timedatestamp[24];

	pid_t dpid;

	va_list argptr;
	va_start(argptr, printMessage);
	vsnprintf(printMsg, sizeof(printMsg)-1, printMessage, argptr);
	va_end(argptr);

	/* If running as a daemon, send messages to syslog */
	if (SOPHIE_DAEMON > 0)
	{
		if (debug == 0)
		{
			sophie_syslog("%s", printMsg);
		}
		else if (debug == 1 && SOPHIE_DEBUG == 1)
		{
			dpid = getpid();
			sophie_syslog("%s /DEBUG,%d/", printMsg, dpid);
		}
	}
	else
	{
		if (config.timestamps == 1)
		{
			memset(timedatestamp, 0, sizeof(timedatestamp));
			tt = time(NULL);
			timestamp = localtime(&tt);

			strftime(timedatestamp, sizeof(timedatestamp)-1, "%Y-%m-%d %T", timestamp);

			if (debug == 0)
			{
				fprintf(stderr, "[%s] %s\n", timedatestamp, printMsg);
			}
			else if (debug == 1 && SOPHIE_DEBUG == 1)
			{
				dpid = getpid();
				fprintf(stderr, "[%s] %s /DEBUG,%d/\n", timedatestamp, printMsg, (u_int) dpid);
			}
		}
		else
		{
			if (debug == 0)
			{
				fprintf(stderr, "%s\n", printMsg);
			}
			else if (debug == 1 && SOPHIE_DEBUG == 1)
			{
				dpid = getpid();
				fprintf(stderr, "%s /DEBUG,%d/\n", printMsg, (u_int) dpid);
			}
		}
	}
}

/*
  Logs a message to syslog
*/
static void sophie_syslog(char *syslogMessage, ...)
{
	char logMsg[512];

	va_list argptr;
	va_start(argptr, syslogMessage);
	vsnprintf(logMsg, sizeof(logMsg)-1, syslogMessage, argptr);
	va_end(argptr);

	if ((config.logfacility < 0) || (config.logpriority < 0))
		return;

	openlog(config.logname, LOG_PID | LOG_CONS, config.logfacility);
	syslog(config.logpriority, "%s\n", logMsg);
	closelog();
}

/*
  If virus is found, logs the filename/virusname into syslog
*/
static void sophie_log_virus(char *infected_file, CIEnumSweepResults *scan_results)
{
	HRESULT hr;

	OLECHAR virusName[256];
	CISweepResults *details = NULL;
	SOPHOS_ULONG fetched;

	while (scan_results->pVtbl->Next(scan_results, 1, (void **) &details, &fetched) == SOPHOS_S_OK)
	{
		hr = details->pVtbl->GetVirusName(details, sizeof(virusName)-1, (LPOLESTR) virusName, NULL);

		if (SOPHOS_FAILED(hr))
		{
			sophie_print(0, "%s Could not get a virus name for infected file '%s'", WARNSTR, infected_file);
		}
		else
		{
			sophie_print(0, "%s Scan result => '%s' infected with virus '%s'", WARNSTR, infected_file, virusName);
			/* Remove call to sophie_syslog since sophie_print will do a 
			   a syslog anyway (thanks jobsanzl) */
		}
		strncpy(VIR_NAME, virusName, sizeof(VIR_NAME)-1);

		/* We have to release ISweepResults object */
		if (details)
			details->pVtbl->Release(details);
	}
	
}

/*
  Scans a file (*FILE*, not a directory - keep that in mind) for a virus
*/
int sophie_scanfile(char *scan_file)
{
	HRESULT hr;
	int retval = -1;
	
	CIEnumSweepResults *scan_results = NULL;

	sophie_print(1, "%s Scanning file '%s'", NOTESTR, scan_file);

	hr = pSAVI->pVtbl->SweepFile(pSAVI, scan_file, (REFIID)&SOPHOS_IID_ENUM_SWEEPRESULTS, (void **) &scan_results);

	/* Ouch. Making this one did hurt ;) */
	switch (hr)
	{
		case SOPHOS_S_OK:
		retval = 0;
		break;
		
		case SOPHOS_SAVI_ERROR_VIRUSPRESENT:
		sophie_log_virus(scan_file, scan_results);
		retval = 1;
		break;
		
		case SOPHOS_SAVI_ERROR_INITIALISING:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_INITIALISING);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_INITIALISING, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_TERMINATING:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_TERMINATING);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_TERMINATING, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_SWEEPFAILURE:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_SWEEPFAILURE);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_SWEEPFAILURE, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_NOT_INITIALISED:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_NOT_INITIALISED);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_NOT_INITIALISED, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_IC_INCOMPATIBLE_VERSION:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_IC_INCOMPATIBLE_VERSION);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_IC_INCOMPATIBLE_VERSION, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_IC_ACCESS_DENIED:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_IC_ACCESS_DENIED);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_IC_ACCESS_DENIED, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_IC_SCAN_PREVENTED:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_IC_SCAN_PREVENTED);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_IC_SCAN_PREVENTED, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_DISINFECTION_FAILED:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_DISINFECTION_FAILED);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_DISINFECTION_FAILED, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_DISINFECTION_UNAVAILABLE:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_DISINFECTION_UNAVAILABLE);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_DISINFECTION_UNAVAILABLE, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_UPGRADE_FAILED:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_UPGRADE_FAILED);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_UPGRADE_FAILED, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_SAV_NOT_INSTALLED:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_SAV_NOT_INSTALLED);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_SAV_NOT_INSTALLED, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_INVALID_CONFIG_NAME:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_INVALID_CONFIG_NAME);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_INVALID_CONFIG_NAME, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_INVALID_CONFIG_TYPE:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_INVALID_CONFIG_TYPE);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_INVALID_CONFIG_TYPE, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_INIT_CONFIGURATION:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_INIT_CONFIGURATION);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_INIT_CONFIGURATION, sizeof(ret_error_string)-1);
		retval = -1;
		break;

		case SOPHOS_SAVI_ERROR_NOT_SUPPORTED:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_NOT_SUPPORTED);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_NOT_SUPPORTED, sizeof(ret_error_string)-1);
#ifdef ONLY_FATAL_ERRORS
		retval = 0;
#else
		retval = -1;
#endif
		break;
		
		case SOPHOS_SAVI_ERROR_COULD_NOT_OPEN:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_COULD_NOT_OPEN);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_COULD_NOT_OPEN, sizeof(ret_error_string)-1);
		retval = -1;
		break;

		case SOPHOS_SAVI_ERROR_FILE_COMPRESSED:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_FILE_COMPRESSED);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_FILE_COMPRESSED, sizeof(ret_error_string)-1);
#ifdef ONLY_FATAL_ERRORS
		retval = 0;
#else
		retval = -1;
#endif
		break;
		
		case SOPHOS_SAVI_ERROR_FILE_ENCRYPTED:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_FILE_ENCRYPTED);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_FILE_ENCRYPTED, sizeof(ret_error_string)-1);
#ifdef ONLY_FATAL_ERRORS
		retval = 0;
#else
		retval = -1;
#endif
		break;
		
		case SOPHOS_SAVI_ERROR_INFORMATION_NOT_AVAILABLE:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_INFORMATION_NOT_AVAILABLE);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_INFORMATION_NOT_AVAILABLE, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_ALREADY_INIT:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_ALREADY_INIT);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_ALREADY_INIT, sizeof(ret_error_string)-1);
		retval = -1;
		break;

		case SOPHOS_SAVI_ERROR_STUB:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_STUB);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_STUB, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_BUFFER_TOO_SMALL:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_BUFFER_TOO_SMALL);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_BUFFER_TOO_SMALL, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_CBCK_CONTINUE_THIS:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_CBCK_CONTINUE_THIS);
		strncpy(ret_error_string, SOPHIE_SAVI_CBCK_CONTINUE_THIS, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_CBCK_CONTINUE_NEXT:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_CBCK_CONTINUE_NEXT);
		strncpy(ret_error_string, SOPHIE_SAVI_CBCK_CONTINUE_NEXT, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_CBCK_STOP:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_CBCK_STOP);
		strncpy(ret_error_string, SOPHIE_SAVI_CBCK_STOP, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_CORRUPT:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_CORRUPT);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_CORRUPT, sizeof(ret_error_string)-1);
#ifdef ONLY_FATAL_ERRORS
		retval = 0;
#else
		retval = -1;
#endif
		break;
		
		case SOPHOS_SAVI_ERROR_REENTRANCY:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_REENTRANCY);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_REENTRANCY, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_CALLBACK:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_CALLBACK);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_CALLBACK, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_PARTIAL_INFORMATION:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_PARTIAL_INFORMATION);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_PARTIAL_INFORMATION, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_OLD_VIRUS_DATA:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_OLD_VIRUS_DATA);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_OLD_VIRUS_DATA, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_INVALID_TMP:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_INVALID_TMP);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_INVALID_TMP, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_MISSING_MAIN_VIRUS_DATA:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_MISSING_MAIN_VIRUS_DATA);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_MISSING_MAIN_VIRUS_DATA, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_INFO_IC_ACTIVE:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_INFO_IC_ACTIVE);
		strncpy(ret_error_string, SOPHIE_SAVI_INFO_IC_ACTIVE, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_VIRUS_DATA_INVALID_VER:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_VIRUS_DATA_INVALID_VER);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_VIRUS_DATA_INVALID_VER, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_MUST_REINIT:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_MUST_REINIT);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_MUST_REINIT, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_CANNOT_SET_OPTION:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_CANNOT_SET_OPTION);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_CANNOT_SET_OPTION, sizeof(ret_error_string)-1);
		retval = -1;
		break;
		
		case SOPHOS_SAVI_ERROR_PART_VOL:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_PART_VOL);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_PART_VOL, sizeof(ret_error_string)-1);
#ifdef ONLY_FATAL_ERRORS
		retval = 0;
#else
		retval = -1;
#endif
		break;

		default:
		sophie_print(0, "%s %s", WARNSTR, SOPHIE_SAVI_ERROR_DEFAULT);
		strncpy(ret_error_string, SOPHIE_SAVI_ERROR_DEFAULT, sizeof(ret_error_string)-1);
		retval = -1;
		break;
	}
	
	/* We have to release the scan_results object */
	if (scan_results)
		scan_results->pVtbl->Release(scan_results);

	return(retval);
}

/*
  Cleanup
*/
void sophie_end(void)
{
	if (pSAVI)
	{
		pSAVI->pVtbl->Terminate(pSAVI);
		pSAVI->pVtbl->Release(pSAVI);
	}

	sophie_print(0, "%s pSAVI cleaned up and released/terminated", NOTESTR);

}

/*
  Obtains/logs the information about versions of engine and IDE
*/
void sophie_version(void)
{
	HRESULT hr;

	U32 ide_string_length  = 100;
	CIEnumIDEDetails *IDElist = NULL;
	OLECHAR ide_version_string[101];
	SYSTEMTIME ide_date;
	U32 ide_detects_viruses;
	U32 engine_version;
 
	char syslog_temp[24];

	hr = pSAVI->pVtbl->GetVirusEngineVersion(	pSAVI,
												&engine_version,
												(LPOLESTR) ide_version_string,
												ide_string_length,
												&ide_date,
												&ide_detects_viruses,
												NULL,
												(REFIID) &SOPHOS_IID_ENUM_IDEDETAILS,
												(void **) &IDElist
											 );

	if (SOPHOS_FAILED(hr))
	{
		sophie_print(0, "%s Failed to obtain version information for engine/IDE", WARNSTR);
	}
	else
	{
		sophie_print(0, "Sophos engine    : Sophos engine version %u.%u", (unsigned int) ((engine_version & 0xFFFF0000) >> 16), (unsigned int) (engine_version & 0x0000FFFF));
		sophie_print(0, "Sophie IDE       : Sophos IDE version %s (detects %u viruses)", ide_version_string, (unsigned int) ide_detects_viruses);
		sophie_print(0, "SAVI config      : %s", config.saviconfig ? config.saviconfig : "(using defaults)");
		sophie_print(0, "Max processes    : %d %s", config.maxproc, config.maxproc ? "" : "(no limit)");
		sophie_print(0, "Socket path      : %s", config.socketfile);
		sophie_print(0, "Umask            : %d", config.umask);
		sophie_print(0, "PID file         : %s", config.pidfile);
		sophie_print(0, "Timeout          : %d seconds", config.timeout);
		sophie_print(0, "Running as user  : %s", config.user);
		sophie_print(0, "Socket group     : %s", config.group);
		sophie_print(0, "Logname          : %s", config.logname);

		memset(syslog_temp, 0, sizeof(syslog_temp));
		sophie_lookup_syslog_facility(config.logfacility, syslog_temp, sizeof(syslog_temp));
		sophie_print(0, "Log facility     : %d (%s)", config.logfacility, syslog_temp);

		memset(syslog_temp, 0, sizeof(syslog_temp));
		sophie_lookup_syslog_priority(config.logpriority, syslog_temp, sizeof(syslog_temp));
		sophie_print(0, "Log priority     : %d (%s)", config.logpriority, syslog_temp);

		sophie_print(0, "Error strings?   : %s", config.error_strings ? "yes" : "no");
		sophie_print(0, "Timestamps?      : %s", config.timestamps ? "yes" : "no");
		sophie_print(0, "Show virus name? : %s", config.show_virusname ? "yes" : "no");
		
		sophie_print(0, "Callbacks?       : %s", config.callbacks ? "yes" : "no");
		if (config.callbacks)
		{
			sophie_print(0, "limit_classif    : %d", config.limit_classif);
			sophie_print(0, "limit_nextfile   : %d", config.limit_nextfile);
			sophie_print(0, "limit_decompr    : %d", config.limit_decompr);
			sophie_print(0, "socket_check     : %s", config.socket_check ? "yes" : "no");
		}
#ifdef SOPHIE_NET
		sophie_print(0, "Port             : %d", config.net_port);
		sophie_print(0, "Temporary dir    : %s", config.net_tempdir);
#endif
		sophie_print(0, "Sophie version   : %s", SOPHIE_VERSION);
	}
}
