#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <pwd.h>
#include <grp.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#ifdef __FreeBSD__
#include <netinet/in.h>
#endif
#include <netinet/tcp.h>
#include <sys/un.h>
#include <sys/time.h>
#include <time.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <sys/param.h>
#ifdef HAVE_SYS_SCHED_H
#include <sys/sched.h>
#endif
#ifdef HAVE_SCHED_H
#include <sched.h>
#endif
#include <dirent.h>
#include <fcntl.h>
#include <ctype.h>

/* SAVI includes */
#include "compute.h"
#include "csavi3c.h"

#define SOPHIE_VERSION		"3.05"

/* Some string definitions */
#define	ERRSTR	"ERROR            :"
#define	NOTESTR	"NOTICE           :"
#define	WARNSTR	"WARNING          :"

/* Defaults, for configuration */
#define	DEFAULT_MAX_PROC		20
#define	DEFAULT_PIDFILE			"/var/run/sophie.pid"
#define	DEFAULT_SOCKETFILE		"/var/run/sophie"
#define	DEFAULT_UMASK			0007
#define	DEFAULT_TIMEOUT			300
#define	DEFAULT_LOGNAME			"sophie"
#define	DEFAULT_LOGFACILITY		LOG_MAIL
#define	DEFAULT_LOGPRIORITY		LOG_NOTICE
#define	DEFAULT_ERROR_STRINGS	1
#define	DEFAULT_TIMESTAMPS		0
#define	DEFAULT_SHOW_VIRUSNAME	1
#define	DEFAULT_CALLBACKS		0
#define	DEFAULT_LIMIT_CLASSIF	10
#define	DEFAULT_LIMIT_NEXTFILE	10000
#define	DEFAULT_LIMIT_DECOMPR	1000
#define	DEFAULT_SOCKET_CHECK	0
#ifdef SOPHIE_NET
#define	DEFAULT_NET_PORT		4009
#define	DEFAULT_NET_TEMPDIR		"/tmp"
#endif

#define	SCAN_LOCAL			1
#define	SCAN_NETWORK		2

/* Configuration data */
struct sophie_config {
	char saviconfig[256];
	int maxproc;
	char pidfile[256];
	char socketfile[256];
	int umask;
	char user[32];
	char group[32];
	int timeout;
	char logname[64];
	int logfacility;
	int logpriority;
	int error_strings;
	int timestamps;
	int show_virusname;
	int callbacks;
	int limit_classif;
	int limit_nextfile;
	int limit_decompr;
	int socket_check;
#ifdef SOPHIE_NET
	int net_port;
	char net_tempdir[256];
#endif
};
struct sophie_config config;

struct sophie_notification {
	int socket;
	int interrupted;
	char message[128];
};

extern char *default_configs[];
extern CISavi3 *pSAVI;

#ifndef STDIO_H_DECLARES_VSNPRINTF
extern int vsnprintf(char *, size_t, const char *, va_list);
extern int snprintf(char *, size_t, char *,...);
#endif

#if (!defined(GRP_H_DECLARES_INITGROUPS)) && (!defined(UNISTD_H_DECLARES_INITGROUPS))
extern int initgroups(const char *, gid_t);
#endif

void sophie_init(void);
void sophie_print(int debug, char *printMessage, ...);
void sophie_config_reset(void);
void sophie_set_engine_config(CISavi3 *pSAVI);
void sophie_lookup_syslog_priority(int syslog_int, char *syslog_char, int syslog_char_size);
void sophie_lookup_syslog_facility(int syslog_int, char *syslog_char, int syslog_char_size);
int sophie_load_config(char *config_file);
int sophie_scanfile(char *scan_file);
void sophie_end(void);
void sophie_version(void);
void sophie_show_settings(void);
int sophie_getline(char *b, int bsize, int bsock);
int file_exists(char *check_if_exists);
int sophie_scandir(char *dirpath);
int sophie_net_scan(int s);
int SetNotification(CISavi3 *pSAVI, void *token);

int SOPHIE_DEBUG;
int SOPHIE_DAEMON;
int sock;
int tcp_sock;

char *program_name;
char **program_args;
char VIR_NAME[512];
char ret_error_string[256];
